/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.client;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.config.NEEConfig;
import com.github.vfyjxf.nee.nei.NEECraftingHandler;
import com.github.vfyjxf.nee.nei.NEECraftingHelper;
import com.github.vfyjxf.nee.utils.GuiUtils;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.awt.Point;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Slot;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.input.Keyboard;

public class NEEContainerDrawHandler {
    public static NEEContainerDrawHandler instance = new NEEContainerDrawHandler();
    private static final Color craftableColor = new Color(0.0f, 0.0f, 1.0f, 0.4f);
    private static final Color missingColor = new Color(1.0f, 0.0f, 0.0f, 0.4f);
    public boolean isGtnhNei = true;
    private final List<GuiButton> overlayButtons = new ArrayList<GuiButton>();
    private final Map<Integer, IngredientTracker> trackerMap = new HashMap<Integer, IngredientTracker>();
    private boolean isCraftingTerm;
    private boolean isPatternTerm;
    private int oldPage;
    private int oldType;
    public Field overlayButtonsField;
    public Method getRecipeIndicesMethod;
    private boolean drawRequestTooltip;
    private boolean drawMissingTooltip;
    private boolean drawCraftableTooltip;

    public NEEContainerDrawHandler() {
        try {
            this.overlayButtonsField = GuiRecipe.class.getDeclaredField("overlayButtons");
            this.getRecipeIndicesMethod = GuiRecipe.class.getDeclaredMethod("getRecipeIndices", new Class[0]);
            this.overlayButtonsField.setAccessible(true);
            this.getRecipeIndicesMethod.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            this.isGtnhNei = false;
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (NEEConfig.drawHighlight && event.gui instanceof GuiRecipe) {
            GuiRecipe guiRecipe = (GuiRecipe)event.gui;
            this.isCraftingTerm = GuiUtils.isGuiCraftingTerm((GuiScreen)guiRecipe.firstGui);
            this.isPatternTerm = GuiUtils.isPatternTerm((GuiScreen)guiRecipe.firstGui);
            if (this.isCraftingTerm || this.isPatternTerm) {
                this.oldPage = guiRecipe.page;
                this.oldType = guiRecipe.recipetype;
                this.setOverlayButton(guiRecipe);
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (NEEConfig.drawHighlight && event.gui instanceof GuiRecipe && (this.isCraftingTerm || this.isPatternTerm)) {
            GuiRecipe gui = (GuiRecipe)event.gui;
            IRecipeHandler currentHandler = (IRecipeHandler)gui.currenthandlers.get(gui.recipetype);
            if (NEECraftingHandler.isCraftingTableRecipe(currentHandler)) {
                if (this.trackerMap.isEmpty()) {
                    this.initIngredientTracker(gui);
                }
                if (this.oldPage != gui.page) {
                    this.oldPage = gui.page;
                    this.setOverlayButton(gui);
                    this.initIngredientTracker(gui);
                }
                if (this.oldType != gui.recipetype) {
                    this.oldType = gui.recipetype;
                    this.setOverlayButton(gui);
                    this.initIngredientTracker(gui);
                }
                for (GuiButton button : this.overlayButtons) {
                    IngredientTracker tracker;
                    if (!this.isMouseOverButton(button, event.mouseX, event.mouseY) || this.trackerMap.isEmpty() || (tracker = this.trackerMap.get(button.field_146127_k)) == null) continue;
                    Point offset = gui.getRecipePosition(tracker.getRecipeIndex());
                    for (int i = 0; i < tracker.getIngredients().size(); ++i) {
                        Ingredient ingredient = tracker.getIngredients().get(i);
                        Slot slot = gui.slotcontainer.getSlotWithStack(ingredient.getIngredient(), offset.x, offset.y);
                        if (slot == null) continue;
                        if (this.isCraftingTerm) {
                            if (ingredient.isCraftable() && ingredient.requiresToCraft()) {
                                GuiDraw.drawRect((int)(slot.field_75223_e + gui.field_147003_i), (int)(slot.field_75221_f + gui.field_147009_r), (int)16, (int)16, (int)craftableColor.getRGB());
                                this.drawRequestTooltip = true;
                            }
                            if (!ingredient.requiresToCraft() || ingredient.isCraftable()) continue;
                            GuiDraw.drawRect((int)(slot.field_75223_e + gui.field_147003_i), (int)(slot.field_75221_f + gui.field_147009_r), (int)16, (int)16, (int)missingColor.getRGB());
                            this.drawMissingTooltip = true;
                            continue;
                        }
                        if (!this.isPatternTerm || !ingredient.isCraftable()) continue;
                        GuiDraw.drawRect((int)(slot.field_75223_e + gui.field_147003_i), (int)(slot.field_75221_f + gui.field_147009_r), (int)16, (int)16, (int)craftableColor.getRGB());
                        this.drawCraftableTooltip = true;
                    }
                    this.drawCraftingHelperTooltip((GuiRecipe)event.gui, event.mouseX, event.mouseY);
                }
            }
        }
    }

    private void setOverlayButton(GuiRecipe guiRecipe) {
        this.overlayButtons.clear();
        this.trackerMap.clear();
        ArrayList<Object> overlayButtonList = null;
        if (this.isGtnhNei) {
            try {
                overlayButtonList = new ArrayList<GuiButton>(Arrays.asList((GuiButton[])NEEContainerDrawHandler.instance.overlayButtonsField.get(guiRecipe)));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        } else {
            overlayButtonList = new ArrayList<Object>();
            overlayButtonList.add(ReflectionHelper.getPrivateValue(GuiRecipe.class, (Object)guiRecipe, (String[])new String[]{"overlay1"}));
            overlayButtonList.add(ReflectionHelper.getPrivateValue(GuiRecipe.class, (Object)guiRecipe, (String[])new String[]{"overlay2"}));
        }
        if (overlayButtonList != null) {
            this.overlayButtons.addAll(overlayButtonList);
        }
    }

    private void initIngredientTracker(GuiRecipe gui) {
        for (int i = 0; i < this.overlayButtons.size(); ++i) {
            GuiButton overlayButton = this.overlayButtons.get(i);
            if (!overlayButton.field_146125_m) continue;
            IRecipeHandler handler = (IRecipeHandler)gui.currenthandlers.get(gui.recipetype);
            int recipeIndex = -1;
            if (this.isGtnhNei) {
                try {
                    int OVERLAY_BUTTON_ID_START = 4;
                    List indices = (List)this.getRecipeIndicesMethod.invoke((Object)gui, new Object[0]);
                    int refIndex = overlayButton.field_146127_k - 4;
                    if (refIndex >= 0 && refIndex < indices.size()) {
                        recipeIndex = (Integer)indices.get(refIndex);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            } else {
                recipeIndex = gui.page * handler.recipiesPerPage() + i;
            }
            if (recipeIndex < 0 || handler == null || recipeIndex >= handler.numRecipes()) continue;
            IngredientTracker tracker = this.isCraftingTerm ? new IngredientTracker(gui.firstGui, handler, recipeIndex) : new IngredientTracker(gui, handler, recipeIndex);
            this.trackerMap.put(overlayButton.field_146127_k, tracker);
        }
    }

    private void drawCraftingHelperTooltip(GuiRecipe guiRecipe, int mouseX, int mouseY) {
        ArrayList<String> tooltips = new ArrayList<String>();
        if (this.isCraftingTerm) {
            if (this.drawRequestTooltip) {
                if (NEECraftingHelper.isIsPatternInterfaceExists()) {
                    tooltips.add(String.format("%s" + EnumChatFormatting.GRAY + " + " + EnumChatFormatting.BLUE + I18n.func_135052_a((String)"neenergistics.gui.tooltip.helper.crafting.text2", (Object[])new Object[0]), EnumChatFormatting.YELLOW + Keyboard.getKeyName((int)NEIClientConfig.getKeyBinding((String)"nee.preview"))));
                } else {
                    tooltips.add(String.format("%s" + EnumChatFormatting.GRAY + " + " + EnumChatFormatting.BLUE + I18n.func_135052_a((String)"neenergistics.gui.tooltip.helper.crafting.text1", (Object[])new Object[0]), EnumChatFormatting.YELLOW + Keyboard.getKeyName((int)NEIClientConfig.getKeyBinding((String)"nee.preview"))));
                }
            }
            if (this.drawMissingTooltip) {
                tooltips.add(EnumChatFormatting.RED + I18n.func_135052_a((String)"neenergistics.gui.tooltip.missing", (Object[])new Object[0]));
            }
        }
        if (this.drawCraftableTooltip && this.isPatternTerm) {
            tooltips.add(EnumChatFormatting.BLUE + I18n.func_135052_a((String)"neenergistics.gui.tooltip.helper.pattern", (Object[])new Object[0]));
        }
        guiRecipe.func_146283_a(tooltips, mouseX, mouseY);
        this.drawCraftableTooltip = false;
        this.drawRequestTooltip = false;
        this.drawMissingTooltip = false;
    }

    private boolean isMouseOverButton(GuiButton button, int mouseX, int mouseY) {
        return mouseX >= button.field_146128_h && mouseY >= button.field_146129_i && mouseX < button.field_146128_h + button.field_146120_f && mouseY < button.field_146129_i + button.field_146121_g;
    }
}

