/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.relic;

import ab.client.core.handler.ItemsRemainingRender;
import ab.common.core.handler.ConfigABHandler;
import ab.common.core.handler.NetworkHandler;
import ab.common.item.relic.ItemModRelic;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemSphereNavigation
extends ItemModRelic {
    public static IIcon[] icons;
    public static final int rangeSearch = 16;
    public static final int maxCooldown = 158;

    public ItemSphereNavigation() {
        super("sphereNavigation");
    }

    @Override
    public void func_94581_a(IIconRegister ir) {
        icons = new IIcon[5];
        for (int i = 0; i < icons.length; ++i) {
            ItemSphereNavigation.icons[i] = ir.func_94245_a("ab:sphereNavigation_" + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        return icons[pass == 0 ? 0 : (pass == 1 ? 1 : 4)];
    }

    public boolean func_77623_v() {
        return true;
    }

    public String func_77653_i(ItemStack stack) {
        Block block = ItemSphereNavigation.getFindBlock(stack);
        int meta = ItemSphereNavigation.getFindMeta(stack);
        ItemStack rStack = new ItemStack(block, 1, meta);
        return super.func_77653_i(stack) + (rStack == null || rStack.func_77973_b() == null ? "" : EnumChatFormatting.RESET + " (" + EnumChatFormatting.GREEN + rStack.func_82833_r() + EnumChatFormatting.RESET + ")");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        super.func_77624_a(stack, player, list, par4);
        this.addStringToTooltip(StatCollector.func_74838_a((String)(stack.func_77960_j() == 0 ? "botaniamisc.active" : "botaniamisc.inactive")), list);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (ItemSphereNavigation.getFindBlock(stack) != null && player.func_70093_af()) {
            int dmg = stack.func_77960_j();
            stack.func_77964_b(~dmg & 1);
            world.func_72956_a((Entity)player, "random.orb", 0.3f, 0.1f);
        }
        return stack;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int pos, boolean equipped) {
        super.func_77663_a(stack, world, entity, pos, equipped);
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (!world.field_72995_K && stack.func_77960_j() == 0 && ItemSphereNavigation.getFindBlock(stack) != null && this.canWork(stack) && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)ConfigABHandler.sphereNavigationManaCost, (boolean)true)) {
                this.setMaxTick(stack);
                NetworkHandler.sendPacketToFindBlocks((EntityPlayerMP)player, ItemSphereNavigation.getFindBlock(stack), ItemSphereNavigation.getFindMeta(stack));
            }
        }
    }

    public static void findBlocks(World world, Block findBlock, int findMeta, EntityPlayer player) {
        if (world.field_72995_K) {
            ItemStack renderStack = null;
            int maxFindedBlocks = 32;
            int findedBlocks = 0;
            block0: for (int y = -32; y < 16; ++y) {
                for (int x = -16; x < 16; ++x) {
                    if (world.field_73012_v.nextInt(maxFindedBlocks) >= maxFindedBlocks - findedBlocks || world.field_73012_v.nextBoolean()) continue;
                    for (int z = -16; z < 16; ++z) {
                        int meta;
                        Block block;
                        if (world.field_73012_v.nextInt(maxFindedBlocks) >= maxFindedBlocks - findedBlocks || world.field_73012_v.nextBoolean()) continue;
                        if (findedBlocks >= maxFindedBlocks) break block0;
                        int posX = MathHelper.func_76128_c((double)player.field_70165_t) + x;
                        int posY = MathHelper.func_76128_c((double)player.field_70163_u) + y;
                        int posZ = MathHelper.func_76128_c((double)player.field_70161_v) + z;
                        if (posY < 0 || !Block.func_149680_a((Block)(block = world.func_147439_a(posX, posY, posZ)), (Block)findBlock) || (meta = world.func_72805_g(posX, posY, posZ)) != findMeta) continue;
                        if (renderStack == null) {
                            renderStack = ItemSphereNavigation.getRenderStackForBlock(world, block, meta, posX, posY, posZ);
                        }
                        ++findedBlocks;
                        float maxAge = 2.7f + 0.5f * (float)Math.random();
                        Botania.proxy.setWispFXDepthTest(false);
                        Botania.proxy.setWispFXDistanceLimit(false);
                        float far = 120.0f - (float)(Math.abs(x) + Math.min(16, Math.abs(y)) + Math.abs(z)) / 64.0f * 120.0f;
                        if (far <= 70.0f) {
                            far *= 0.1f;
                        }
                        Color color = new Color(Color.HSBtoRGB(far / 360.0f, 0.9f + (float)(Math.random() * (double)0.1f), 1.0f));
                        for (int i = 0; i < 11; ++i) {
                            Botania.proxy.wispFX(world, (double)((float)posX + 0.5f) + (Math.random() - 0.5), (double)((float)posY + 0.5f) + (Math.random() - 0.5), (double)((float)posZ + 0.5f) + (Math.random() - 0.5), (float)color.getRed() / 100.0f, (float)color.getGreen() / 100.0f, (float)color.getBlue() / 100.0f, 0.3f + (float)(Math.random() * 0.25), 0.0f, maxAge);
                        }
                        Botania.proxy.setWispFXDistanceLimit(true);
                        Botania.proxy.setWispFXDepthTest(true);
                    }
                }
            }
            if (renderStack != null) {
                ItemsRemainingRender.set(renderStack, StatCollector.func_74838_a((String)"ab.sphereNavigation.founded") + " " + findedBlocks);
            }
        }
    }

    public static ItemStack getRenderStackForBlock(World world, Block block, int meta, int x, int y, int z) {
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            if (item != null) {
                ItemStack findStack = new ItemStack(block, 1, meta);
                if (findStack != null) {
                    return findStack;
                }
            } else {
                ItemStack findStack;
                Item item1 = block.func_149694_d(world, x, y, z);
                if (item1 != null && (findStack = new ItemStack(item1, 1, meta)) != null) {
                    return findStack;
                }
            }
        }
        return null;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer p, World world, int x, int y, int z, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        int meta;
        ItemStack findStack;
        Block block;
        if (p.func_70093_af() && (block = world.func_147439_a(x, y, z)) != null && (findStack = ItemSphereNavigation.getRenderStackForBlock(world, block, meta = world.func_72805_g(x, y, z), x, y, z)) != null) {
            ItemSphereNavigation.setFindBlock(stack, block, meta);
            if (world.field_72995_K) {
                ItemsRemainingRender.set(findStack, findStack.func_82833_r());
            }
            return true;
        }
        return false;
    }

    public boolean canWork(ItemStack stack) {
        int tick = ItemNBTHelper.getInt((ItemStack)stack, (String)"cooldown", (int)0);
        if (tick == 0) {
            return true;
        }
        if (tick > 0) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)"cooldown", (int)(tick - 1));
        }
        return false;
    }

    public void setMaxTick(ItemStack stack) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"cooldown", (int)158);
    }

    public static void setFindBlock(ItemStack stack, Block block, int meta) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"findBlockID", (int)Block.func_149682_b((Block)block));
        ItemNBTHelper.setInt((ItemStack)stack, (String)"findBlockMeta", (int)meta);
    }

    public static Block getFindBlock(ItemStack stack) {
        int blockID = ItemNBTHelper.getInt((ItemStack)stack, (String)"findBlockID", (int)0);
        if (blockID == 0) {
            return null;
        }
        return Block.func_149729_e((int)blockID);
    }

    public static int getFindMeta(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"findBlockMeta", (int)-1);
    }
}

