/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.relic;

import ab.client.core.ClientHelper;
import ab.common.entity.EntityAnonymousSteve;
import ab.common.item.relic.ItemModRelic;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemPocketWardrobe
extends ItemModRelic {
    protected static final ResourceLocation glowPriorityTexture = new ResourceLocation("ab:textures/misc/glow2.png");
    protected static final ResourceLocation glowTexture = new ResourceLocation("ab:textures/misc/glow1.png");
    protected static final int segmentCount = 5;
    protected static final int maxSegmentCount = 12;

    public ItemPocketWardrobe() {
        super("autoPocketWardrobe");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_77663_a(ItemStack pocketWardrobe, World world, Entity entity, int pos, boolean equipped) {
        int tick;
        super.func_77663_a(pocketWardrobe, world, entity, pos, equipped);
        boolean eqLastTick = ItemPocketWardrobe.wasEquipped(pocketWardrobe);
        if (!equipped && eqLastTick) {
            ItemPocketWardrobe.setEquipped(pocketWardrobe, equipped);
        }
        if (!eqLastTick && equipped && entity instanceof EntityLivingBase) {
            ItemPocketWardrobe.setEquipped(pocketWardrobe, equipped);
            int angles = 360;
            int segAngles = angles / 12;
            float shift = (float)segAngles / 2.0f * 5.0f;
            ItemPocketWardrobe.setRotationBase(pocketWardrobe, ItemPocketWardrobe.getCheckingAngle((EntityLivingBase)entity) - shift);
        }
        if ((tick = ItemPocketWardrobe.getFightingTick(pocketWardrobe)) > 0) {
            ItemPocketWardrobe.setFightingTick(pocketWardrobe, tick - 1);
        } else if (!world.field_72995_K && tick == 0 && ItemPocketWardrobe.getFightingMode(pocketWardrobe) && entity != null && entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemPocketWardrobe.setFightingMode(pocketWardrobe, false);
            this.swapArmorSet(pocketWardrobe, player, ItemPocketWardrobe.getPrioritySet(pocketWardrobe));
        }
    }

    public void setArmorSet(ItemStack pocketWardrobe, ItemStack[] armorSet, int segment) {
        NBTTagList nbtList = new NBTTagList();
        int i = -1;
        for (ItemStack armor : armorSet) {
            ++i;
            if (armor == null) continue;
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74774_a("slot", (byte)i);
            armor.func_77946_l().func_77955_b(cmp);
            nbtList.func_74742_a((NBTBase)cmp);
        }
        ItemNBTHelper.setList((ItemStack)pocketWardrobe, (String)("armorSet" + segment), (NBTTagList)nbtList);
    }

    public static ItemStack[] getArmorSet(ItemStack pocketWardrobe, int segment) {
        if (segment >= 5) {
            return null;
        }
        ItemStack[] armorSet = new ItemStack[4];
        NBTTagList nbtList = ItemNBTHelper.getList((ItemStack)pocketWardrobe, (String)("armorSet" + segment), (int)10, (boolean)false);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound cmp = nbtList.func_150305_b(i);
            byte slotCount = cmp.func_74771_c("slot");
            if (slotCount < 0 || slotCount > 5) continue;
            armorSet[slotCount] = ItemStack.func_77949_a((NBTTagCompound)cmp);
        }
        return armorSet;
    }

    public ItemStack func_77659_a(ItemStack pocketWardrobe, World world, EntityPlayer player) {
        int segment = ItemPocketWardrobe.getSegmentLookedAt(pocketWardrobe, (EntityLivingBase)player);
        if (segment == -1) {
            return pocketWardrobe;
        }
        if (player.func_70093_af()) {
            ItemPocketWardrobe.setPrioritySet(pocketWardrobe, segment);
        } else {
            this.swapArmorSet(pocketWardrobe, player, segment);
        }
        return pocketWardrobe;
    }

    public void swapArmorSet(ItemStack stack, EntityPlayer player, int segment) {
        ItemStack[] playerSet = player.field_71071_by.field_70460_b;
        player.field_71071_by.field_70460_b = ItemPocketWardrobe.getArmorSet(stack, segment);
        this.setArmorSet(stack, playerSet, segment);
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, "ab:lokiCubeArmor", 0.3f, 0.86f);
        }
    }

    @SubscribeEvent
    public void onPlayerAttack(LivingAttackEvent event) {
        if (event.entityLiving != null && event.entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.entityLiving;
            if (player.field_71075_bZ.field_75098_d) {
                return;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemPocketWardrobe)) continue;
                ItemPocketWardrobe item = (ItemPocketWardrobe)stack.func_77973_b();
                if (!ItemPocketWardrobe.getFightingMode(stack)) {
                    int armorPriorirySlot = ItemPocketWardrobe.getPrioritySet(stack);
                    ItemStack[] armorSet = ItemPocketWardrobe.getArmorSet(stack, armorPriorirySlot);
                    boolean hasArmor = false;
                    for (int j = 0; j < armorSet.length; ++j) {
                        if (armorSet[j] == null) continue;
                        hasArmor = true;
                        break;
                    }
                    if (!hasArmor) continue;
                    ItemPocketWardrobe.setFightingTick(stack, 32);
                    ItemPocketWardrobe.setFightingMode(stack, true);
                    item.swapArmorSet(stack, player, armorPriorirySlot);
                    return;
                }
                ItemPocketWardrobe.setFightingTick(stack, 32);
                return;
            }
        }
    }

    public ResourceLocation getGlowTexture(ItemStack stack, int segment) {
        return ItemPocketWardrobe.getPrioritySet(stack) == segment ? glowPriorityTexture : glowTexture;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        EntityClientPlayerMP entityClientPlayerMP = Minecraft.func_71410_x().field_71439_g;
        ItemStack stack = entityClientPlayerMP.func_71045_bC();
        if (stack != null && stack.func_77973_b() instanceof ItemPocketWardrobe) {
            this.render(stack, (EntityPlayer)entityClientPlayerMP, event.partialTicks);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(ItemStack stack, EntityPlayer player, float partialTicks) {
        Minecraft mc = Minecraft.func_71410_x();
        Tessellator tess = Tessellator.field_78398_a;
        Tessellator.renderingWorldRenderer = false;
        GL11.glPushMatrix();
        float alpha = ((float)Math.sin(((float)ClientTickHandler.ticksInGame + partialTicks) * 0.2f) * 0.5f + 0.5f) * 0.4f + 0.3f;
        double posX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double posY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double posZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GL11.glTranslated((double)(posX - RenderManager.field_78725_b), (double)(posY - RenderManager.field_78726_c), (double)(posZ - RenderManager.field_78723_d));
        float base = ItemPocketWardrobe.getRotationBase(stack);
        int angles = 360;
        int segAngles = angles / 12;
        float shift = base - (float)segAngles / 2.0f * 5.0f;
        float u = 1.0f;
        float v = 0.25f;
        float s = 3.6f;
        float m = 0.8f;
        float y = v * 6.0f;
        float y0 = 0.0f;
        int segmentLookedAt = ItemPocketWardrobe.getSegmentLookedAt(stack, (EntityLivingBase)player);
        for (int seg = 0; seg < 5; ++seg) {
            ClientHelper.setLightmapTextureCoords();
            float rotationAngle = ((float)seg + 0.5f) * (float)segAngles + shift;
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glDisable((int)2884);
            float a = alpha;
            if (segmentLookedAt == seg) {
                a += 0.3f;
                y0 = -y;
            }
            if (seg % 2 == 0) {
                GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)a);
            } else {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            }
            ItemPocketWardrobe item = (ItemPocketWardrobe)stack.func_77973_b();
            mc.field_71446_o.func_110577_a(item.getGlowTexture(stack, seg));
            tess.func_78382_b();
            for (int i = 0; i < segAngles; ++i) {
                float ang = (float)(i + seg * segAngles) + shift;
                double xp = Math.cos((double)ang * Math.PI / 180.0) * (double)s;
                double zp = Math.sin((double)ang * Math.PI / 180.0) * (double)s;
                tess.func_78374_a(xp * (double)m, (double)y, zp * (double)m, (double)u, (double)v);
                tess.func_78374_a(xp, (double)y0, zp, (double)u, 0.0);
                xp = Math.cos((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                zp = Math.sin((double)(ang + 1.0f) * Math.PI / 180.0) * (double)s;
                tess.func_78374_a(xp, (double)y0, zp, 0.0, 0.0);
                tess.func_78374_a(xp * (double)m, (double)y, zp * (double)m, 0.0, (double)v);
            }
            y0 = 0.0f;
            tess.func_78381_a();
            GL11.glPopMatrix();
            EntityAnonymousSteve steve = new EntityAnonymousSteve(player.field_70170_p);
            steve.field_71071_by.field_70460_b = ItemPocketWardrobe.getArmorSet(stack, seg);
            boolean hasArmor = false;
            for (int l = 0; l < steve.field_71071_by.field_70460_b.length; ++l) {
                if (steve.field_71071_by.func_70440_f(l) == null) continue;
                hasArmor = true;
                break;
            }
            if (hasArmor) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glRotatef((float)rotationAngle, (float)0.0f, (float)1.0f, (float)0.0f);
                double worldTime = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks + (float)seg * 2.75f;
                GL11.glTranslated((double)(s * m), (double)(-0.75 + Math.sin(worldTime / 12.0) / 26.0), (double)0.0);
                float scale = 0.6f;
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.8125f, (float)0.0f);
                GL11.glScalef((float)scale, (float)scale, (float)scale);
                steve.func_70080_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, 0.0f, 10.0f);
                RenderManager.field_78727_a.func_147940_a((Entity)steve, 0.0, 0.0, 0.0, 0.0f, 0.0f);
                Minecraft.func_71410_x().field_71460_t.func_78483_a((double)partialTicks);
                GL11.glPopMatrix();
            }
            ClientHelper.setLightmapTextureCoords();
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
        }
        GL11.glPopMatrix();
    }

    protected static int getSegmentLookedAt(ItemStack stack, EntityLivingBase player) {
        float yaw = ItemPocketWardrobe.getCheckingAngle(player, ItemPocketWardrobe.getRotationBase(stack));
        int angles = 360;
        int segAngles = angles / 12;
        for (int seg = 0; seg < 5; ++seg) {
            float calcAngle = seg * segAngles;
            if (!(yaw >= calcAngle) || !(yaw < calcAngle + (float)segAngles)) continue;
            return seg;
        }
        return -1;
    }

    protected static float getCheckingAngle(EntityLivingBase player, float base) {
        float angle;
        float yaw = MathHelper.func_76142_g((float)player.field_70177_z) + 90.0f;
        int angles = 360;
        int segAngles = angles / 12;
        float shift = (float)segAngles / 2.0f * 5.0f;
        if (yaw < 0.0f) {
            yaw = 360.0f + yaw;
        }
        if ((angle = 360.0f - (yaw -= 360.0f - base) + shift) > 360.0f) {
            angle %= 360.0f;
        }
        return angle;
    }

    protected static float getCheckingAngle(EntityLivingBase player) {
        return ItemPocketWardrobe.getCheckingAngle(player, 0.0f);
    }

    public static void setEquipped(ItemStack stack, boolean equipped) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"equipped", (boolean)equipped);
    }

    public static boolean wasEquipped(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"equipped", (boolean)false);
    }

    public static void setRotationBase(ItemStack stack, float rotation) {
        ItemNBTHelper.setFloat((ItemStack)stack, (String)"rotationBase", (float)rotation);
    }

    public static float getRotationBase(ItemStack stack) {
        return ItemNBTHelper.getFloat((ItemStack)stack, (String)"rotationBase", (float)0.0f);
    }

    public static void setFightingMode(ItemStack stack, boolean mode) {
        ItemNBTHelper.setBoolean((ItemStack)stack, (String)"fightingMode", (boolean)mode);
    }

    public static boolean getFightingMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"fightingMode", (boolean)false);
    }

    public static void setFightingTick(ItemStack stack, int tick) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"fightingTick", (int)tick);
    }

    public static int getFightingTick(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"fightingTick", (int)0);
    }

    public static void setPrioritySet(ItemStack stack, int segment) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)"prioritySet", (int)segment);
    }

    public static int getPrioritySet(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)"prioritySet", (int)2);
    }
}

