/*
 * Decompiled with CFR 0.152.
 */
package ab.common.item.equipment.armor;

import ab.AdvancedBotany;
import ab.api.AdvancedBotanyAPI;
import ab.client.model.armor.ModelArmorNebula;
import ab.common.lib.register.ItemListAB;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaTooltipDisplay;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemNebulaArmor
extends ItemManasteelArmor
implements IManaItem,
IManaTooltipDisplay {
    protected static final int MAX_MANA = 250000;
    private static final String TAG_MANA = "mana";
    static ItemStack[] armorset;
    public static IIcon nebulaEyes;

    public ItemNebulaArmor(int type, String name) {
        super(type, name, AdvancedBotanyAPI.nebulaArmorMaterial);
        this.func_77637_a(AdvancedBotany.tabAB);
        this.func_77656_e(1000);
        this.setNoRepair();
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return AdvancedBotanyAPI.rarityNebula;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        return new ISpecialArmor.ArmorProperties(0, (double)this.func_82812_d().func_78044_b(slot) * ((double)0.03f + 0.0725 * (double)(1.0f - (float)this.getDamage(armor) / 1000.0f)), Integer.MAX_VALUE);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, int slot) {
        this.models[slot] = new ModelArmorNebula(slot);
        return this.models[slot];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister ir) {
        this.field_77791_bV = ir.func_94245_a("ab:" + this.func_77658_a().replaceAll("item\\.", ""));
        nebulaEyes = ir.func_94245_a("ab:nebulaEyes");
    }

    public String getArmorTextureAfterInk(ItemStack stack, int slot) {
        return "ab:textures/model/nebulaArmor.png";
    }

    public ItemStack[] getArmorSetStacks() {
        if (armorset == null) {
            armorset = new ItemStack[]{new ItemStack(ItemListAB.itemNebulaHelm), new ItemStack(ItemListAB.itemNebulaChest), new ItemStack(ItemListAB.itemNebulaLegs), new ItemStack(ItemListAB.itemNebulaBoots)};
        }
        return armorset;
    }

    public boolean hasArmorSetItem(EntityPlayer player, int i) {
        ItemStack stack = player.field_71071_by.field_70460_b[3 - i];
        if (stack == null) {
            return false;
        }
        switch (i) {
            case 0: {
                return stack.func_77973_b() == ItemListAB.itemNebulaHelm || stack.func_77973_b() == ItemListAB.itemNebulaHelmReveal;
            }
            case 1: {
                return stack.func_77973_b() == ItemListAB.itemNebulaChest;
            }
            case 2: {
                return stack.func_77973_b() == ItemListAB.itemNebulaLegs;
            }
            case 3: {
                return stack.func_77973_b() == ItemListAB.itemNebulaBoots;
            }
        }
        return false;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        int manaVal = Math.min(damage * 15, this.getMana(stack));
        if (entity instanceof EntityPlayer && !entity.field_70170_p.field_72995_K && !ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)entity), (int)manaVal, (boolean)true)) {
            this.addMana(stack, -manaVal);
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.getMana(stack) != this.getMaxMana(stack) && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)player, (int)1000, (boolean)true)) {
            this.addMana(stack, 1000);
        }
    }

    public void addArmorSetDescription(ItemStack stack, List<String> list) {
        this.addStringToTooltip(StatCollector.func_74838_a((String)"ab.armorset.nebula.desc0"), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botania.armorset.terrasteel.desc1"), list);
        this.addStringToTooltip(StatCollector.func_74838_a((String)"botania.armorset.terrasteel.desc2"), list);
    }

    public int getDamage(ItemStack stack) {
        float mana = this.getMana(stack);
        return 1000 - (int)(mana / (float)this.getMaxMana(stack) * 1000.0f);
    }

    public int getDisplayDamage(ItemStack stack) {
        return this.getDamage(stack);
    }

    public static String playerStr(EntityPlayer player) {
        return player.func_146103_bH().getName() + ":" + player.field_70170_p.field_72995_K;
    }

    public String getArmorSetName() {
        return StatCollector.func_74838_a((String)"ab.armorset.nebula.name");
    }

    public float getManaFractionForDisplay(ItemStack stack) {
        return (float)this.getMana(stack) / (float)this.getMaxMana(stack);
    }

    public static void setMana(ItemStack stack, int mana) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_MANA, (int)mana);
    }

    public void addMana(ItemStack stack, int mana) {
        ItemNebulaArmor.setMana(stack, Math.min(this.getMana(stack) + mana, this.getMaxMana(stack)));
        stack.func_77964_b(this.getDamage(stack));
    }

    public boolean canExportManaToItem(ItemStack stack, ItemStack stack1) {
        return false;
    }

    public boolean canExportManaToPool(ItemStack arg0, TileEntity arg1) {
        return false;
    }

    public boolean canReceiveManaFromItem(ItemStack arg0, ItemStack arg1) {
        return true;
    }

    public boolean canReceiveManaFromPool(ItemStack arg0, TileEntity arg1) {
        return true;
    }

    public int getMana(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_MANA, (int)0);
    }

    public int getMaxMana(ItemStack arg0) {
        return 250000;
    }

    public boolean isNoExport(ItemStack arg0) {
        return true;
    }
}

