/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.api.IRenderHud;
import ab.client.core.ClientHelper;
import ab.common.block.tile.TileInventory;
import ab.common.core.handler.ConfigABHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.spark.ISparkAttachable;
import vazkii.botania.api.wand.IWandBindable;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.ModBlocks;

public class TileManaCharger
extends TileInventory
implements ISidedInventory,
IRenderHud,
IWandBindable {
    private static final int MANA_SPEED = 11240;
    public boolean requestUpdate;
    int clientMana = -1;
    int receiverPosX = -1;
    int receiverPosY = -1;
    int receiverPosZ = -1;
    public int[] clientTick = new int[]{0, 0, 3, 12, 6};

    public void func_145845_h() {
        ISparkAttachable receiver;
        boolean hasUpdate = false;
        if (!this.field_145850_b.field_72995_K && this.requestUpdate) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        if ((receiver = this.getReceiver()) == null) {
            return;
        }
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack == null || !(stack.func_77973_b() instanceof IManaItem)) continue;
            IManaItem mana = (IManaItem)stack.func_77973_b();
            if (i == 0) {
                if (mana.getMana(stack) <= 0 || receiver.isFull() || !mana.canExportManaToPool(stack, (TileEntity)receiver)) continue;
                int availableMana = receiver.getAvailableSpaceForMana();
                int manaVal = Math.min(Math.min(mana.getMaxMana(stack) / 256, 11240) * 3, Math.min(availableMana, mana.getMana(stack)));
                if (!this.field_145850_b.field_72995_K) {
                    mana.addMana(stack, -manaVal);
                    if (this.field_145850_b.func_82737_E() % 15L == 0L) {
                        hasUpdate = true;
                    }
                } else {
                    int n = i;
                    this.clientTick[n] = this.clientTick[n] + 1;
                }
                receiver.recieveMana(manaVal);
                continue;
            }
            if (receiver.getCurrentMana() <= 0 || mana.getMana(stack) >= mana.getMaxMana(stack) || !mana.canReceiveManaFromPool(stack, (TileEntity)receiver)) continue;
            int manaVal = Math.min(Math.min(mana.getMaxMana(stack) / 256, 11240), Math.min(receiver.getCurrentMana(), mana.getMaxMana(stack) - mana.getMana(stack)));
            if (!this.field_145850_b.field_72995_K) {
                mana.addMana(stack, manaVal);
                if (this.field_145850_b.func_82737_E() % 15L == 0L) {
                    hasUpdate = true;
                }
            } else if (ConfigABHandler.useManaChargerAnimation) {
                int n = i;
                this.clientTick[n] = this.clientTick[n] + 1;
            }
            receiver.recieveMana(-manaVal);
        }
        this.requestUpdate = hasUpdate;
    }

    public ISparkAttachable getReceiver() {
        TileEntity tile;
        ISparkAttachable receiver = null;
        if (this.field_145850_b != null && this.receiverPosY != -1 && (tile = this.field_145850_b.func_147438_o(this.receiverPosX, this.receiverPosY, this.receiverPosZ)) != null && tile instanceof ISparkAttachable) {
            receiver = (ISparkAttachable)tile;
        }
        if (receiver == null) {
            this.receiverPosX = -1;
            this.receiverPosY = -1;
            this.receiverPosZ = -1;
        }
        return receiver;
    }

    public boolean canSelect(EntityPlayer player, ItemStack wand, int x, int y, int z, int side) {
        return true;
    }

    public boolean bindTo(EntityPlayer player, ItemStack wand, int x, int y, int z, int side) {
        boolean isFar;
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        boolean bl = isFar = Math.abs(this.field_145851_c - x) >= 10 || Math.abs(this.field_145848_d - y) >= 10 || Math.abs(this.field_145849_e - z) >= 10;
        if (isFar) {
            return false;
        }
        if (tile instanceof ISparkAttachable && ((ISparkAttachable)tile).canRecieveManaFromBursts()) {
            if (!this.field_145850_b.field_72995_K) {
                this.receiverPosX = tile.field_145851_c;
                this.receiverPosY = tile.field_145848_d;
                this.receiverPosZ = tile.field_145849_e;
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
            }
            return true;
        }
        return false;
    }

    public ChunkCoordinates getBinding() {
        ISparkAttachable receiver = this.getReceiver();
        if (receiver == null) {
            return null;
        }
        TileEntity tile = (TileEntity)receiver;
        return new ChunkCoordinates(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public static float getManaPercent(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IManaItem)) {
            return 0.0f;
        }
        IManaItem mana = (IManaItem)stack.func_77973_b();
        return (float)mana.getMana(stack) / ((float)mana.getMaxMana(stack) / 100.0f);
    }

    @Override
    public void renderHud(Minecraft mc, ScaledResolution res) {
        int xc = res.func_78326_a() / 2;
        int yc = res.func_78328_b() / 2;
        int radius = 42;
        int amt = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            ++amt;
        }
        float angle = -90.0f;
        if (amt >= 0) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null) continue;
                float anglePer = 360.0f / (float)amt;
                double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glTranslated((double)xPos, (double)yPos, (double)0.0);
                RenderHelper.renderProgressPie((int)0, (int)0, (float)(TileManaCharger.getManaPercent(stack) / 100.0f), (ItemStack)stack);
                if (i == 0) {
                    GL11.glScalef((float)0.75f, (float)0.75f, (float)0.75f);
                    GL11.glTranslated((double)11.0, (double)10.0, (double)0.0);
                    net.minecraft.client.renderer.RenderHelper.func_74520_c();
                    RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, new ItemStack(ModBlocks.pool), 0, 0);
                }
                GL11.glDisable((int)2896);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                net.minecraft.client.renderer.RenderHelper.func_74518_a();
                angle += anglePer;
            }
        }
    }

    public void onWanded(EntityPlayer player, ItemStack wand) {
        ISparkAttachable reciever = this.getReceiver();
        if (player == null) {
            return;
        }
        if (this.field_145850_b.field_72995_K && reciever != null) {
            this.clientMana = reciever.getCurrentMana();
        }
        this.field_145850_b.func_72956_a((Entity)player, "botania:ding", 0.11f, 1.0f);
    }

    public void renderHUD(Minecraft mc, ScaledResolution res) {
        ISparkAttachable reciever = this.getReceiver();
        if (reciever != null) {
            String name = StatCollector.func_74838_a((String)"ab.manaCharger.wandHud");
            TileEntity receiverTile = (TileEntity)reciever;
            ItemStack recieverStack = new ItemStack(this.field_145850_b.func_147439_a(receiverTile.field_145851_c, receiverTile.field_145848_d, receiverTile.field_145849_e), 1, receiverTile.func_145832_p());
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            if (recieverStack != null && recieverStack.func_77973_b() != null) {
                String stackName = recieverStack.func_82833_r();
                int width = 16 + mc.field_71466_p.func_78256_a(stackName) / 2;
                int x = res.func_78326_a() / 2 - width;
                int y = res.func_78328_b() / 2 + 48;
                mc.field_71466_p.func_78261_a(stackName, x + 20, y + 5, 0xF4F4F4);
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, recieverStack, x, y);
                net.minecraft.client.renderer.RenderHelper.func_74518_a();
            }
            GL11.glDisable((int)2896);
            GL11.glDisable((int)3042);
            ClientHelper.drawPoolManaHUD(res, name, this.clientMana, reciever.getAvailableSpaceForMana() + reciever.getCurrentMana(), 12172206);
        }
    }

    public int func_70302_i_() {
        return 5;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public String func_145825_b() {
        return "ab.manaCharger";
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbtt) {
        super.writeCustomNBT(nbtt);
        nbtt.func_74768_a("bindingX", this.receiverPosX);
        nbtt.func_74768_a("bindingY", this.receiverPosY);
        nbtt.func_74768_a("bindingZ", this.receiverPosZ);
        nbtt.func_74757_a("requestUpdate", this.requestUpdate);
    }

    public void func_145839_a(NBTTagCompound nbtt) {
        super.func_145839_a(nbtt);
        this.requestUpdate = nbtt.func_74767_n("requestUpdate");
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbtt) {
        super.readCustomNBT(nbtt);
        this.receiverPosX = nbtt.func_74762_e("bindingX");
        this.receiverPosY = nbtt.func_74762_e("bindingY");
        this.receiverPosZ = nbtt.func_74762_e("bindingZ");
    }

    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4};
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        boolean isManaItem = false;
        if (stack != null && stack.func_77973_b() instanceof IManaItem) {
            IManaItem mana = (IManaItem)stack.func_77973_b();
            ISparkAttachable receiver = this.getReceiver();
            if (receiver == null) {
                return false;
            }
            isManaItem = mana.getMana(stack) < mana.getMaxMana(stack) && mana.canReceiveManaFromPool(stack, (TileEntity)receiver);
        }
        return side == 1 && slot != 0 && isManaItem;
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        boolean isManaItem = false;
        if (stack != null && stack.func_77973_b() instanceof IManaItem) {
            IManaItem mana = (IManaItem)stack.func_77973_b();
            ISparkAttachable receiver = this.getReceiver();
            if (receiver == null) {
                return false;
            }
            isManaItem = mana.getMana(stack) == mana.getMaxMana(stack);
        }
        return side == 0 && slot != 0 && isManaItem;
    }
}

