/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.api.IRenderHud;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.common.block.tile.TileMod;

public class TileGameBoard
extends TileMod
implements IRenderHud {
    public String[] playersName = new String[]{"", ""};
    public byte[] slotChance = new byte[]{0, 0, 0, 0};
    protected int botTick = -1;
    public int endGameTick = -1;
    protected boolean requestUpdate;
    public boolean isSingleGame = true;
    public boolean isCustomGame = false;
    public int[] clientTick = new int[]{0, 0, 0, 0};
    public static final ItemStack headRender = new ItemStack(Items.field_151144_bL, 1, 3);
    private ItemStack customStack;

    public void func_145845_h() {
        if (this.botTick > 0) {
            --this.botTick;
        }
        if (this.endGameTick > 0) {
            --this.endGameTick;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.updateServer();
        } else {
            this.updateAnimationTicks();
        }
    }

    public void updateAnimationTicks() {
        for (int i = 0; i < this.slotChance.length; ++i) {
            if (this.slotChance[i] > 0) {
                int n = i;
                this.clientTick[n] = this.clientTick[n] + 1;
                continue;
            }
            this.clientTick[i] = 0;
        }
    }

    protected void updateServer() {
        if (this.hasGame() && this.endGameTick == 0 && !this.isCustomGame) {
            this.finishGame();
        }
        if (this.requestUpdate) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L && this.hasFullDice() && this.endGameTick == -1) {
            this.endGameTick = 28;
        }
        boolean hasUpdate = false;
        if (this.isSingleGame) {
            if (this.botTick == 0 && this.hasGame()) {
                for (int i = 2; i < 4; ++i) {
                    if (this.slotChance[i] != 0) continue;
                    this.slotChance[i] = (byte)(this.field_145850_b.field_73012_v.nextInt(6) + 1);
                    this.botTick = -1;
                    hasUpdate = true;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ab:boardCube", 0.6f, 1.0f);
                    break;
                }
            }
        } else if (this.botTick == 0 && this.hasGame()) {
            this.endGameTick = 0;
        }
        this.requestUpdate = hasUpdate;
    }

    public void setPlayer(String name, boolean isCustomGame) {
        this.isCustomGame = isCustomGame;
        if (this.isSingleGame) {
            this.playersName[0] = name;
            this.playersName[1] = "";
            this.requestUpdate = true;
            this.botTick = 8;
        } else {
            if (this.playersName[0].isEmpty()) {
                this.playersName[0] = name;
            } else if (!this.playersName[0].equals(name)) {
                this.playersName[1] = name;
            }
            this.requestUpdate = true;
        }
    }

    public void setPlayer(EntityPlayer player) {
        this.setPlayer(player.func_70005_c_(), false);
    }

    public boolean dropDice(String name) {
        if (this.isSingleGame) {
            if (name.equals(this.playersName[0]) && this.botTick == -1) {
                boolean hasDrop = false;
                for (int i = 0; i < 2; ++i) {
                    if (this.slotChance[i] != 0) continue;
                    hasDrop = true;
                    if (this.field_145850_b.field_72995_K) break;
                    this.slotChance[i] = (byte)(this.field_145850_b.field_73012_v.nextInt(6) + 1);
                    this.botTick = 18;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ab:boardCube", 0.6f, 1.0f);
                    this.requestUpdate = true;
                    break;
                }
                return hasDrop;
            }
        } else {
            for (int i = 0; i < this.playersName.length; ++i) {
                if (!name.equals(this.playersName[i])) continue;
                boolean hasDrop = false;
                for (int j = i * 2; j < (i + 1) * 2; ++j) {
                    if (this.slotChance[j] != 0) continue;
                    hasDrop = true;
                    if (this.field_145850_b.field_72995_K) break;
                    this.slotChance[j] = (byte)(this.field_145850_b.field_73012_v.nextInt(6) + 1);
                    this.botTick = this.playersName[1].isEmpty() ? 240 : 1200;
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ab:boardCube", 0.6f, 1.0f);
                    this.requestUpdate = true;
                    break;
                }
                return hasDrop;
            }
        }
        return false;
    }

    public boolean dropDice(EntityPlayer player) {
        return this.dropDice(player.func_70005_c_());
    }

    public boolean hasFullDice() {
        boolean hasFull = false;
        for (int i = 0; i < this.slotChance.length; ++i) {
            if (this.slotChance[i] <= 0) {
                return false;
            }
            hasFull = this.slotChance[i] > 0;
        }
        return hasFull;
    }

    public boolean hasGame() {
        if (this.isSingleGame) {
            return !this.playersName[0].isEmpty();
        }
        for (int i = 0; i < this.playersName.length; ++i) {
            if (this.playersName[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void finishGame(boolean hasChatMessage) {
        String str;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!hasChatMessage) {
            this.resetGame();
            return;
        }
        if (!this.hasFullDice()) {
            this.sendNearMessage("ab.gameBoard.misc.notPlayer", new Object[0]);
            this.resetGame();
            return;
        }
        String string = str = this.isSingleGame ? "" : ".mult";
        if (this.slotChance[0] + this.slotChance[1] > this.slotChance[2] + this.slotChance[3]) {
            this.sendNearMessage("ab.gameBoard.misc.0" + str, new Object[]{this.playersName[0]});
        } else if (this.slotChance[0] + this.slotChance[1] == this.slotChance[2] + this.slotChance[3]) {
            this.sendNearMessage("ab.gameBoard.misc.1" + str, new Object[0]);
        } else {
            this.sendNearMessage("ab.gameBoard.misc.2" + str, new Object[]{this.playersName[this.isSingleGame ? 0 : 1]});
        }
        this.resetGame();
    }

    public void finishGame() {
        this.finishGame(true);
    }

    public void sendNearMessage(String text, Object[] obj) {
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(3.5, 3.5, 3.5));
        for (EntityPlayer player : players) {
            if (player == null) continue;
            player.func_145747_a(new ChatComponentTranslation(text, obj).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GREEN)));
        }
    }

    public boolean changeCustomStack(ItemStack stack) {
        if (!this.isCustomGame) {
            return false;
        }
        if (this.customStack == null || !ItemStack.func_77989_b((ItemStack)this.customStack, (ItemStack)stack)) {
            this.customStack = stack;
            this.requestUpdate = true;
            return true;
        }
        return false;
    }

    public void resetGame() {
        this.playersName[0] = "";
        this.playersName[1] = "";
        for (int i = 0; i < this.slotChance.length; ++i) {
            this.slotChance[i] = 0;
        }
        this.botTick = -1;
        this.endGameTick = -1;
        this.isCustomGame = false;
        this.requestUpdate = true;
    }

    @Override
    public void renderHud(Minecraft mc, ScaledResolution res) {
        int x = res.func_78326_a() / 2 - 7;
        int y = res.func_78328_b() / 2 + 12;
        RenderHelper.func_74520_c();
        RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, this.isCustomGame ? (this.customStack == null ? headRender : this.customStack) : headRender, x - (!this.isSingleGame ? 1 : 0), y - (!this.isSingleGame ? 1 : 0));
        if (!this.isSingleGame) {
            RenderItem.getInstance().func_82406_b(mc.field_71466_p, mc.field_71446_o, headRender, x + 3, y + 3);
        }
        RenderHelper.func_74518_a();
    }

    public void writeCustomNBT(NBTTagCompound cmp) {
        super.writeCustomNBT(cmp);
        for (int i = 0; i < this.playersName.length; ++i) {
            cmp.func_74778_a("playerName" + i, this.playersName[i]);
        }
        cmp.func_74773_a("slotChance", this.slotChance);
        cmp.func_74768_a("botTick", this.botTick);
        cmp.func_74768_a("endGameTick", this.endGameTick);
        cmp.func_74757_a("requestUpdate", this.requestUpdate);
        cmp.func_74757_a("isSingleGame", this.isSingleGame);
        cmp.func_74757_a("isAnonimGame", this.isCustomGame);
        if (this.customStack != null) {
            this.customStack.func_77955_b(cmp);
        }
    }

    public void readCustomNBT(NBTTagCompound cmp) {
        super.readCustomNBT(cmp);
        for (int i = 0; i < this.playersName.length; ++i) {
            this.playersName[i] = cmp.func_74779_i("playerName" + i);
        }
        this.botTick = cmp.func_74762_e("botTick");
        this.endGameTick = cmp.func_74762_e("endGameTick");
        this.slotChance = cmp.func_74770_j("slotChance");
        this.requestUpdate = cmp.func_74767_n("requestUpdate");
        this.isSingleGame = cmp.func_74767_n("isSingleGame");
        this.isCustomGame = cmp.func_74767_n("isAnonimGame");
        this.customStack = ItemStack.func_77949_a((NBTTagCompound)cmp);
    }
}

