/*
 * Decompiled with CFR 0.152.
 */
package ab.common.block.tile;

import ab.api.AdvancedBotanyAPI;
import ab.common.block.tile.TileInventory;
import ab.common.core.handler.ConfigABHandler;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IRelic;
import vazkii.botania.common.item.relic.ItemRelic;

public class TileBoardFate
extends TileInventory {
    public byte[] slotChance = new byte[this.func_70302_i_()];
    public int[] clientTick = new int[]{0, 0, 0, 0};
    public boolean requestUpdate;

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.updateServer();
        } else {
            this.updateAnimationTicks();
        }
    }

    public void updateAnimationTicks() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) != null) {
                int n = i;
                this.clientTick[n] = this.clientTick[n] + 1;
                continue;
            }
            this.clientTick[i] = 0;
        }
    }

    protected void updateServer() {
        if (this.requestUpdate) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((World)this.field_145850_b, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        }
        boolean hasUpdate = false;
        if (this.hasFreeSlot()) {
            hasUpdate = this.setDiceFate();
        }
        this.requestUpdate = hasUpdate;
    }

    public boolean spawnRelic(EntityPlayer player) {
        int relicCount = 0;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) {
                this.slotChance[i] = 0;
            } else {
                if (!ItemRelic.isRightPlayer((EntityPlayer)player, (ItemStack)this.func_70301_a(i))) {
                    if (!this.field_145850_b.field_72995_K) {
                        this.dropRelic(player, i);
                    }
                    return true;
                }
                this.func_70299_a(i, null);
            }
            relicCount += this.slotChance[i];
        }
        if (relicCount < 1) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack relic = AdvancedBotanyAPI.relicList.get(Math.min(relicCount - 1, AdvancedBotanyAPI.relicList.size() - 1)).func_77946_l();
            this.field_145850_b.func_72956_a((Entity)player, "random.bow", 0.5f, 0.4f / (this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f));
            if (TileBoardFate.hasRelicAchievement(player, relic) || !ConfigABHandler.fateBoardRelicEnables[relicCount - 1]) {
                player.func_145747_a(new ChatComponentTranslation("botaniamisc.dudDiceRoll", new Object[]{relicCount}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GREEN)));
            } else {
                ItemRelic.updateRelic((ItemStack)relic, (EntityPlayer)player);
                EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.5f), (double)((float)this.field_145849_e + 0.5f), relic);
                player.func_145747_a(new ChatComponentTranslation("botaniamisc.diceRoll", new Object[]{relicCount}).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_GREEN)));
                this.field_145850_b.func_72838_d((Entity)entityItem);
            }
            this.requestUpdate = true;
        }
        return true;
    }

    private void dropRelic(EntityPlayer player, int slot) {
        EntityItem entityItem = new EntityItem(this.field_145850_b, (double)((float)this.field_145851_c + 0.5f), (double)((float)this.field_145848_d + 0.8f), (double)((float)this.field_145849_e + 0.5f), this.func_70301_a(slot).func_77946_l());
        float f3 = 0.15f;
        Vec3 vec = player.func_70040_Z();
        entityItem.field_70159_w = vec.field_72450_a * (double)f3;
        entityItem.field_70181_x = 0.25;
        entityItem.field_70179_y = vec.field_72449_c * (double)f3;
        this.func_70299_a(slot, null);
        this.field_145850_b.func_72838_d((Entity)entityItem);
    }

    public static boolean hasRelicAchievement(EntityPlayer player, ItemStack rStack) {
        EntityPlayerMP mpPlayer = (EntityPlayerMP)player;
        IRelic irelic = (IRelic)rStack.func_77973_b();
        if (irelic.getBindAchievement() == null) {
            return false;
        }
        return mpPlayer.func_147099_x().func_77443_a(irelic.getBindAchievement());
    }

    protected boolean hasFreeSlot() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) != null) continue;
            return true;
        }
        return false;
    }

    protected boolean setDiceFate() {
        boolean hasUpdate = false;
        List items = this.field_145850_b.func_72872_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)((float)this.field_145848_d + 0.7f), (double)(this.field_145849_e + 1)));
        block0: for (EntityItem item : items) {
            ItemStack stack;
            if (item.field_70128_L || item.func_92059_d() == null || !TileBoardFate.isDice(stack = item.func_92059_d())) continue;
            for (int s = 0; s < this.func_70302_i_(); ++s) {
                ItemStack slotStack = this.func_70301_a(s);
                if (slotStack != null) continue;
                ItemStack copy = stack.func_77946_l();
                copy.field_77994_a = 1;
                this.func_70299_a(s, copy);
                this.slotChance[s] = (byte)(this.field_145850_b.field_73012_v.nextInt(6) + 1);
                --stack.field_77994_a;
                if (stack.field_77994_a == 0) {
                    item.func_70106_y();
                }
                hasUpdate = true;
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ab:boardCube", 0.6f, 1.0f);
                break block0;
            }
        }
        return hasUpdate;
    }

    public static boolean isDice(ItemStack stack) {
        for (ItemStack dice : AdvancedBotanyAPI.diceList) {
            if (dice.func_77973_b() != stack.func_77973_b() || dice.func_77960_j() != stack.func_77960_j() && dice.func_77960_j() != Short.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeCustomNBT(NBTTagCompound cmp) {
        super.writeCustomNBT(cmp);
        cmp.func_74773_a("slotChance", this.slotChance);
        cmp.func_74757_a("requestUpdate", this.requestUpdate);
    }

    @Override
    public void readCustomNBT(NBTTagCompound cmp) {
        super.readCustomNBT(cmp);
        this.slotChance = cmp.func_74770_j("slotChance");
        this.requestUpdate = cmp.func_74767_n("requestUpdate");
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public String func_145825_b() {
        return "inv.boardFate";
    }

    public int func_70302_i_() {
        return 2;
    }
}

