/*
 * Decompiled with CFR 0.152.
 */
package ab.client.core.handler;

import ab.api.IRankItem;
import ab.client.core.handler.ItemsRemainingRender;
import ab.client.core.handler.PlayerItemUsingSound;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.lib.LibObfuscation;

public class ClientHandler {
    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            ClientHandler.renderTooltip();
        }
    }

    @SubscribeEvent
    public void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ItemsRemainingRender.tick();
            PlayerItemUsingSound.ClientSoundHandler.tick();
        }
    }

    public static void renderTooltip() {
        ItemStack stack;
        GuiContainer container;
        Slot slot;
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        if (gui != null && gui instanceof GuiContainer && mc.field_71439_g != null && mc.field_71439_g.field_71071_by.func_70445_o() == null && (slot = (Slot)ReflectionHelper.getPrivateValue(GuiContainer.class, (Object)(container = (GuiContainer)gui), (String[])LibObfuscation.THE_SLOT)) != null && slot.func_75216_d() && (stack = slot.func_75211_c()) != null) {
            List tooltip;
            ScaledResolution res = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            FontRenderer font = mc.field_71466_p;
            int mouseX = Mouse.getX() * res.func_78326_a() / mc.field_71443_c;
            int mouseY = res.func_78328_b() - Mouse.getY() * res.func_78328_b() / mc.field_71440_d;
            try {
                tooltip = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
            }
            catch (Exception e) {
                tooltip = new ArrayList();
            }
            int width = 0;
            for (String s : tooltip) {
                width = Math.max(width, font.func_78256_a(s) + 2);
            }
            int tooltipHeight = (tooltip.size() - 1) * 10 + 5;
            int height = 3;
            int offx = 11;
            int offy = 17;
            boolean offscreen = mouseX + width + 19 >= res.func_78326_a();
            int fixY = res.func_78328_b() - mouseY + tooltipHeight;
            if (fixY < 0) {
                offy -= fixY;
            }
            if (offscreen) {
                offx = -13 - width;
            }
            if (stack.func_77973_b() instanceof IRankItem) {
                ClientHandler.drawRankItemBar(stack, mouseX, mouseY, offx, offy, width, height, font);
            }
        }
    }

    private static void drawRankItemBar(ItemStack stack, int mouseX, int mouseY, int offx, int offy, int width, int height, FontRenderer font) {
        IRankItem item = (IRankItem)stack.func_77973_b();
        int level = item.getLevel(stack);
        int max = item.getLevels()[Math.min(item.getLevels().length - 1, level + 1)];
        boolean ss = level >= item.getLevels().length - 1;
        int curr = item.getMana(stack);
        float percent = level == 0 ? 0.0f : (float)curr / (float)max;
        int rainbowWidth = Math.min(width - (ss ? 0 : 1), (int)((float)width * percent));
        float huePer = width == 0 ? 0.0f : 1.0f / (float)width;
        float hueOff = ((float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks) * 0.01f;
        GL11.glDisable((int)2929);
        Gui.func_73734_a((int)(mouseX + offx - 1), (int)(mouseY - offy - height - 1), (int)(mouseX + offx + width + 1), (int)(mouseY - offy), (int)-16777216);
        for (int i = 0; i < rainbowWidth; ++i) {
            Gui.func_73734_a((int)(mouseX + offx + i), (int)(mouseY - offy - height), (int)(mouseX + offx + i + 1), (int)(mouseY - offy), (int)Color.HSBtoRGB(hueOff + huePer * (float)i, 1.0f, 1.0f));
        }
        Gui.func_73734_a((int)(mouseX + offx + rainbowWidth), (int)(mouseY - offy - height), (int)(mouseX + offx + width), (int)(mouseY - offy), (int)-11184811);
        String rank = StatCollector.func_74838_a((String)("botania.rank" + level)).replaceAll("&", "\u00a7");
        GL11.glPushAttrib((int)2896);
        GL11.glDisable((int)2896);
        font.func_78261_a(rank, mouseX + offx, mouseY - offy - 12, 0xFFFFFF);
        if (!ss) {
            rank = StatCollector.func_74838_a((String)("botania.rank" + (level + 1))).replaceAll("&", "\u00a7");
            font.func_78261_a(rank, mouseX + offx + width - font.func_78256_a(rank), mouseY - offy - 12, 0xFFFFFF);
        }
        GL11.glEnable((int)2929);
        GL11.glPopAttrib();
    }
}

