/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile.turbine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityTurbineRotor
extends TileEntityBasicBlock {
    public List<Coord4D> rotors = new ArrayList<Coord4D>();
    public boolean hasComplex;
    public String multiblockUUID;
    public int blades = 0;
    public int clientIndex;
    public float rotationLower;
    public float rotationUpper;

    public boolean canUpdate() {
        return false;
    }

    @Override
    public void onNeighborChange(Block block) {
        if (!this.field_145850_b.field_72995_K) {
            this.updateRotors();
        }
    }

    public void updateRotors() {
        if (this.rotors.contains(Coord4D.get(this))) {
            this.rotors.add(Coord4D.get(this));
        }
        this.buildRotors();
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
    }

    private void buildRotors() {
        ArrayList<Coord4D> newRotors = new ArrayList<Coord4D>();
        int newBlades = 0;
        boolean complex = false;
        String id = null;
        Coord4D pointer = Coord4D.get(this);
        while (this.isRotor(pointer.getFromSide(ForgeDirection.DOWN))) {
            pointer.step(ForgeDirection.DOWN);
        }
        while (true) {
            newRotors.add(pointer.clone());
            newBlades += ((TileEntityTurbineRotor)pointer.getTileEntity((IBlockAccess)this.field_145850_b)).getHousedBlades();
            if (!this.isRotor(pointer.getFromSide(ForgeDirection.UP))) break;
            pointer.step(ForgeDirection.UP);
        }
        if (this.isComplex(pointer.getFromSide(ForgeDirection.UP))) {
            id = ((TileEntityRotationalComplex)pointer.getFromSide((ForgeDirection)ForgeDirection.UP).getTileEntity((IBlockAccess)this.field_145850_b)).multiblockUUID;
            complex = true;
        }
        for (Coord4D coord : newRotors) {
            TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)coord.getTileEntity((IBlockAccess)this.field_145850_b);
            int prevHoused = rotor.getHousedBlades();
            int prevBlades = rotor.blades;
            rotor.rotors = newRotors;
            rotor.blades = newBlades;
            rotor.multiblockUUID = id;
            rotor.hasComplex = this.rotors.indexOf(coord) == this.rotors.size() - 1 ? complex : false;
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(coord, rotor.getNetworkedData(new ArrayList())), new Range4D(coord));
        }
    }

    public boolean editBlade(boolean add) {
        if (!this.rotors.contains(Coord4D.get(this))) {
            this.rotors.add(Coord4D.get(this));
        }
        if (add && this.rotors.size() * 2 - this.blades > 0 || !add && this.blades > 0) {
            for (Coord4D coord : this.rotors) {
                TileEntityTurbineRotor rotor = (TileEntityTurbineRotor)coord.getTileEntity((IBlockAccess)this.field_145850_b);
                rotor.internalEditBlade(add);
            }
            return true;
        }
        return false;
    }

    public void internalEditBlade(boolean add) {
        int prev = this.getHousedBlades();
        this.blades += add ? 1 : -1;
        if (this.getHousedBlades() != prev) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
        }
    }

    public int getHousedBlades() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.rotors.size() > 0) {
                return Math.max(0, Math.min(2, this.blades - this.rotors.indexOf(Coord4D.get(this)) * 2));
            }
            return this.blades;
        }
        return this.blades;
    }

    private boolean isRotor(Coord4D coord) {
        return coord.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityTurbineRotor;
    }

    private boolean isComplex(Coord4D coord) {
        return coord.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityRotationalComplex;
    }

    @Override
    public void onChunkLoad() {
        super.onChunkLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.updateRotors();
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            int prevBlades = this.blades;
            int prevIndex = this.clientIndex;
            this.blades = dataStream.readInt();
            this.clientIndex = dataStream.readInt();
            this.multiblockUUID = dataStream.readBoolean() ? PacketHandler.readString(dataStream) : null;
            if (prevBlades != this.blades || prevIndex != this.clientIndex) {
                this.rotationLower = 0.0f;
                this.rotationUpper = 0.0f;
            }
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.getHousedBlades());
        data.add(this.rotors.indexOf(Coord4D.get(this)));
        if (this.multiblockUUID != null) {
            data.add(true);
            data.add(this.multiblockUUID);
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.blades = nbtTags.func_74762_e("blades");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("blades", this.getHousedBlades());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void onUpdate() {
    }
}

