/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasTankInfoProvider;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.base.ISustainedData;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.tile.TileEntityGenerator;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBioGenerator
extends TileEntityGenerator
implements IGasHandler,
IGasTankInfoProvider,
ITubeConnection,
ISustainedData {
    public int MAX_GAS = 18000;
    public int gasDuration;
    public GasTank fuelTank;
    private static final String[] methods = new String[]{"getEnergy", "getOutput", "getMaxEnergy", "getEnergyNeeded", "getBioFuel", "getBioFuelNeeded"};

    public TileEntityBioGenerator() {
        super("bio", "BioGenerator", 180000.0, MekanismConfig.generators.bioGeneration * MekanismConfig.mekce_generators.ethanolMultiplier * 2.0);
        this.inventory = new ItemStack[2];
        this.fuelTank = new GasTank(this.MAX_GAS);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            ChargeUtils.charge(1, this);
            if (this.inventory[0] != null && this.fuelTank.getStored() < this.MAX_GAS) {
                GasStack gas;
                Gas gasType = null;
                if (this.fuelTank.getStored() > 0 && this.fuelTank.getGas() != null) {
                    gasType = this.fuelTank.getGas().getGas();
                } else if (this.inventory[0] != null && this.inventory[0].func_77973_b() instanceof IGasItem && (gas = ((IGasItem)this.inventory[0].func_77973_b()).getGas(this.inventory[0])) != null && this.isValidGas(gas.getGas())) {
                    gasType = gas.getGas();
                }
                if (this.isValidGas(gasType)) {
                    GasStack removed = GasTransmission.removeGas(this.inventory[0], gasType, this.fuelTank.getNeeded());
                    boolean isTankEmpty = this.fuelTank.getGas() == null;
                    int fuelReceived = this.fuelTank.receive(removed, true);
                    if (fuelReceived > 0 && isTankEmpty) {
                        this.output = MekanismConfig.generators.bioGeneration * this.getMultiplier(gasType) * 2.0;
                    }
                }
            }
            if (this.canOperate()) {
                if (!this.field_145850_b.field_72995_K) {
                    this.setActive(true);
                }
                this.output = MekanismConfig.generators.bioGeneration * this.getMultiplier(this.fuelTank.getGas().getGas()) * 2.0;
                this.setEnergy(this.electricityStored + MekanismConfig.generators.bioGeneration * this.getMultiplier(this.fuelTank.getGas().getGas()));
                if (this.gasDuration <= 0) {
                    this.fuelTank.setGas(new GasStack(this.fuelTank.getGasType(), this.fuelTank.getStored() - 1));
                    this.gasDuration = this.fuelTank.getGas().getGas() == GasRegistry.getGas("bioethanol") ? MekanismConfig.mekce_generators.ethanolDuration : MekanismConfig.mekce_generators.biogasDuration;
                } else {
                    --this.gasDuration;
                }
            } else {
                this.output = MekanismConfig.generators.bioGeneration * 2.0;
                if (this.fuelTank.getStored() == 0) {
                    this.fuelTank.setGas(null);
                }
                if (!this.field_145850_b.field_72995_K) {
                    this.setActive(false);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) != null && this.isValidGas(((IGasItem)itemstack.func_77973_b()).getGas(itemstack).getGas());
        }
        if (slotID == 1) {
            return ChargeUtils.canBeCharged(itemstack);
        }
        return true;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, true);
        }
        if (slotID == 0) {
            return itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).getGas(itemstack) == null;
        }
        return false;
    }

    @Override
    public boolean canOperate() {
        return this.fuelTank.getStored() > 0 && this.electricityStored < this.BASE_MAX_ENERGY && MekanismUtils.canFunction(this);
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (ForgeDirection.getOrientation((int)side) == MekanismUtils.getRight(this.facing)) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        Gas fuel;
        super.func_145839_a(nbtTags);
        this.fuelTank.read(nbtTags.func_74775_l("fuelTank"));
        boolean isTankEmpty = this.fuelTank.getGas() == null;
        Gas gas = fuel = isTankEmpty ? null : this.fuelTank.getGas().getGas();
        if (fuel != null) {
            this.output = MekanismConfig.generators.bioGeneration * this.getMultiplier(this.fuelTank.getGas().getGas()) * 2.0;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
    }

    public double getMultiplier(Gas gas) {
        if (gas == GasRegistry.getGas("bioethanol")) {
            return MekanismConfig.mekce_generators.ethanolMultiplier;
        }
        return 1.0;
    }

    public int getFuelType() {
        Gas gas;
        if (this.fuelTank.getStored() > 0 && this.isValidGas(gas = this.fuelTank.getGas().getGas()) && gas == GasRegistry.getGas("bioethanol")) {
            return 1;
        }
        return 0;
    }

    public int getScaledFuelLevel(int i) {
        return this.fuelTank.getStored() * i / this.MAX_GAS;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return facing != 0 && facing != 1;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            if (dataStream.readBoolean()) {
                this.fuelTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.fuelTank.setGas(null);
            }
            this.output = dataStream.readDouble();
        }
    }

    public boolean isValidGas(Gas gas) {
        return gas != null && (gas == GasRegistry.getGas("biomass") || gas == GasRegistry.getGas("bioethanol"));
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.fuelTank.getGas() != null) {
            data.add(true);
            data.add(this.fuelTank.getGas().getGas().getID());
            data.add(this.fuelTank.getStored());
        } else {
            data.add(false);
        }
        data.add(this.output);
        return data;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.output};
            }
            case 2: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 3: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 4: {
                return new Object[]{this.fuelTank.getStored()};
            }
            case 5: {
                return new Object[]{this.fuelTank.getNeeded()};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.isValidGas(type) && side != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        boolean isTankEmpty;
        boolean bl = isTankEmpty = this.fuelTank.getGas() == null;
        if (this.canReceiveGas(side, stack.getGas()) && (isTankEmpty || this.fuelTank.getGas().isGasEqual(stack))) {
            int fuelReceived = this.fuelTank.receive(stack, doTransfer);
            if (doTransfer && isTankEmpty && fuelReceived > 0) {
                this.output = MekanismConfig.generators.bioGeneration * this.getMultiplier(stack.getGas()) * 2.0;
            }
            return fuelReceived;
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return 0;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.fuelTank};
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side != ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.fuelTank != null) {
            itemStack.field_77990_d.func_74782_a("fuelTank", (NBTBase)this.fuelTank.write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (itemStack.field_77990_d.func_74764_b("fuelTank")) {
            Gas fuel;
            this.fuelTank.read(itemStack.field_77990_d.func_74775_l("fuelTank"));
            boolean isTankEmpty = this.fuelTank.getGas() == null;
            Gas gas = fuel = isTankEmpty ? null : this.fuelTank.getGas().getGas();
            if (fuel != null) {
                this.output = MekanismConfig.generators.bioGeneration * this.getMultiplier(this.fuelTank.getGas().getGas()) * 2.0;
            }
        }
    }
}

