/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.item;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IEnergizedItem;
import mekanism.client.MekKeyHandler;
import mekanism.client.MekanismKeyHandler;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.integration.IC2ItemManager;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityElectricBlock;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import mekanism.generators.common.block.BlockGenerator;
import net.minecraft.block.Block;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="IC2")})
public class ItemBlockGenerator
extends ItemBlock
implements IEnergizedItem,
ISpecialElectricItem,
ISustainedInventory,
ISustainedTank,
IEnergyContainerItem,
ISecurityItem {
    public Block metaBlock;

    public ItemBlockGenerator(Block block) {
        super(block);
        this.metaBlock = block;
        this.func_77627_a(true);
    }

    public int getItemStackLimit(ItemStack stack) {
        BlockGenerator.GeneratorType type = BlockGenerator.GeneratorType.getFromMetadata(stack.func_77960_j());
        if (type.maxEnergy == -1.0) {
            return 64;
        }
        return 1;
    }

    public int func_77647_b(int i) {
        return i;
    }

    public IIcon func_77617_a(int i) {
        return this.metaBlock.func_149691_a(2, i);
    }

    public String func_77667_c(ItemStack itemstack) {
        if (BlockGenerator.GeneratorType.getFromMetadata(itemstack.func_77960_j()) == null) {
            return "KillMe!";
        }
        return this.func_77658_a() + "." + BlockGenerator.GeneratorType.getFromMetadata((int)itemstack.func_77960_j()).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        BlockGenerator.GeneratorType type = BlockGenerator.GeneratorType.getFromMetadata(itemstack.func_77960_j());
        if (type.maxEnergy > -1.0) {
            if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
                list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.and") + " " + (Object)((Object)EnumColor.AQUA) + GameSettings.func_74298_c((int)MekanismKeyHandler.modeSwitchKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDesc") + ".");
            } else if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.modeSwitchKey)) {
                if (this.hasSecurity(itemstack)) {
                    list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
                    list.add((Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + SecurityUtils.getSecurityDisplay(itemstack, Side.CLIENT));
                    if (SecurityUtils.isOverridden(itemstack, Side.CLIENT)) {
                        list.add((Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")");
                    }
                }
                list.add((Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("tooltip.storedEnergy") + ": " + (Object)((Object)EnumColor.GREY) + MekanismUtils.getEnergyDisplay(this.getEnergy(itemstack)));
                if (this.hasTank(itemstack) && this.getFluidStack(itemstack) != null) {
                    list.add((Object)((Object)EnumColor.PINK) + FluidRegistry.getFluidName((FluidStack)this.getFluidStack(itemstack)) + ": " + (Object)((Object)EnumColor.GREY) + this.getFluidStack((Object[])new Object[]{itemstack}).amount + "mB");
                }
                list.add((Object)((Object)EnumColor.AQUA) + LangUtils.localize("tooltip.inventory") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.transYesNo(this.getInventory(itemstack) != null && this.getInventory(itemstack).func_74745_c() != 0));
            } else {
                list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
            }
        } else if (!MekKeyHandler.getIsKeyPressed(MekanismKeyHandler.sneakKey)) {
            list.add(LangUtils.localize("tooltip.hold") + " " + (Object)((Object)EnumColor.INDIGO) + GameSettings.func_74298_c((int)MekanismKeyHandler.sneakKey.func_151463_i()) + (Object)((Object)EnumColor.GREY) + " " + LangUtils.localize("tooltip.forDetails") + ".");
        } else {
            list.addAll(MekanismUtils.splitTooltip(type.getDescription(), itemstack));
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        boolean place;
        block16: {
            place = true;
            Block block = world.func_147439_a(x, y, z);
            if (stack.func_77960_j() == BlockGenerator.GeneratorType.ADVANCED_SOLAR_GENERATOR.meta) {
                if (!block.isReplaceable((IBlockAccess)world, x, y, z) || !world.func_147437_c(x, y + 1, z)) {
                    return false;
                }
                for (int xPos = -1; xPos <= 1; ++xPos) {
                    for (int zPos = -1; zPos <= 1; ++zPos) {
                        if (world.func_147437_c(x + xPos, y + 2, z + zPos) && y + 2 <= 255) continue;
                        place = false;
                        break block16;
                    }
                }
            } else if (stack.func_77960_j() == BlockGenerator.GeneratorType.WIND_GENERATOR.meta) {
                if (!block.isReplaceable((IBlockAccess)world, x, y, z)) {
                    return false;
                }
                for (int yPos = y + 1; yPos <= y + 4; ++yPos) {
                    if (world.func_147437_c(x, yPos, z) && yPos <= 255) continue;
                    place = false;
                    break;
                }
            }
        }
        if (place && super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            if (tileEntity instanceof ISecurityTile) {
                ISecurityTile security = (ISecurityTile)((Object)tileEntity);
                security.getSecurity().setOwner(this.getOwner(stack));
                if (this.hasSecurity(stack)) {
                    security.getSecurity().setMode(this.getSecurity(stack));
                }
                if (this.getOwner(stack) == null) {
                    security.getSecurity().setOwner(player.func_70005_c_());
                }
            }
            if (tileEntity instanceof TileEntityElectricBlock) {
                ((TileEntityElectricBlock)tileEntity).electricityStored = this.getEnergy(stack);
            }
            if (tileEntity instanceof ISustainedInventory) {
                ((ISustainedInventory)((Object)tileEntity)).setInventory(this.getInventory(stack), new Object[0]);
            }
            if (tileEntity instanceof ISustainedData && stack.field_77990_d != null) {
                ((ISustainedData)((Object)tileEntity)).readSustainedData(stack);
            }
            if (tileEntity instanceof ISustainedTank && this.hasTank(stack) && this.getFluidStack(stack) != null) {
                ((ISustainedTank)((Object)tileEntity)).setFluidStack(this.getFluidStack(stack), stack);
            }
            return true;
        }
        return false;
    }

    @Optional.Method(modid="IC2")
    public boolean canProvideEnergy(ItemStack itemStack) {
        return this.canSend(itemStack);
    }

    @Optional.Method(modid="IC2")
    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2")
    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    @Optional.Method(modid="IC2")
    public double getMaxCharge(ItemStack itemStack) {
        return 0.0;
    }

    @Optional.Method(modid="IC2")
    public int getTier(ItemStack itemStack) {
        return 4;
    }

    @Optional.Method(modid="IC2")
    public double getTransferLimit(ItemStack itemStack) {
        return 0.0;
    }

    @Override
    public void setInventory(NBTTagList nbtTags, Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("Items", (NBTBase)nbtTags);
        }
    }

    @Override
    public NBTTagList getInventory(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            return itemStack.field_77990_d.func_150295_c("Items", 10);
        }
        return null;
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        if (fluidStack == null || fluidStack.amount == 0 || fluidStack.getFluidID() == 0) {
            return;
        }
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.field_77990_d.func_74782_a("fluidTank", (NBTBase)fluidStack.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        if (data[0] instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)data[0];
            if (itemStack.field_77990_d == null) {
                return null;
            }
            if (itemStack.field_77990_d.func_74764_b("fluidTank")) {
                return FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("fluidTank"));
            }
        }
        return null;
    }

    @Override
    public boolean hasTank(Object ... data) {
        return data[0] instanceof ItemStack && ((ItemStack)data[0]).func_77973_b() instanceof ISustainedTank && ((ItemStack)data[0]).func_77960_j() == 2;
    }

    @Override
    public double getEnergy(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0.0;
        }
        return itemStack.field_77990_d.func_74769_h("electricity");
    }

    @Override
    public void setEnergy(ItemStack itemStack, double amount) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        double electricityStored = Math.max(Math.min(amount, this.getMaxEnergy(itemStack)), 0.0);
        itemStack.field_77990_d.func_74780_a("electricity", electricityStored);
    }

    @Override
    public double getMaxEnergy(ItemStack itemStack) {
        return BlockGenerator.GeneratorType.getFromMetadata((int)itemStack.func_77960_j()).maxEnergy;
    }

    @Override
    public double getMaxTransfer(ItemStack itemStack) {
        return this.getMaxEnergy(itemStack) * 0.005;
    }

    @Override
    public boolean canReceive(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return BlockGenerator.GeneratorType.getFromMetadata((int)itemStack.func_77960_j()).maxEnergy != -1.0;
    }

    @Override
    public int receiveEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canReceive(theItem)) {
            double energyNeeded = this.getMaxEnergy(theItem) - this.getEnergy(theItem);
            double toReceive = Math.min((double)energy * MekanismConfig.general.FROM_TE, energyNeeded);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) + toReceive);
            }
            return (int)Math.round(toReceive * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int extractEnergy(ItemStack theItem, int energy, boolean simulate) {
        if (this.canSend(theItem)) {
            double energyRemaining = this.getEnergy(theItem);
            double toSend = Math.min((double)energy * MekanismConfig.general.FROM_TE, energyRemaining);
            if (!simulate) {
                this.setEnergy(theItem, this.getEnergy(theItem) - toSend);
            }
            return (int)Math.round(toSend * MekanismConfig.general.TO_TE);
        }
        return 0;
    }

    @Override
    public int getEnergyStored(ItemStack theItem) {
        return (int)(this.getEnergy(theItem) * MekanismConfig.general.TO_TE);
    }

    @Override
    public int getMaxEnergyStored(ItemStack theItem) {
        return (int)(this.getMaxEnergy(theItem) * MekanismConfig.general.TO_TE);
    }

    @Optional.Method(modid="IC2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return IC2ItemManager.getManager(this);
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("owner")) {
            return stack.field_77990_d.func_74779_i("owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (owner == null || owner.isEmpty()) {
            stack.field_77990_d.func_82580_o("owner");
            return;
        }
        stack.field_77990_d.func_74778_a("owner", owner);
    }

    @Override
    public ISecurityTile.SecurityMode getSecurity(ItemStack stack) {
        if (stack.field_77990_d == null || !MekanismConfig.general.allowProtection) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        return ISecurityTile.SecurityMode.values()[stack.field_77990_d.func_74762_e("security")];
    }

    @Override
    public void setSecurity(ItemStack stack, ISecurityTile.SecurityMode mode) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("security", mode.ordinal());
    }

    @Override
    public boolean hasSecurity(ItemStack stack) {
        BlockGenerator.GeneratorType type = BlockGenerator.GeneratorType.getFromMetadata(stack.func_77960_j());
        return type.hasModel;
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return this.hasSecurity(stack);
    }
}

