/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common.content.turbine;

import mekanism.common.multiblock.MultiblockCache;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class TurbineCache
extends MultiblockCache<SynchronizedTurbineData> {
    public FluidStack fluid;
    public double electricity;
    public TileEntityGasTank.GasMode dumpMode = TileEntityGasTank.GasMode.IDLE;

    @Override
    public void apply(SynchronizedTurbineData data) {
        data.fluidStored = this.fluid;
        data.electricityStored = this.electricity;
        data.dumpMode = this.dumpMode;
    }

    @Override
    public void sync(SynchronizedTurbineData data) {
        this.fluid = data.fluidStored;
        this.electricity = data.electricityStored;
        this.dumpMode = data.dumpMode;
    }

    @Override
    public void load(NBTTagCompound nbtTags) {
        if (nbtTags.func_74764_b("cachedFluid")) {
            this.fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbtTags.func_74775_l("cachedFluid"));
        }
        this.electricity = nbtTags.func_74769_h("electricity");
        this.dumpMode = TileEntityGasTank.GasMode.values()[nbtTags.func_74762_e("dumpMode")];
    }

    @Override
    public void save(NBTTagCompound nbtTags) {
        if (this.fluid != null) {
            nbtTags.func_74782_a("cachedFluid", (NBTBase)this.fluid.writeToNBT(new NBTTagCompound()));
        }
        nbtTags.func_74780_a("electricity", this.electricity);
        nbtTags.func_74768_a("dumpMode", this.dumpMode.ordinal());
    }
}

