/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.FuelHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.Tier;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsBlocks;
import mekanism.generators.common.GeneratorsCommonProxy;
import mekanism.generators.common.GeneratorsGuiHandler;
import mekanism.generators.common.GeneratorsItems;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="MekanismGenerators", name="MekanismGenerators", version="9.10.37", dependencies="required-after:Mekanism", guiFactory="mekanism.generators.client.gui.GeneratorsGuiFactory")
public class MekanismGenerators
implements IModule {
    @SidedProxy(clientSide="mekanism.generators.client.GeneratorsClientProxy", serverSide="mekanism.generators.common.GeneratorsCommonProxy")
    public static GeneratorsCommonProxy proxy;
    @Mod.Instance(value="MekanismGenerators")
    public static MekanismGenerators instance;
    public static Version versionNumber;
    public static MultiblockManager<SynchronizedTurbineData> turbineManager;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        GeneratorsBlocks.register();
        GeneratorsItems.register();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        Mekanism.modulesLoaded.add(this);
        PacketSimpleGui.handlers.add(1, proxy);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GeneratorsGuiHandler());
        FMLCommonHandler.instance().bus().register((Object)this);
        proxy.loadConfiguration();
        proxy.registerRegularTileEntities();
        proxy.registerSpecialTileEntities();
        proxy.registerRenderInformation();
        this.addRecipes();
        Mekanism.logger.info("Loaded MekanismGenerators module.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (FuelHandler.BCPresent() && BuildcraftFuelRegistry.fuel != null) {
            for (IFuel s : BuildcraftFuelRegistry.fuel.getFuels()) {
                if (s.getFluid() == null || GasRegistry.containsGas(s.getFluid().getName())) continue;
                GasRegistry.register(new Gas(s.getFluid()));
            }
            BuildcraftFuelRegistry.fuel.addFuel(FluidRegistry.getFluid((String)"ethene"), (int)(240.0 * MekanismConfig.general.TO_TE), 40000);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustGold")) {
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("CARBON"), 10, MekanismUtils.size(ore, 4), GeneratorsItems.Hohlraum.getEmptyItem());
        }
    }

    public void addRecipes() {
        String mekanismMaterial = Resource.OSMIUM.getOredictName();
        if (MekanismConfig.generatorsrecipes.enableHeatGenerator) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 0), "III", "WOW", "CFC", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('O'), "ingot" + mekanismMaterial, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('W'), "plankWood"));
        }
        if (MekanismConfig.generatorsrecipes.enableSolarGenerator) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 1), "SSS", "AIA", "PEP", Character.valueOf('S'), GeneratorsItems.SolarPanel, Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "dust" + mekanismMaterial, Character.valueOf('E'), MekanismItems.EnergyTablet.getUnchargedItem()));
        }
        if (MekanismConfig.generatorsrecipes.enableAdvSolarGenerator) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 5), "SES", "SES", "III", Character.valueOf('S'), new ItemStack(GeneratorsBlocks.Generator, 1, 1), Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('I'), "ingotIron"));
        }
        if (MekanismConfig.generatorsrecipes.enableBioGenerator) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 4), "RER", "BCB", "NEN", Character.valueOf('R'), "dustRedstone", Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('B'), MekanismItems.BioFuel, Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.BASIC), Character.valueOf('N'), "ingotIron"));
        }
        if (MekanismConfig.generatorsrecipes.enableGasGenerator) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 3), "PEP", "ICI", "PEP", Character.valueOf('P'), "ingot" + mekanismMaterial, Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('I'), new ItemStack(MekanismBlocks.BasicBlock, 1, 8), Character.valueOf('C'), MekanismItems.ElectrolyticCore));
        }
        if (MekanismConfig.generatorsrecipes.enableSolarPanel) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsItems.SolarPanel), "GGG", "RAR", "PPP", Character.valueOf('G'), "paneGlass", Character.valueOf('R'), "dustRedstone", Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('P'), "ingot" + mekanismMaterial));
        }
        if (MekanismConfig.generatorsrecipes.enableWindGenerator) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 6), " O ", "OAO", "ECE", Character.valueOf('O'), "ingot" + mekanismMaterial, Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('E'), MekanismItems.EnergyTablet.getUnchargedItem(), Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.BASIC)));
        }
        if (MekanismConfig.generatorsrecipes.enableTurbineBlade) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsItems.TurbineBlade), " S ", "SAS", " S ", Character.valueOf('S'), "ingotSteel", Character.valueOf('A'), MekanismItems.EnrichedAlloy));
        }
        if (MekanismConfig.generatorsrecipes.enableTurbineRotor) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 7), "SAS", "SAS", "SAS", Character.valueOf('S'), "ingotSteel", Character.valueOf('A'), MekanismItems.EnrichedAlloy));
        }
        if (MekanismConfig.generatorsrecipes.enableRotationalComplex) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 8), "SAS", "CAC", "SAS", Character.valueOf('S'), "ingotSteel", Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.ADVANCED)));
        }
        if (MekanismConfig.generatorsrecipes.enableElectromagneticCoil) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 9), "SGS", "GEG", "SGS", Character.valueOf('S'), "ingotSteel", Character.valueOf('G'), "ingotGold", Character.valueOf('E'), MekanismItems.EnergyTablet.getUnchargedItem()));
        }
        if (MekanismConfig.generatorsrecipes.enableTurbineCasing) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 4, 10), " S ", "SOS", " S ", Character.valueOf('S'), "ingotSteel", Character.valueOf('O'), "ingot" + mekanismMaterial));
        }
        if (MekanismConfig.generatorsrecipes.enableTurbineValve) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 2, 11), " I ", "ICI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Generator, 1, 10), Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.ADVANCED)));
        }
        if (MekanismConfig.generatorsrecipes.enableTurbineVent) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 2, 12), " I ", "IFI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Generator, 1, 10), Character.valueOf('F'), Blocks.field_150411_aY));
        }
        if (MekanismConfig.generatorsrecipes.enableSaturatingCondenser) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Generator, 1, 13), "STS", "TBT", "STS", Character.valueOf('S'), "ingotSteel", Character.valueOf('T'), "ingotTin", Character.valueOf('B'), Items.field_151133_ar));
        }
        if (MekanismConfig.generatorsrecipes.enableReactorFrame) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 4, 1), " C ", "CAC", " C ", Character.valueOf('C'), new ItemStack(MekanismBlocks.BasicBlock, 1, 8), Character.valueOf('A'), "alloyUltimate"));
        }
        if (MekanismConfig.generatorsrecipes.enableReactorPort) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 2, 3), " I ", "ICI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1), Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.ULTIMATE)));
        }
        if (MekanismConfig.generatorsrecipes.enableReactorGlass) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.ReactorGlass, 4, 0), " I ", "IGI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1), Character.valueOf('G'), "blockGlass"));
        }
        if (MekanismConfig.generatorsrecipes.enableReactorController) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 1, 0), "CGC", "ITI", "III", Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.ULTIMATE), Character.valueOf('G'), "paneGlass", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1), Character.valueOf('T'), MekanismUtils.getEmptyGasTank(Tier.GasTankTier.BASIC)));
        }
        if (MekanismConfig.generatorsrecipes.enableReactorMatrix) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.ReactorGlass, 2, 1), " I ", "ILI", " I ", Character.valueOf('I'), new ItemStack(GeneratorsBlocks.ReactorGlass, 1, 0), Character.valueOf('L'), "blockRedstone"));
        }
        if (MekanismConfig.generatorsrecipes.enableReactorAdapter) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(GeneratorsBlocks.Reactor, 1, 4), " R ", "RFR", " R ", Character.valueOf('R'), "dustRedstone", Character.valueOf('F'), new ItemStack(GeneratorsBlocks.Reactor, 1, 1)));
        }
        FuelHandler.addGas(GasRegistry.getGas("ethene"), MekanismConfig.general.ETHENE_BURN_TIME, MekanismConfig.general.FROM_H2 + MekanismConfig.generators.bioGeneration * 2.0 * (double)MekanismConfig.general.ETHENE_BURN_TIME);
        FuelHandler.addGas(GasRegistry.getGas("methane"), MekanismConfig.general.METHANE_BURN_TIME, MekanismConfig.general.FROM_H2 + MekanismConfig.generators.bioGeneration * (double)MekanismConfig.general.METHANE_BURN_TIME);
    }

    @Override
    public Version getVersion() {
        return versionNumber;
    }

    @Override
    public String getName() {
        return "Generators";
    }

    @Override
    public void writeConfig(ByteBuf dataStream) throws IOException {
        dataStream.writeDouble(MekanismConfig.generators.advancedSolarGeneration);
        dataStream.writeDouble(MekanismConfig.generators.bioGeneration);
        dataStream.writeInt(MekanismConfig.mekce_generators.biogasDuration);
        dataStream.writeInt(MekanismConfig.mekce_generators.ethanolDuration);
        dataStream.writeDouble(MekanismConfig.mekce_generators.ethanolMultiplier);
        dataStream.writeDouble(MekanismConfig.generators.heatGeneration);
        dataStream.writeDouble(MekanismConfig.generators.heatGenerationLava);
        dataStream.writeDouble(MekanismConfig.generators.heatGenerationNether);
        dataStream.writeInt(MekanismConfig.generators.heatGenerationFluidRate);
        dataStream.writeBoolean(MekanismConfig.generators.heatGenEnable);
        dataStream.writeDouble(MekanismConfig.generators.solarGeneration);
        dataStream.writeDouble(MekanismConfig.generators.windGenerationMin);
        dataStream.writeDouble(MekanismConfig.generators.windGenerationMax);
        dataStream.writeInt(MekanismConfig.generators.windGenerationMinY);
        dataStream.writeInt(MekanismConfig.generators.windGenerationMaxY);
        dataStream.writeInt(MekanismConfig.generators.turbineBladesPerCoil);
        dataStream.writeDouble(MekanismConfig.generators.turbineVentGasFlow);
        dataStream.writeDouble(MekanismConfig.generators.turbineDisperserGasFlow);
        dataStream.writeInt(MekanismConfig.generators.condenserRate);
        dataStream.writeBoolean(MekanismConfig.mekce_generators.enableWindmillWhitelist);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableHeatGenerator);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableSolarGenerator);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableGasGenerator);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableBioGenerator);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableAdvSolarGenerator);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableWindGenerator);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableTurbineRotor);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableRotationalComplex);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableElectromagneticCoil);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableTurbineCasing);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableTurbineValve);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableTurbineVent);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableSaturatingCondenser);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableReactorController);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableReactorFrame);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableReactorPort);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableReactorAdapter);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableReactorGlass);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableReactorMatrix);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableSolarPanel);
        dataStream.writeBoolean(MekanismConfig.generatorsrecipes.enableTurbineBlade);
    }

    @Override
    public void readConfig(ByteBuf dataStream) throws IOException {
        MekanismConfig.generators.advancedSolarGeneration = dataStream.readDouble();
        MekanismConfig.generators.bioGeneration = dataStream.readDouble();
        MekanismConfig.mekce_generators.biogasDuration = dataStream.readInt();
        MekanismConfig.mekce_generators.ethanolDuration = dataStream.readInt();
        MekanismConfig.mekce_generators.ethanolMultiplier = dataStream.readDouble();
        MekanismConfig.generators.heatGeneration = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationLava = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationNether = dataStream.readDouble();
        MekanismConfig.generators.heatGenerationFluidRate = dataStream.readInt();
        MekanismConfig.generators.heatGenEnable = dataStream.readBoolean();
        MekanismConfig.generators.solarGeneration = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMin = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMax = dataStream.readDouble();
        MekanismConfig.generators.windGenerationMinY = dataStream.readInt();
        MekanismConfig.generators.windGenerationMaxY = dataStream.readInt();
        MekanismConfig.generators.turbineBladesPerCoil = dataStream.readInt();
        MekanismConfig.generators.turbineVentGasFlow = dataStream.readDouble();
        MekanismConfig.generators.turbineDisperserGasFlow = dataStream.readDouble();
        MekanismConfig.generators.condenserRate = dataStream.readInt();
        MekanismConfig.mekce_generators.enableWindmillWhitelist = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableHeatGenerator = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableSolarGenerator = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableGasGenerator = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableBioGenerator = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableAdvSolarGenerator = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableWindGenerator = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineRotor = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableRotationalComplex = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableElectromagneticCoil = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineCasing = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineValve = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineVent = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableSaturatingCondenser = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableReactorController = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableReactorFrame = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableReactorPort = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableReactorAdapter = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableReactorGlass = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableReactorMatrix = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableSolarPanel = dataStream.readBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineBlade = dataStream.readBoolean();
    }

    @Override
    public void resetClient() {
        SynchronizedTurbineData.clientRotationMap.clear();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals("MekanismGenerators")) {
            proxy.loadConfiguration();
        }
    }

    static {
        versionNumber = new Version(9, 10, 37);
        turbineManager = new MultiblockManager("industrialTurbine");
    }
}

