/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.common;

import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.api.MekanismConfig;
import mekanism.common.Mekanism;
import mekanism.common.base.IGuiProvider;
import mekanism.common.inventory.container.ContainerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.generators.common.inventory.container.ContainerBioGenerator;
import mekanism.generators.common.inventory.container.ContainerGasGenerator;
import mekanism.generators.common.inventory.container.ContainerHeatGenerator;
import mekanism.generators.common.inventory.container.ContainerNeutronCapture;
import mekanism.generators.common.inventory.container.ContainerReactorController;
import mekanism.generators.common.inventory.container.ContainerSolarGenerator;
import mekanism.generators.common.inventory.container.ContainerWindGenerator;
import mekanism.generators.common.tile.TileEntityAdvancedSolarGenerator;
import mekanism.generators.common.tile.TileEntityBioGenerator;
import mekanism.generators.common.tile.TileEntityGasGenerator;
import mekanism.generators.common.tile.TileEntityHeatGenerator;
import mekanism.generators.common.tile.TileEntitySolarGenerator;
import mekanism.generators.common.tile.TileEntityWindGenerator;
import mekanism.generators.common.tile.reactor.TileEntityReactorController;
import mekanism.generators.common.tile.reactor.TileEntityReactorFrame;
import mekanism.generators.common.tile.reactor.TileEntityReactorGlass;
import mekanism.generators.common.tile.reactor.TileEntityReactorLaserFocusMatrix;
import mekanism.generators.common.tile.reactor.TileEntityReactorLogicAdapter;
import mekanism.generators.common.tile.reactor.TileEntityReactorNeutronCapture;
import mekanism.generators.common.tile.reactor.TileEntityReactorPort;
import mekanism.generators.common.tile.turbine.TileEntityElectromagneticCoil;
import mekanism.generators.common.tile.turbine.TileEntityRotationalComplex;
import mekanism.generators.common.tile.turbine.TileEntitySaturatingCondenser;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import mekanism.generators.common.tile.turbine.TileEntityTurbineValve;
import mekanism.generators.common.tile.turbine.TileEntityTurbineVent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class GeneratorsCommonProxy
implements IGuiProvider {
    public static int GENERATOR_RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    public static List<Integer> dimid = null;

    public void registerRegularTileEntities() {
        GameRegistry.registerTileEntity(TileEntityReactorFrame.class, (String)"ReactorFrame");
        GameRegistry.registerTileEntity(TileEntityReactorGlass.class, (String)"ReactorGlass");
        GameRegistry.registerTileEntity(TileEntityReactorLaserFocusMatrix.class, (String)"ReactorLaserFocus");
        GameRegistry.registerTileEntity(TileEntityReactorNeutronCapture.class, (String)"ReactorNeutronCapture");
        GameRegistry.registerTileEntity(TileEntityReactorPort.class, (String)"ReactorPort");
        GameRegistry.registerTileEntity(TileEntityReactorLogicAdapter.class, (String)"ReactorLogicAdapter");
        GameRegistry.registerTileEntity(TileEntityRotationalComplex.class, (String)"RotationalComplex");
        GameRegistry.registerTileEntity(TileEntityElectromagneticCoil.class, (String)"ElectromagneticCoil");
        GameRegistry.registerTileEntity(TileEntitySaturatingCondenser.class, (String)"SaturatingCondenser");
    }

    public void registerSpecialTileEntities() {
        GameRegistry.registerTileEntity(TileEntityAdvancedSolarGenerator.class, (String)"AdvancedSolarGenerator");
        GameRegistry.registerTileEntity(TileEntitySolarGenerator.class, (String)"SolarGenerator");
        GameRegistry.registerTileEntity(TileEntityBioGenerator.class, (String)"BioGenerator");
        GameRegistry.registerTileEntity(TileEntityHeatGenerator.class, (String)"HeatGenerator");
        GameRegistry.registerTileEntity(TileEntityGasGenerator.class, (String)"GasGenerator");
        GameRegistry.registerTileEntity(TileEntityWindGenerator.class, (String)"WindTurbine");
        GameRegistry.registerTileEntity(TileEntityReactorController.class, (String)"ReactorController");
        GameRegistry.registerTileEntity(TileEntityTurbineRotor.class, (String)"TurbineRod");
        GameRegistry.registerTileEntity(TileEntityTurbineCasing.class, (String)"TurbineCasing");
        GameRegistry.registerTileEntity(TileEntityTurbineValve.class, (String)"TurbineValve");
        GameRegistry.registerTileEntity(TileEntityTurbineVent.class, (String)"TurbineVent");
    }

    public void registerRenderInformation() {
    }

    public void loadConfiguration() {
        MekanismConfig.generators.advancedSolarGeneration = Mekanism.configurationgenerators.get("generation", "AdvancedSolarGeneration", 300.0).getDouble();
        MekanismConfig.generators.bioGeneration = Mekanism.configurationgenerators.get("generation", "BioGeneration", 100.0).getDouble();
        MekanismConfig.mekce_generators.biogasDuration = Mekanism.configurationce.get("mekce_generation", "BiogasDuration", 1).getInt();
        MekanismConfig.mekce_generators.ethanolDuration = Mekanism.configurationce.get("mekce_generation", "EthanolDuration", 2).getInt();
        MekanismConfig.mekce_generators.ethanolMultiplier = Mekanism.configurationce.get("mekce_generation", "EthanolMultiplier", 3.0).getDouble();
        MekanismConfig.generators.heatGeneration = Mekanism.configurationgenerators.get("generation", "HeatGeneration", 150.0).getDouble();
        MekanismConfig.generators.heatGenerationLava = Mekanism.configurationgenerators.get("generation", "HeatGenerationLava", 5.0).getDouble();
        MekanismConfig.generators.heatGenerationNether = Mekanism.configurationgenerators.get("generation", "HeatGenerationNether", 100.0).getDouble();
        MekanismConfig.generators.heatGenerationFluidRate = Mekanism.configurationgenerators.get("generation", "HeatGenerationFluidRate", 10).getInt();
        MekanismConfig.generators.solarGeneration = Mekanism.configurationgenerators.get("generation", "SolarGeneration", 50.0).getDouble();
        this.loadWindConfiguration();
        this.loadwinddimension();
        MekanismConfig.generators.turbineBladesPerCoil = Mekanism.configurationgenerators.get("generation", "TurbineBladesPerCoil", 4).getInt();
        MekanismConfig.generators.turbineVentGasFlow = Mekanism.configurationgenerators.get("generation", "TurbineVentGasFlow", 16000.0).getDouble();
        MekanismConfig.generators.turbineDisperserGasFlow = Mekanism.configurationgenerators.get("generation", "TurbineDisperserGasFlow", 640.0).getDouble();
        MekanismConfig.generators.condenserRate = Mekanism.configurationgenerators.get("generation", "TurbineCondenserFlowRate", 32000).getInt();
        MekanismConfig.mekce_generators.enableWindmillWhitelist = Mekanism.configurationce.get("mekce_generation", "EnableWindmillWhitelist", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableHeatGenerator = Mekanism.configurationrecipes.get("generationrecipes", "enableHeatGenerator", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableSolarGenerator = Mekanism.configurationrecipes.get("generationrecipes", "enableSolarGenerator", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableGasGenerator = Mekanism.configurationrecipes.get("generationrecipes", "enableGasGenerator", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableBioGenerator = Mekanism.configurationrecipes.get("generationrecipes", "enableBioGenerator", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableAdvSolarGenerator = Mekanism.configurationrecipes.get("generationrecipes", "enableAdvSolarGenerator", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableWindGenerator = Mekanism.configurationrecipes.get("generationrecipes", "enableWindGenerator", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineRotor = Mekanism.configurationrecipes.get("generationrecipes", "enableTurbineRotor", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableRotationalComplex = Mekanism.configurationrecipes.get("generationrecipes", "enableRotationalComplex", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableElectromagneticCoil = Mekanism.configurationrecipes.get("generationrecipes", "enableElectromagneticCoil", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineCasing = Mekanism.configurationrecipes.get("generationrecipes", "enableTurbineCasing", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineValve = Mekanism.configurationrecipes.get("generationrecipes", "enableTurbineValve", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineVent = Mekanism.configurationrecipes.get("generationrecipes", "enableTurbineVent", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableSaturatingCondenser = Mekanism.configurationrecipes.get("generationrecipes", "enableSaturatingCondenser", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableReactorController = Mekanism.configurationrecipes.get("generationrecipes", "enableReactorController", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableReactorFrame = Mekanism.configurationrecipes.get("generationrecipes", "enableReactorFrame", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableReactorPort = Mekanism.configurationrecipes.get("generationrecipes", "enableReactorPort", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableReactorAdapter = Mekanism.configurationrecipes.get("generationrecipes", "enableReactorAdapter", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableReactorGlass = Mekanism.configurationrecipes.get("generationrecipes", "enableReactorGlass", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableReactorMatrix = Mekanism.configurationrecipes.get("generationrecipes", "enableReactorMatrix", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableSolarPanel = Mekanism.configurationrecipes.get("generationrecipes", "enableSolarPanel", true).getBoolean();
        MekanismConfig.generatorsrecipes.enableTurbineBlade = Mekanism.configurationrecipes.get("generationrecipes", "enableTurbineBlade", true).getBoolean();
        if (Mekanism.configurationgenerators.hasChanged()) {
            Mekanism.configurationgenerators.save();
        }
        if (Mekanism.configurationrecipes.hasChanged()) {
            Mekanism.configurationrecipes.save();
        }
        if (Mekanism.configurationce.hasChanged()) {
            Mekanism.configurationce.save();
        }
    }

    public void loadwinddimension() {
        String[] windid = new String[]{"0"};
        MekanismConfig.mekce_generators.winddimensionids = Arrays.asList(Mekanism.configurationce.getStringList("Winddimensionids", "mekce_generation", windid, "List of dimension id's to be whitelisted"));
        dimid = MekanismConfig.mekce_generators.winddimensionids.stream().map(Integer::parseInt).collect(Collectors.toList());
        System.out.println("Windmill whitelist : " + dimid);
    }

    private void loadWindConfiguration() {
        MekanismConfig.generators.windGenerationMin = Mekanism.configurationgenerators.get("generation", "WindGenerationMin", 60.0).getDouble();
        MekanismConfig.generators.windGenerationMax = Mekanism.configurationgenerators.get("generation", "WindGenerationMax", 480.0).getDouble();
        int minY = Mekanism.configurationgenerators.get("generation", "WindGenerationMinY", 24).getInt();
        int maxY = Mekanism.configurationgenerators.get("generation", "WindGenerationMaxY", 255).getInt();
        MekanismConfig.generators.windGenerationMinY = minY;
        MekanismConfig.generators.windGenerationMaxY = Math.max(minY + 1, maxY);
    }

    @Override
    public Object getClientGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        return null;
    }

    @Override
    public Container getServerGui(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        switch (ID) {
            case 0: {
                return new ContainerHeatGenerator(player.field_71071_by, (TileEntityHeatGenerator)tileEntity);
            }
            case 1: {
                return new ContainerSolarGenerator(player.field_71071_by, (TileEntitySolarGenerator)tileEntity);
            }
            case 3: {
                return new ContainerGasGenerator(player.field_71071_by, (TileEntityGasGenerator)tileEntity);
            }
            case 4: {
                return new ContainerBioGenerator(player.field_71071_by, (TileEntityBioGenerator)tileEntity);
            }
            case 5: {
                return new ContainerWindGenerator(player.field_71071_by, (TileEntityWindGenerator)tileEntity);
            }
            case 6: {
                return new ContainerFilter(player.field_71071_by, (TileEntityTurbineCasing)tileEntity);
            }
            case 7: {
                return new ContainerNull(player, (TileEntityTurbineCasing)tileEntity);
            }
            case 10: {
                return new ContainerReactorController(player.field_71071_by, (TileEntityReactorController)tileEntity);
            }
            case 11: 
            case 12: 
            case 13: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
            case 14: {
                return new ContainerNeutronCapture(player.field_71071_by, (TileEntityReactorNeutronCapture)tileEntity);
            }
            case 15: {
                return new ContainerNull(player, (TileEntityContainerBlock)tileEntity);
            }
        }
        return null;
    }
}

