/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.tileentity.RenderDynamicTank;
import mekanism.generators.client.render.RenderTurbineRotor;
import mekanism.generators.common.content.turbine.SynchronizedTurbineData;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import mekanism.generators.common.tile.turbine.TileEntityTurbineRotor;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderIndustrialTurbine
extends TileEntitySpecialRenderer {
    private static Map<RenderDynamicTank.RenderData, MekanismRenderer.DisplayInteger> cachedFluids = new HashMap<RenderDynamicTank.RenderData, MekanismRenderer.DisplayInteger>();
    private Fluid STEAM = FluidRegistry.getFluid((String)"steam");

    public void func_147500_a(TileEntity tileEntity, double x, double y, double z, float partialTick) {
        this.renderAModelAt((TileEntityTurbineCasing)tileEntity, x, y, z, partialTick);
    }

    public void renderAModelAt(TileEntityTurbineCasing tileEntity, double x, double y, double z, float partialTick) {
        if (tileEntity.clientHasStructure && tileEntity.isRendering && tileEntity.structure != null && ((SynchronizedTurbineData)tileEntity.structure).complex != null) {
            TileEntity tile;
            RenderTurbineRotor.internalRender = true;
            Coord4D coord = ((SynchronizedTurbineData)tileEntity.structure).complex;
            while ((tile = (coord = coord.getFromSide(ForgeDirection.DOWN)).getTileEntity((IBlockAccess)tileEntity.func_145831_w())) instanceof TileEntityTurbineRotor) {
                TileEntityRendererDispatcher.field_147556_a.func_147544_a(tile, partialTick);
            }
            RenderTurbineRotor.internalRender = false;
            if (((SynchronizedTurbineData)tileEntity.structure).fluidStored != null && ((SynchronizedTurbineData)tileEntity.structure).fluidStored.amount != 0 && ((SynchronizedTurbineData)tileEntity.structure).volLength > 0) {
                RenderDynamicTank.RenderData data = new RenderDynamicTank.RenderData();
                data.location = ((SynchronizedTurbineData)tileEntity.structure).renderLocation;
                data.height = ((SynchronizedTurbineData)tileEntity.structure).lowerVolume / (((SynchronizedTurbineData)tileEntity.structure).volLength * ((SynchronizedTurbineData)tileEntity.structure).volWidth);
                data.length = ((SynchronizedTurbineData)tileEntity.structure).volLength;
                data.width = ((SynchronizedTurbineData)tileEntity.structure).volWidth;
                this.func_147499_a(MekanismRenderer.getBlocksTexture());
                if (data.location != null && data.height >= 1 && ((SynchronizedTurbineData)tileEntity.structure).fluidStored.getFluid() != null) {
                    this.push();
                    GL11.glTranslated((double)this.getX(data.location.xCoord), (double)this.getY(data.location.yCoord), (double)this.getZ(data.location.zCoord));
                    MekanismRenderer.glowOn(((SynchronizedTurbineData)tileEntity.structure).fluidStored.getFluid().getLuminosity());
                    MekanismRenderer.colorFluid(((SynchronizedTurbineData)tileEntity.structure).fluidStored.getFluid());
                    MekanismRenderer.DisplayInteger display = this.getListAndRender(data, tileEntity.func_145831_w());
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)Math.min(1.0f, (float)((SynchronizedTurbineData)tileEntity.structure).fluidStored.amount / (float)((SynchronizedTurbineData)tileEntity.structure).getFluidCapacity() + MekanismRenderer.GAS_RENDER_BASE));
                    display.render();
                    MekanismRenderer.glowOff();
                    MekanismRenderer.resetColor();
                    this.pop();
                }
            }
        }
    }

    private void pop() {
        GL11.glDisable((int)2884);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
    }

    private void push() {
        GL11.glPushMatrix();
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
    }

    private int getStages(int height) {
        return 6400;
    }

    private double getX(int x) {
        return (double)x - TileEntityRendererDispatcher.field_147554_b;
    }

    private double getY(int y) {
        return (double)y - TileEntityRendererDispatcher.field_147555_c;
    }

    private double getZ(int z) {
        return (double)z - TileEntityRendererDispatcher.field_147552_d;
    }

    private MekanismRenderer.DisplayInteger getListAndRender(RenderDynamicTank.RenderData data, World world) {
        if (cachedFluids.containsKey(data)) {
            return cachedFluids.get(data);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(this.STEAM.getIcon());
        int stages = this.getStages(data.height);
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        cachedFluids.put(data, display);
        if (this.STEAM.getIcon() != null) {
            toReturn.minX = 0.01;
            toReturn.minY = 0.01;
            toReturn.minZ = 0.01;
            toReturn.maxX = (double)data.length - 0.01;
            toReturn.maxY = (double)data.height - 0.01;
            toReturn.maxZ = (double)data.width - 0.01;
            MekanismRenderer.renderObject(toReturn);
        }
        GL11.glEndList();
        return display;
    }

    public static void resetDisplayInts() {
        cachedFluids.clear();
    }
}

