/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.IGasItem;
import mekanism.api.util.StackUtils;
import mekanism.common.Upgrade;
import mekanism.common.base.IEnergyCube;
import mekanism.common.base.IFactory;
import mekanism.common.base.ITierItem;
import mekanism.common.block.BlockBasic;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.InventoryBin;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.recipe.ShapelessMekanismRecipe;
import mekanism.common.security.ISecurityItem;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class RecipeUtils {
    public static boolean areItemsEqualForCrafting(ItemStack target, ItemStack input) {
        if (target == null && input != null || target != null && input == null) {
            return false;
        }
        if (target == null && input == null) {
            return true;
        }
        if (target.func_77973_b() != input.func_77973_b()) {
            return false;
        }
        if (target.func_77960_j() != input.func_77960_j() && target.func_77960_j() != Short.MAX_VALUE) {
            return false;
        }
        if (target.func_77973_b() instanceof IEnergyCube && input.func_77973_b() instanceof IEnergyCube && ((IEnergyCube)target.func_77973_b()).getEnergyCubeTier(target) != ((IEnergyCube)input.func_77973_b()).getEnergyCubeTier(input)) {
            return false;
        }
        if (target.func_77973_b() instanceof ITierItem && input.func_77973_b() instanceof ITierItem && ((ITierItem)target.func_77973_b()).getBaseTier(target) != ((ITierItem)input.func_77973_b()).getBaseTier(input)) {
            return false;
        }
        return !(target.func_77973_b() instanceof IFactory) || !(input.func_77973_b() instanceof IFactory) || !RecipeUtils.isFactory(target) || !RecipeUtils.isFactory(input) || ((IFactory)target.func_77973_b()).getRecipeType(target) == ((IFactory)input.func_77973_b()).getRecipeType(input);
    }

    private static boolean isFactory(ItemStack stack) {
        return BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.BASIC_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ADVANCED_FACTORY || BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.ELITE_FACTORY;
    }

    public static ItemStack getCraftingResult(InventoryCrafting inv, ItemStack toReturn) {
        GasStack stored;
        int i;
        ItemStack itemstack;
        int i2;
        if (toReturn.func_77973_b() instanceof IEnergizedItem) {
            double energyFound = 0.0;
            for (i2 = 0; i2 < 9; ++i2) {
                itemstack = inv.func_70301_a(i2);
                if (itemstack == null || !(itemstack.func_77973_b() instanceof IEnergizedItem)) continue;
                energyFound += ((IEnergizedItem)itemstack.func_77973_b()).getEnergy(itemstack);
            }
            ((IEnergizedItem)toReturn.func_77973_b()).setEnergy(toReturn, Math.min(((IEnergizedItem)toReturn.func_77973_b()).getMaxEnergy(toReturn), energyFound));
        }
        if (toReturn.func_77973_b() instanceof IGasItem) {
            GasStack gasFound = null;
            for (i = 0; i < 9; ++i) {
                ItemStack itemstack2 = inv.func_70301_a(i);
                if (itemstack2 == null || !(itemstack2.func_77973_b() instanceof IGasItem) || (stored = ((IGasItem)itemstack2.func_77973_b()).getGas(itemstack2)) == null) continue;
                if (!((IGasItem)toReturn.func_77973_b()).canReceiveGas(toReturn, stored.getGas())) {
                    return null;
                }
                if (gasFound == null) {
                    gasFound = stored;
                    continue;
                }
                if (gasFound.getGas() != stored.getGas()) {
                    return null;
                }
                gasFound.amount += stored.amount;
            }
            if (gasFound != null) {
                gasFound.amount = Math.min(((IGasItem)toReturn.func_77973_b()).getMaxGas(toReturn), gasFound.amount);
                ((IGasItem)toReturn.func_77973_b()).setGas(toReturn, gasFound);
            }
        }
        if (toReturn.func_77973_b() instanceof ISecurityItem) {
            for (int i3 = 0; i3 < 9; ++i3) {
                ItemStack itemstack3 = inv.func_70301_a(i3);
                if (itemstack3 == null || !(itemstack3.func_77973_b() instanceof ISecurityItem)) continue;
                ((ISecurityItem)toReturn.func_77973_b()).setOwner(toReturn, ((ISecurityItem)itemstack3.func_77973_b()).getOwner(itemstack3));
                ((ISecurityItem)toReturn.func_77973_b()).setSecurity(toReturn, ((ISecurityItem)itemstack3.func_77973_b()).getSecurity(itemstack3));
                break;
            }
        }
        if (toReturn.func_77973_b() instanceof IFluidContainerItem) {
            GasStack fluidFound = null;
            for (i = 0; i < 9; ++i) {
                ItemStack itemstack4 = inv.func_70301_a(i);
                if (itemstack4 == null || !(itemstack4.func_77973_b() instanceof IFluidContainerItem) || (stored = ((IFluidContainerItem)itemstack4.func_77973_b()).getFluid(itemstack4)) == null) continue;
                if (((IFluidContainerItem)toReturn.func_77973_b()).fill(toReturn, (FluidStack)stored, false) == 0) {
                    return null;
                }
                if (fluidFound == null) {
                    fluidFound = stored;
                    continue;
                }
                if (fluidFound.getFluid() != stored.getFluid()) {
                    return null;
                }
                ((FluidStack)fluidFound).amount += ((FluidStack)stored).amount;
            }
            if (fluidFound != null) {
                ((FluidStack)fluidFound).amount = Math.min(((IFluidContainerItem)toReturn.func_77973_b()).getCapacity(toReturn), ((FluidStack)fluidFound).amount);
                ((IFluidContainerItem)toReturn.func_77973_b()).fill(toReturn, fluidFound, true);
            }
        }
        if (BlockBasic.BasicType.get(toReturn) == BlockBasic.BasicType.BIN) {
            int foundCount = 0;
            ItemStack foundType = null;
            for (i2 = 0; i2 < 9; ++i2) {
                itemstack = inv.func_70301_a(i2);
                if (itemstack == null || BlockBasic.BasicType.get(itemstack) != BlockBasic.BasicType.BIN) continue;
                InventoryBin binInv = new InventoryBin(itemstack);
                foundCount = binInv.getItemCount();
                foundType = binInv.getItemType();
            }
            if (foundCount > 0 && foundType != null) {
                InventoryBin binInv = new InventoryBin(toReturn);
                binInv.setItemCount(foundCount);
                binInv.setItemType(foundType);
            }
        }
        if (BlockMachine.MachineType.get(toReturn) != null && BlockMachine.MachineType.get((ItemStack)toReturn).supportsUpgrades) {
            HashMap<Upgrade, Integer> upgrades = new HashMap<Upgrade, Integer>();
            for (int i4 = 0; i4 < 9; ++i4) {
                ItemStack itemstack5 = inv.func_70301_a(i4);
                if (itemstack5 == null || BlockMachine.MachineType.get(itemstack5) == null || !BlockMachine.MachineType.get((ItemStack)itemstack5).supportsUpgrades) continue;
                Map<Upgrade, Integer> stackMap = Upgrade.buildMap(itemstack5.field_77990_d);
                for (Map.Entry<Upgrade, Integer> entry : stackMap.entrySet()) {
                    if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
                    Integer val = (Integer)upgrades.get((Object)entry.getKey());
                    upgrades.put(entry.getKey(), Math.min(entry.getKey().getMax(), (val != null ? val : 0) + entry.getValue()));
                }
            }
            if (toReturn.field_77990_d == null) {
                toReturn.func_77982_d(new NBTTagCompound());
            }
            Upgrade.saveMap(upgrades, toReturn.field_77990_d);
        }
        return toReturn;
    }

    public static ItemStack loadRecipeItemStack(NBTTagCompound nbtTags) {
        Object obj;
        int meta = 0;
        int amount = 1;
        if (nbtTags.func_74764_b("meta")) {
            meta = nbtTags.func_74762_e("meta");
        }
        if (nbtTags.func_74764_b("amount")) {
            amount = nbtTags.func_74762_e("amount");
        }
        if (nbtTags.func_74764_b("itemstack")) {
            return ItemStack.func_77949_a((NBTTagCompound)nbtTags.func_74775_l("itemstack"));
        }
        if (nbtTags.func_74764_b("itemname")) {
            Object obj2 = Item.field_150901_e.func_82594_a(nbtTags.func_74779_i("itemname"));
            if (obj2 instanceof Item) {
                return new ItemStack((Item)obj2, amount, meta);
            }
        } else if (nbtTags.func_74764_b("blockname") && (obj = Block.field_149771_c.func_82594_a(nbtTags.func_74779_i("blockname"))) instanceof Block) {
            return new ItemStack((Block)obj, amount, meta);
        }
        return null;
    }

    public static boolean removeRecipes(ItemStack stack) {
        List recipes2 = CraftingManager.func_77594_a().func_77592_b();
        Iterator iter = recipes2.iterator();
        while (iter.hasNext()) {
            IRecipe iterRecipe = (IRecipe)iter.next();
            if (!(iterRecipe instanceof ShapedMekanismRecipe) && !(iterRecipe instanceof ShapelessMekanismRecipe) || !StackUtils.equalsWildcard(stack, iterRecipe.func_77571_b())) continue;
            iter.remove();
        }
        return false;
    }

    public static IRecipe getRecipeFromGrid(InventoryCrafting inv, World world) {
        ArrayList list = new ArrayList(CraftingManager.func_77594_a().func_77592_b());
        for (IRecipe recipe : list) {
            if (!recipe.func_77569_a(inv, world)) continue;
            return recipe;
        }
        return null;
    }
}

