/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.api.energy.IEnergyContainerItem;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.EnergizedItemManager;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public final class ChargeUtils {
    public static void discharge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        if (inv.func_70301_a(slotID) != null && storer.getEnergy() < storer.getMaxEnergy()) {
            if (inv.func_70301_a(slotID).func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() + EnergizedItemManager.discharge(inv.func_70301_a(slotID), storer.getMaxEnergy() - storer.getEnergy()));
            } else if (MekanismUtils.useIC2() && inv.func_70301_a(slotID).func_77973_b() instanceof IElectricItem) {
                IElectricItem item = (IElectricItem)inv.func_70301_a(slotID).func_77973_b();
                if (item.canProvideEnergy(inv.func_70301_a(slotID))) {
                    double gain = ElectricItem.manager.discharge(inv.func_70301_a(slotID), (double)((int)((storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.general.TO_IC2)), 4, true, true, false) * MekanismConfig.general.FROM_IC2;
                    storer.setEnergy(storer.getEnergy() + gain);
                }
            } else if (MekanismUtils.useRF() && inv.func_70301_a(slotID).func_77973_b() instanceof IEnergyContainerItem) {
                ItemStack itemStack = inv.func_70301_a(slotID);
                IEnergyContainerItem item = (IEnergyContainerItem)inv.func_70301_a(slotID).func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)item.getEnergyStored(itemStack)));
                int toTransfer = (int)Math.round(Math.min((double)itemEnergy, (storer.getMaxEnergy() - storer.getEnergy()) * MekanismConfig.general.TO_TE));
                storer.setEnergy(storer.getEnergy() + (double)item.extractEnergy(itemStack, toTransfer, false) * MekanismConfig.general.FROM_TE);
            } else if (inv.func_70301_a(slotID).func_77973_b() == Items.field_151137_ax && storer.getEnergy() + MekanismConfig.general.ENERGY_PER_REDSTONE <= storer.getMaxEnergy()) {
                storer.setEnergy(storer.getEnergy() + MekanismConfig.general.ENERGY_PER_REDSTONE);
                --inv.func_70301_a((int)slotID).field_77994_a;
                if (inv.func_70301_a((int)slotID).field_77994_a <= 0) {
                    inv.func_70299_a(slotID, null);
                }
            }
        }
    }

    public static void charge(int slotID, IStrictEnergyStorage storer) {
        TileEntityContainerBlock inv = (TileEntityContainerBlock)((Object)storer);
        if (inv.func_70301_a(slotID) != null && storer.getEnergy() > 0.0) {
            if (inv.func_70301_a(slotID).func_77973_b() instanceof IEnergizedItem) {
                storer.setEnergy(storer.getEnergy() - EnergizedItemManager.charge(inv.func_70301_a(slotID), storer.getEnergy()));
            } else if (MekanismUtils.useIC2() && inv.func_70301_a(slotID).func_77973_b() instanceof IElectricItem) {
                double sent = ElectricItem.manager.charge(inv.func_70301_a(slotID), (double)((int)(storer.getEnergy() * MekanismConfig.general.TO_IC2)), 4, true, false) * MekanismConfig.general.FROM_IC2;
                storer.setEnergy(storer.getEnergy() - sent);
            } else if (MekanismUtils.useRF() && inv.func_70301_a(slotID).func_77973_b() instanceof IEnergyContainerItem) {
                ItemStack itemStack = inv.func_70301_a(slotID);
                IEnergyContainerItem item = (IEnergyContainerItem)inv.func_70301_a(slotID).func_77973_b();
                int itemEnergy = (int)Math.round(Math.min(Math.sqrt(item.getMaxEnergyStored(itemStack)), (double)(item.getMaxEnergyStored(itemStack) - item.getEnergyStored(itemStack))));
                int toTransfer = (int)Math.round(Math.min((double)itemEnergy, storer.getEnergy() * MekanismConfig.general.TO_TE));
                storer.setEnergy(storer.getEnergy() - (double)item.receiveEnergy(itemStack, toTransfer, false) * MekanismConfig.general.FROM_TE);
            }
        }
    }

    public static boolean canBeDischarged(ItemStack itemstack) {
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem && ((IElectricItem)itemstack.func_77973_b()).canProvideEnergy(itemstack) || itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canSend(itemstack) || MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).extractEnergy(itemstack, 1, true) != 0 || itemstack.func_77973_b() == Items.field_151137_ax;
    }

    public static boolean canBeCharged(ItemStack itemstack) {
        return MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof IElectricItem || itemstack.func_77973_b() instanceof IEnergizedItem && ((IEnergizedItem)itemstack.func_77973_b()).canReceive(itemstack) || MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem && ((IEnergyContainerItem)itemstack.func_77973_b()).receiveEnergy(itemstack, 1, true) != 0;
    }

    public static boolean canBeOutputted(ItemStack itemstack, boolean chargeSlot) {
        IElectricItemManager manager;
        if (itemstack.func_77973_b() instanceof IEnergizedItem) {
            IEnergizedItem energized = (IEnergizedItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energized.getEnergy(itemstack) == energized.getMaxEnergy(itemstack);
            }
            return energized.getEnergy(itemstack) == 0.0;
        }
        if (MekanismUtils.useRF() && itemstack.func_77973_b() instanceof IEnergyContainerItem) {
            IEnergyContainerItem energyContainer = (IEnergyContainerItem)itemstack.func_77973_b();
            if (chargeSlot) {
                return energyContainer.receiveEnergy(itemstack, 1, true) > 0;
            }
            return energyContainer.extractEnergy(itemstack, 1, true) > 0;
        }
        if (MekanismUtils.useIC2() && itemstack.func_77973_b() instanceof ISpecialElectricItem && (manager = ((ISpecialElectricItem)itemstack.func_77973_b()).getManager(itemstack)) != null) {
            if (chargeSlot) {
                return manager.charge(itemstack, 1.0, 3, true, true) > 0.0;
            }
            return manager.discharge(itemstack, 1.0, 3, true, true, true) > 0.0;
        }
        return true;
    }
}

