/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.util;

import cofh.api.energy.IEnergyConnection;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.ICableOutputter;
import mekanism.api.energy.IStrictEnergyAcceptor;
import mekanism.api.transmitters.ITransmitterTile;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.base.IEnergyWrapper;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public final class CableUtils {
    public static boolean isEnergyAcceptor(TileEntity tileEntity) {
        return tileEntity instanceof IStrictEnergyAcceptor || MekanismUtils.useIC2() && CableUtils.getIC2Tile(tileEntity) instanceof IEnergySink || MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver;
    }

    public static boolean isCable(TileEntity tileEntity) {
        if (tileEntity instanceof ITransmitterTile) {
            return TransmissionType.checkTransmissionType(((ITransmitterTile)tileEntity).getTransmitter(), TransmissionType.ENERGY);
        }
        return false;
    }

    public static boolean[] getConnections(TileEntity tileEntity, Set<ForgeDirection> sides) {
        boolean[] connectable = new boolean[]{false, false, false, false, false, false};
        Coord4D coord = Coord4D.get(tileEntity);
        for (ForgeDirection side : sides) {
            TileEntity tile = coord.getFromSide(side).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            connectable[side.ordinal()] = CableUtils.isValidAcceptorOnSide(tileEntity, tile, side);
            int n = side.ordinal();
            connectable[n] = connectable[n] | CableUtils.isCable(tile);
        }
        return connectable;
    }

    public static boolean isValidAcceptorOnSide(TileEntity cableEntity, TileEntity tile, ForgeDirection side) {
        if (CableUtils.isCable(tile)) {
            return false;
        }
        if (CableUtils.isEnergyAcceptor(tile) && CableUtils.isConnectable(cableEntity, tile, side)) {
            return true;
        }
        return CableUtils.isOutputter(tile, side) || MekanismUtils.useRF() && tile instanceof IEnergyConnection && ((IEnergyConnection)tile).canConnectEnergy(side.getOpposite());
    }

    public static TileEntity[] getConnectedOutputters(TileEntity tileEntity) {
        TileEntity[] outputters = new TileEntity[]{null, null, null, null, null, null};
        for (ForgeDirection orientation : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity outputter = Coord4D.get(tileEntity).getFromSide(orientation).getTileEntity((IBlockAccess)tileEntity.func_145831_w());
            if (!CableUtils.isOutputter(outputter, orientation)) continue;
            outputters[orientation.ordinal()] = outputter;
        }
        return outputters;
    }

    public static boolean isOutputter(TileEntity tileEntity, ForgeDirection side) {
        return tileEntity instanceof ICableOutputter && ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite()) || MekanismUtils.useIC2() && CableUtils.getIC2Tile(tileEntity) instanceof IEnergySource && ((IEnergySource)CableUtils.getIC2Tile(tileEntity)).emitsEnergyTo(null, side.getOpposite()) || MekanismUtils.useRF() && tileEntity instanceof IEnergyProvider && ((IEnergyConnection)tileEntity).canConnectEnergy(side.getOpposite());
    }

    public static boolean isConnectable(TileEntity orig, TileEntity tileEntity, ForgeDirection side) {
        if (tileEntity instanceof ITransmitterTile) {
            return false;
        }
        return tileEntity instanceof IStrictEnergyAcceptor ? ((IStrictEnergyAcceptor)tileEntity).canReceiveEnergy(side.getOpposite()) : (MekanismUtils.useIC2() && CableUtils.getIC2Tile(tileEntity) instanceof IEnergyAcceptor ? ((IEnergyAcceptor)CableUtils.getIC2Tile(tileEntity)).acceptsEnergyFrom(orig, side.getOpposite()) : (tileEntity instanceof ICableOutputter ? ((ICableOutputter)tileEntity).canOutputTo(side.getOpposite()) : MekanismUtils.useRF() && tileEntity instanceof IEnergyConnection && ((IEnergyConnection)tileEntity).canConnectEnergy(side.getOpposite())));
    }

    public static void emit(IEnergyWrapper emitter) {
        double energyToSend;
        if (!((TileEntity)emitter).func_145831_w().field_72995_K && MekanismUtils.canFunction((TileEntity)emitter) && (energyToSend = Math.min(emitter.getEnergy(), emitter.getMaxOutput())) > 0.0) {
            ArrayList<ForgeDirection> outputtingSides = new ArrayList<ForgeDirection>();
            boolean[] connectable = CableUtils.getConnections((TileEntity)emitter, emitter.getOutputtingSides());
            for (ForgeDirection side : emitter.getOutputtingSides()) {
                if (!connectable[side.ordinal()]) continue;
                outputtingSides.add(side);
            }
            if (outputtingSides.size() > 0) {
                double sent = 0.0;
                boolean tryAgain = false;
                int i = 0;
                do {
                    double prev = sent;
                    tryAgain = energyToSend - (sent += CableUtils.emit_do(emitter, outputtingSides, energyToSend - sent, tryAgain)) > 0.0 && sent - prev > 0.0 && i < 100;
                    ++i;
                } while (tryAgain);
                emitter.setEnergy(emitter.getEnergy() - sent);
            }
        }
    }

    private static double emit_do(IEnergyWrapper emitter, List<ForgeDirection> outputtingSides, double totalToSend, boolean tryAgain) {
        double remains = totalToSend % (double)outputtingSides.size();
        double splitSend = (totalToSend - remains) / (double)outputtingSides.size();
        double sent = 0.0;
        ArrayList<ForgeDirection> toRemove = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : outputtingSides) {
            TileEntity tileEntity = Coord4D.get((TileEntity)emitter).getFromSide(side).getTileEntity((IBlockAccess)((TileEntity)emitter).func_145831_w());
            double toSend = splitSend + remains;
            remains = 0.0;
            double prev = sent;
            if ((sent += CableUtils.emit_do_do(emitter, tileEntity, side, toSend, tryAgain)) - prev != 0.0) continue;
            toRemove.add(side);
        }
        for (ForgeDirection side : toRemove) {
            outputtingSides.remove(side);
        }
        return sent;
    }

    private static double emit_do_do(IEnergyWrapper from, TileEntity tileEntity, ForgeDirection side, double currentSending, boolean tryAgain) {
        IEnergySink sink;
        double sent = 0.0;
        if (tileEntity instanceof IStrictEnergyAcceptor) {
            IStrictEnergyAcceptor acceptor = (IStrictEnergyAcceptor)tileEntity;
            if (acceptor.canReceiveEnergy(side.getOpposite())) {
                sent += acceptor.transferEnergyToAcceptor(side.getOpposite(), currentSending);
            }
        } else if (MekanismUtils.useRF() && tileEntity instanceof IEnergyReceiver) {
            IEnergyReceiver handler = (IEnergyReceiver)tileEntity;
            if (handler.canConnectEnergy(side.getOpposite())) {
                int toSend = Math.min((int)Math.round(currentSending * MekanismConfig.general.TO_TE), Integer.MAX_VALUE);
                int used = handler.receiveEnergy(side.getOpposite(), toSend, false);
                sent += (double)used * MekanismConfig.general.FROM_TE;
            }
        } else if (MekanismUtils.useIC2() && CableUtils.getIC2Tile(tileEntity) instanceof IEnergySink && (sink = (IEnergySink)CableUtils.getIC2Tile(tileEntity)).acceptsEnergyFrom((TileEntity)from, side.getOpposite())) {
            double toSend = Math.min(currentSending, EnergyNet.instance.getPowerFromTier(sink.getSinkTier()) * MekanismConfig.general.FROM_IC2);
            toSend = Math.min(Math.min(toSend, sink.getDemandedEnergy() * MekanismConfig.general.FROM_IC2), 2.147483647E9);
            sent += toSend - sink.injectEnergy(side.getOpposite(), toSend * MekanismConfig.general.TO_IC2, 0.0) * MekanismConfig.general.FROM_IC2;
        }
        return sent;
    }

    public static TileEntity getIC2Tile(TileEntity tileEntity) {
        if (tileEntity == null) {
            return null;
        }
        return EnergyNet.instance.getTileEntity(tileEntity.func_145831_w(), tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }
}

