/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasTankInfoProvider;
import mekanism.api.gas.ITubeConnection;
import mekanism.api.transmitters.TransmissionType;
import mekanism.common.SideData;
import mekanism.common.Upgrade;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.block.BlockMachine;
import mekanism.common.item.ItemUpgrade;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.PressurizedInput;
import mekanism.common.recipe.machines.PressurizedRecipe;
import mekanism.common.recipe.outputs.PressurizedOutput;
import mekanism.common.tile.TileEntityBasicMachine;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityPRC
extends TileEntityBasicMachine<PressurizedInput, PressurizedOutput, PressurizedRecipe>
implements IFluidHandler,
IGasHandler,
IGasTankInfoProvider,
ITubeConnection,
ISustainedData,
ITankManager {
    public FluidTank inputFluidTank = new FluidTank(10000);
    public GasTank inputGasTank = new GasTank(10000);
    public GasTank outputGasTank = new GasTank(10000);
    private static final String[] methods = new String[]{"getEnergy", "getProgress", "isActive", "facing", "canOperate", "getMaxEnergy", "getEnergyNeeded", "getFluidStored", "getGasStored"};

    public TileEntityPRC() {
        super("prc", BlockMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.name, new ResourceLocation("mekanism", "gui/GuiPRC.png"), MekanismConfig.usage.pressurizedReactionBaseUsage, 100, BlockMachine.MachineType.PRESSURIZED_REACTION_CHAMBER.baseEnergy);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.ENERGY, TransmissionType.FLUID, TransmissionType.GAS);
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Input", EnumColor.DARK_RED, new int[]{0}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Energy", EnumColor.DARK_GREEN, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.ITEM, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.ITEM, new byte[]{2, 1, 0, 0, 0, 3});
        this.configComponent.addOutput(TransmissionType.FLUID, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.FLUID, new SideData("Fluid", EnumColor.YELLOW, new int[]{0}));
        this.configComponent.setConfig(TransmissionType.FLUID, new byte[]{0, 0, 0, 1, 0, 0});
        this.configComponent.setCanEject(TransmissionType.FLUID, false);
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("None", EnumColor.GREY, InventoryUtils.EMPTY));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Gas", EnumColor.DARK_RED, new int[]{1}));
        this.configComponent.addOutput(TransmissionType.GAS, new SideData("Output", EnumColor.DARK_BLUE, new int[]{2}));
        this.configComponent.setConfig(TransmissionType.GAS, new byte[]{0, 0, 0, 0, 1, 2});
        this.configComponent.setInputConfig(TransmissionType.ENERGY);
        this.inventory = new ItemStack[4];
        this.upgradeComponent = new TileComponentUpgrade(this, 3);
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(TransmissionType.ITEM, this.configComponent.getOutputs(TransmissionType.ITEM).get(3));
        this.ejectorComponent.setOutputData(TransmissionType.GAS, this.configComponent.getOutputs(TransmissionType.GAS).get(2));
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K) {
            PressurizedRecipe recipe = this.getRecipe();
            ChargeUtils.discharge(1, this);
            if (this.canOperate(recipe) && MekanismUtils.canFunction(this) && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                boolean update = this.BASE_TICKS_REQUIRED != recipe.ticks;
                this.BASE_TICKS_REQUIRED = recipe.ticks;
                if (update) {
                    this.recalculateUpgradables(Upgrade.SPEED);
                }
                this.setActive(true);
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy);
                } else if (this.operatingTicks + 1 >= this.ticksRequired && this.getEnergy() >= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy)) {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                    this.electricityStored -= MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_PER_TICK + recipe.extraEnergy);
                }
            } else {
                this.BASE_TICKS_REQUIRED = 100;
                if (this.prevEnergy >= this.getEnergy()) {
                    this.setActive(false);
                }
            }
            if (!this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            return RecipeHandler.isInPressurizedRecipe(itemstack);
        }
        if (slotID == 1) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        if (slotID == 3) {
            return itemstack.func_77973_b() instanceof ItemUpgrade;
        }
        return false;
    }

    @Override
    public PressurizedRecipe getRecipe() {
        PressurizedInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((PressurizedInput)((PressurizedRecipe)this.cachedRecipe).getInput())) {
            this.cachedRecipe = RecipeHandler.getPRCRecipe(input);
        }
        return (PressurizedRecipe)this.cachedRecipe;
    }

    @Override
    public PressurizedInput getInput() {
        return new PressurizedInput(this.inventory[0], this.inputFluidTank.getFluid(), this.inputGasTank.getGas());
    }

    @Override
    public void operate(PressurizedRecipe recipe) {
        recipe.operate(this.inventory, this.inputFluidTank, this.inputGasTank, this.outputGasTank);
        this.func_70296_d();
        this.ejectorComponent.outputItems();
    }

    @Override
    public boolean canOperate(PressurizedRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, this.inputFluidTank, this.inputGasTank, this.outputGasTank);
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 1) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return slotID == 2 || slotID == 4;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        if (this.inputFluidTank.getFluid() != null) {
            data.add(true);
            data.add(this.inputFluidTank.getFluid().getFluid().getID());
            data.add(this.inputFluidTank.getFluidAmount());
        } else {
            data.add(false);
        }
        if (this.inputGasTank.getGas() != null) {
            data.add(true);
            data.add(this.inputGasTank.getGas().getGas().getID());
            data.add(this.inputGasTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputGasTank.getGas() != null) {
            data.add(true);
            data.add(this.outputGasTank.getGas().getGas().getID());
            data.add(this.outputGasTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            if (dataStream.readBoolean()) {
                this.inputFluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
            } else {
                this.inputFluidTank.setFluid(null);
            }
            if (dataStream.readBoolean()) {
                this.inputGasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.inputGasTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.outputGasTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.outputGasTank.setGas(null);
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.inputFluidTank.readFromNBT(nbtTags.func_74775_l("inputFluidTank"));
        this.inputGasTank.read(nbtTags.func_74775_l("inputGasTank"));
        this.outputGasTank.read(nbtTags.func_74775_l("outputGasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.writeToNBT(new NBTTagCompound()));
        nbtTags.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("outputGasTank", (NBTBase)this.outputGasTank.write(new NBTTagCompound()));
    }

    @Override
    public String func_145825_b() {
        return LangUtils.localize(this.func_145838_q().func_149739_a() + "." + this.fullName + ".short.name");
    }

    @Override
    public Map getRecipes() {
        return null;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                return new Object[]{this.getEnergy()};
            }
            case 1: {
                return new Object[]{this.operatingTicks};
            }
            case 2: {
                return new Object[]{this.isActive};
            }
            case 3: {
                return new Object[]{this.facing};
            }
            case 4: {
                return new Object[]{this.canOperate(this.getRecipe())};
            }
            case 5: {
                return new Object[]{this.getMaxEnergy()};
            }
            case 6: {
                return new Object[]{this.getMaxEnergy() - this.getEnergy()};
            }
            case 7: {
                return new Object[]{this.inputFluidTank.getFluidAmount()};
            }
            case 8: {
                return new Object[]{this.inputGasTank.getStored()};
            }
        }
        throw new NoSuchMethodException();
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.canFill(from, resource.getFluid())) {
            return this.inputFluidTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        SideData data = this.configComponent.getOutput(TransmissionType.FLUID, from.ordinal(), this.facing);
        if (data.hasSlot(0)) {
            return this.inputFluidTank.getFluid() == null || this.inputFluidTank.getFluid().getFluid() == fluid;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        SideData data = this.configComponent.getOutput(TransmissionType.FLUID, from.ordinal(), this.facing);
        return data.getFluidTankInfo(this);
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.inputGasTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.outputGasTank.draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(1) && this.inputGasTank.canReceive(type);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(2) && this.outputGasTank.canDraw(type);
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.inputGasTank, this.outputGasTank};
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return this.configComponent.getOutput(TransmissionType.GAS, side.ordinal(), this.facing).hasSlot(1, 2);
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.inputFluidTank.getFluid() != null) {
            itemStack.field_77990_d.func_74782_a("inputFluidTank", (NBTBase)this.inputFluidTank.getFluid().writeToNBT(new NBTTagCompound()));
        }
        if (this.inputGasTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("inputGasTank", (NBTBase)this.inputGasTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputGasTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("outputGasTank", (NBTBase)this.outputGasTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.inputFluidTank.setFluid(FluidStack.loadFluidStackFromNBT((NBTTagCompound)itemStack.field_77990_d.func_74775_l("inputFluidTank")));
        this.inputGasTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("inputGasTank")));
        this.outputGasTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("outputGasTank")));
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.inputFluidTank, this.inputGasTank, this.outputGasTank};
    }
}

