/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IFluidContainerManager;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITankManager;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.util.FluidContainerUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityFluidTank
extends TileEntityContainerBlock
implements IActiveState,
IConfigurable,
IFluidHandler,
ISustainedTank,
IFluidContainerManager,
ITankManager,
ISecurityTile,
ITierUpgradeable {
    public boolean isActive;
    public boolean clientActive;
    public FluidTank fluidTank;
    public FluidContainerUtils.ContainerEditMode editMode = FluidContainerUtils.ContainerEditMode.BOTH;
    public Tier.FluidTankTier tier = Tier.FluidTankTier.BASIC;
    public int updateDelay;
    public int prevAmount;
    public int valve;
    public Fluid valveFluid;
    public float prevScale;
    public boolean needsPacket;
    public int currentRedstoneLevel;
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);

    public TileEntityFluidTank() {
        super("FluidTank");
        this.fluidTank = new FluidTank(this.tier.storage);
        this.inventory = new ItemStack[2];
    }

    @Override
    public boolean upgrade(Tier.BaseTier upgradeTier) {
        if (upgradeTier.ordinal() != this.tier.ordinal() + 1) {
            return false;
        }
        this.tier = Tier.FluidTankTier.values()[upgradeTier.ordinal()];
        this.fluidTank.setCapacity(this.tier.storage);
        Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
        this.func_70296_d();
        return true;
    }

    @Override
    public boolean canSetFacing(int facing) {
        return false;
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K) {
            float targetScale;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.isActive = this.clientActive;
                    MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            if ((double)Math.abs(this.prevScale - (targetScale = (float)(this.fluidTank.getFluid() != null ? this.fluidTank.getFluid().amount : 0) / (float)this.fluidTank.getCapacity())) > 0.01) {
                this.prevScale = (9.0f * this.prevScale + targetScale) / 10.0f;
            }
        } else {
            int newRedstoneLevel;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    this.needsPacket = true;
                }
            }
            if (this.valve > 0) {
                --this.valve;
                if (this.valve == 0) {
                    this.valveFluid = null;
                    this.needsPacket = true;
                }
            }
            if (this.fluidTank.getFluidAmount() != this.prevAmount) {
                MekanismUtils.saveChunk(this);
                this.needsPacket = true;
            }
            this.prevAmount = this.fluidTank.getFluidAmount();
            if (this.inventory[0] != null) {
                this.manageInventory();
            }
            if (this.isActive) {
                this.activeEmit();
            }
            if ((newRedstoneLevel = this.getRedstoneLevel()) != this.currentRedstoneLevel) {
                this.func_70296_d();
                this.currentRedstoneLevel = newRedstoneLevel;
            }
            if (this.needsPacket) {
                Mekanism.packetHandler.sendToAllAround(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), Coord4D.get(this).getTargetPoint(50.0));
            }
            this.needsPacket = false;
        }
    }

    @Override
    public String func_145825_b() {
        return LangUtils.localize("tile.FluidTank" + this.tier.getBaseTier().getName() + ".name");
    }

    private void activeEmit() {
        TileEntity tileEntity;
        if (this.fluidTank.getFluid() != null && (tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.DOWN).getTileEntity((IBlockAccess)this.field_145850_b)) instanceof IFluidHandler) {
            FluidStack toDrain = new FluidStack(this.fluidTank.getFluid(), Math.min(this.tier.output, this.fluidTank.getFluidAmount()));
            this.fluidTank.drain(((IFluidHandler)tileEntity).fill(ForgeDirection.UP, toDrain, true), true);
        }
    }

    private void manageInventory() {
        if (this.inventory[0] != null) {
            FluidStack ret;
            if (this.inventory[0].func_77973_b() instanceof IFluidContainerItem) {
                FluidStack ret2;
                if (this.editMode == FluidContainerUtils.ContainerEditMode.FILL && this.fluidTank.getFluidAmount() > 0) {
                    FluidContainerUtils.handleContainerItemFill(this, this.fluidTank, 0, 1);
                } else if (this.editMode == FluidContainerUtils.ContainerEditMode.EMPTY && (ret2 = FluidContainerUtils.handleContainerItemEmpty(this, this.inventory, this.fluidTank.getFluid(), this.getCurrentNeeded(), 0, 1, null)) != null) {
                    this.fluidTank.setFluid(PipeUtils.copy(ret2, Math.min(this.fluidTank.getCapacity(), ret2.amount)));
                    int rejects = Math.max(0, ret2.amount - this.fluidTank.getCapacity());
                    if (rejects > 0) {
                        this.pushUp(PipeUtils.copy(ret2, rejects), true);
                    }
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)this.inventory[0]) && (this.editMode == FluidContainerUtils.ContainerEditMode.BOTH || this.editMode == FluidContainerUtils.ContainerEditMode.FILL)) {
                FluidContainerUtils.handleRegistryItemFill(this, this.fluidTank, 0, 1);
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)this.inventory[0]) && (this.editMode == FluidContainerUtils.ContainerEditMode.BOTH || this.editMode == FluidContainerUtils.ContainerEditMode.EMPTY) && (ret = FluidContainerUtils.handleRegistryItemEmpty(this, this.inventory, this.fluidTank.getFluid(), this.getCurrentNeeded(), 0, 1, null)) != null) {
                this.fluidTank.setFluid(PipeUtils.copy(ret, Math.min(this.fluidTank.getCapacity(), ret.amount)));
                int rejects = Math.max(0, ret.amount - this.fluidTank.getCapacity());
                if (rejects > 0) {
                    this.pushUp(PipeUtils.copy(ret, rejects), true);
                }
            }
        }
    }

    public int pushUp(FluidStack fluid, boolean doFill) {
        IFluidHandler handler;
        Coord4D up = Coord4D.get(this).getFromSide(ForgeDirection.UP);
        if (up.getTileEntity((IBlockAccess)this.field_145850_b) instanceof TileEntityFluidTank && (handler = (IFluidHandler)up.getTileEntity((IBlockAccess)this.field_145850_b)).canFill(ForgeDirection.DOWN, fluid.getFluid())) {
            return handler.fill(ForgeDirection.DOWN, fluid, doFill);
        }
        return 0;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        return slotID == 1;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 0) {
            if (itemstack.func_77973_b() instanceof IFluidContainerItem) {
                return true;
            }
            if (FluidContainerRegistry.isFilledContainer((ItemStack)itemstack)) {
                FluidStack stack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemstack);
                if (this.fluidTank.getFluid() == null || this.fluidTank.getFluid().isFluidEqual(stack)) {
                    return this.editMode == FluidContainerUtils.ContainerEditMode.EMPTY || this.editMode == FluidContainerUtils.ContainerEditMode.BOTH;
                }
            } else if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemstack)) {
                return this.editMode == FluidContainerUtils.ContainerEditMode.FILL || this.editMode == FluidContainerUtils.ContainerEditMode.BOTH;
            }
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{1};
        }
        if (side == 1) {
            return new int[]{0};
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74768_a("tier", this.tier.ordinal());
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("editMode", this.editMode.ordinal());
        if (this.fluidTank.getFluid() != null) {
            nbtTags.func_74782_a("fluidTank", (NBTBase)this.fluidTank.writeToNBT(new NBTTagCompound()));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.tier = Tier.FluidTankTier.values()[nbtTags.func_74762_e("tier")];
        this.clientActive = this.isActive = nbtTags.func_74767_n("isActive");
        this.editMode = FluidContainerUtils.ContainerEditMode.values()[nbtTags.func_74762_e("editMode")];
        if (nbtTags.func_74764_b("fluidTank")) {
            this.fluidTank.setCapacity(this.tier.storage);
            this.fluidTank.readFromNBT(nbtTags.func_74775_l("fluidTank"));
        }
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.tier = Tier.FluidTankTier.values()[dataStream.readInt()];
            this.fluidTank.setCapacity(this.tier.storage);
            this.clientActive = dataStream.readBoolean();
            this.valve = dataStream.readInt();
            this.editMode = FluidContainerUtils.ContainerEditMode.values()[dataStream.readInt()];
            this.valveFluid = this.valve > 0 ? FluidRegistry.getFluid((int)dataStream.readInt()) : null;
            if (dataStream.readInt() == 1) {
                this.fluidTank.setFluid(new FluidStack(FluidRegistry.getFluid((int)dataStream.readInt()), dataStream.readInt()));
            } else {
                this.fluidTank.setFluid(null);
            }
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.updateDelay = MekanismConfig.general.UPDATE_DELAY;
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
    }

    public int getRedstoneLevel() {
        double fractionFull = (float)this.fluidTank.getFluidAmount() / (float)this.fluidTank.getCapacity();
        return MathHelper.func_76141_d((float)((float)(fractionFull * 14.0))) + (fractionFull > 0.0 ? 1 : 0);
    }

    public int getCurrentNeeded() {
        int needed = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
        Coord4D top = Coord4D.get(this).getFromSide(ForgeDirection.UP);
        TileEntity topTile = top.getTileEntity((IBlockAccess)this.field_145850_b);
        if (topTile instanceof TileEntityFluidTank) {
            TileEntityFluidTank topTank = (TileEntityFluidTank)topTile;
            if (this.fluidTank.getFluid() != null && topTank.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() != topTank.fluidTank.getFluid().getFluid()) {
                return needed;
            }
            needed += topTank.getCurrentNeeded();
        }
        return needed;
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.tier.ordinal());
        data.add(this.isActive);
        data.add(this.valve);
        data.add(this.editMode.ordinal());
        if (this.valve > 0) {
            data.add(this.valveFluid.getID());
        }
        if (this.fluidTank.getFluid() != null) {
            data.add(1);
            data.add(this.fluidTank.getFluid().getFluidID());
            data.add(this.fluidTank.getFluid().amount);
        } else {
            data.add(0);
        }
        return data;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean onSneakRightClick(EntityPlayer player, int side) {
        if (!this.field_145850_b.field_72995_K) {
            this.setActive(!this.getActive());
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.click", 0.3f, 1.0f);
        }
        return true;
    }

    @Override
    public boolean onRightClick(EntityPlayer player, int side) {
        return false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource != null && this.canFill(from, resource.getFluid())) {
            int filled = this.fluidTank.fill(resource, doFill);
            if (filled < resource.amount && !this.isActive) {
                filled += this.pushUp(PipeUtils.copy(resource, resource.amount - filled), doFill);
            }
            if (filled > 0 && from == ForgeDirection.UP) {
                if (this.valve == 0) {
                    this.needsPacket = true;
                }
                this.valve = 20;
                this.valveFluid = resource.getFluid();
            }
            return filled;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource != null && this.canDrain(from, resource.getFluid())) {
            return this.fluidTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.canDrain(from, null)) {
            return this.fluidTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (from == ForgeDirection.DOWN) {
            TileEntity tile = Coord4D.get(this).getFromSide(ForgeDirection.DOWN).getTileEntity((IBlockAccess)this.field_145850_b);
            if (this.isActive && !(tile instanceof TileEntityFluidTank)) {
                return false;
            }
        }
        return this.fluidTank.getFluid() == null || this.fluidTank.getFluid().getFluid() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.fluidTank != null && (fluid == null || this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluid() == fluid)) {
            if (this.isActive) {
                return from != ForgeDirection.DOWN;
            }
            return true;
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{this.fluidTank.getInfo()};
    }

    @Override
    public void setFluidStack(FluidStack fluidStack, Object ... data) {
        this.fluidTank.setFluid(fluidStack);
    }

    @Override
    public FluidStack getFluidStack(Object ... data) {
        return this.fluidTank.getFluid();
    }

    @Override
    public boolean hasTank(Object ... data) {
        return true;
    }

    @Override
    public FluidContainerUtils.ContainerEditMode getContainerEditMode() {
        return this.editMode;
    }

    @Override
    public void setContainerEditMode(FluidContainerUtils.ContainerEditMode mode) {
        this.editMode = mode;
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.fluidTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    public void func_70299_a(int slotID, ItemStack itemstack) {
        this.inventory[slotID] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
    }
}

