/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasTankInfoProvider;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ChemicalPairInput;
import mekanism.common.recipe.machines.ChemicalInfuserRecipe;
import mekanism.common.recipe.outputs.GasOutput;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChemicalInfuser
extends TileEntityNoisyElectricBlock
implements IGasHandler,
IGasTankInfoProvider,
ITubeConnection,
IRedstoneControl,
ISustainedData,
IUpgradeTile,
Upgrade.IUpgradeInfoHandler,
ITankManager,
ISecurityTile {
    public GasTank leftTank = new GasTank(10000);
    public GasTank rightTank = new GasTank(10000);
    public GasTank centerTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public int updateDelay;
    public int gasOutput = 256;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public final double BASE_ENERGY_USAGE;
    public double energyPerTick = this.BASE_ENERGY_USAGE = MekanismConfig.usage.chemicalInfuserUsage;
    public ChemicalInfuserRecipe cachedRecipe;
    public double clientEnergyUsed;
    public TileComponentUpgrade upgradeComponent = new TileComponentUpgrade(this, 4);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalInfuser() {
        super("machine.cheminfuser", "ChemicalInfuser", BlockMachine.MachineType.CHEMICAL_INFUSER.baseEnergy);
        this.inventory = new ItemStack[5];
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            ChemicalInfuserRecipe recipe;
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && (this.leftTank.getGas() == null || this.leftTank.getStored() < this.leftTank.getMaxGas())) {
                this.leftTank.receive(GasTransmission.removeGas(this.inventory[0], this.leftTank.getGasType(), this.leftTank.getNeeded()), true);
            }
            if (this.inventory[1] != null && (this.rightTank.getGas() == null || this.rightTank.getStored() < this.rightTank.getMaxGas())) {
                this.rightTank.receive(GasTransmission.removeGas(this.inventory[1], this.rightTank.getGasType(), this.rightTank.getNeeded()), true);
            }
            if (this.inventory[2] != null && this.centerTank.getGas() != null) {
                this.centerTank.draw(GasTransmission.addGas(this.inventory[2], this.centerTank.getGas()), true);
            }
            if (this.canOperate(recipe = this.getRecipe()) && this.getEnergy() >= this.energyPerTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                int operations = this.operate(recipe);
                double prev = this.getEnergy();
                this.setEnergy(this.getEnergy() - this.energyPerTick * (double)operations);
                this.clientEnergyUsed = prev - this.getEnergy();
            } else if (this.prevEnergy >= this.getEnergy()) {
                this.setActive(false);
            }
            if (this.centerTank.getGas() != null) {
                GasStack toSend = new GasStack(this.centerTank.getGas().getGas(), Math.min(this.centerTank.getStored(), this.gasOutput));
                TileEntity tileEntity = Coord4D.get(this).getFromSide(ForgeDirection.getOrientation((int)this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), this.centerTank.getGas().getGas())) {
                    this.centerTank.draw(((IGasHandler)tileEntity).receiveGas(ForgeDirection.getOrientation((int)this.facing).getOpposite(), toSend, true), true);
                }
            }
            this.prevEnergy = this.getEnergy();
        }
    }

    public int getUpgradedUsage(ChemicalInfuserRecipe recipe) {
        int possibleProcess = (int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED));
        if (this.leftTank.getGasType() == ((ChemicalPairInput)recipe.recipeInput).leftGas.getGas()) {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
        } else {
            possibleProcess = Math.min(this.leftTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).rightGas.amount, possibleProcess);
            possibleProcess = Math.min(this.rightTank.getStored() / ((ChemicalPairInput)recipe.recipeInput).leftGas.amount, possibleProcess);
        }
        possibleProcess = Math.min(this.centerTank.getNeeded() / ((GasOutput)recipe.recipeOutput).output.amount, possibleProcess);
        possibleProcess = Math.min((int)(this.getEnergy() / this.energyPerTick), possibleProcess);
        return possibleProcess;
    }

    public ChemicalPairInput getInput() {
        return new ChemicalPairInput(this.leftTank.getGas(), this.rightTank.getGas());
    }

    public ChemicalInfuserRecipe getRecipe() {
        ChemicalPairInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ChemicalPairInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getChemicalInfuserRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public boolean canOperate(ChemicalInfuserRecipe recipe) {
        return recipe != null && recipe.canOperate(this.leftTank, this.rightTank, this.centerTank);
    }

    public int operate(ChemicalInfuserRecipe recipe) {
        int operations = this.getUpgradedUsage(recipe);
        recipe.operate(this.leftTank, this.rightTank, this.centerTank, operations);
        this.func_70296_d();
        return operations;
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.clientEnergyUsed = dataStream.readDouble();
            if (dataStream.readBoolean()) {
                this.leftTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.leftTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.rightTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.rightTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.centerTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.centerTank.setGas(null);
            }
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.clientEnergyUsed);
        if (this.leftTank.getGas() != null) {
            data.add(true);
            data.add(this.leftTank.getGas().getGas().getID());
            data.add(this.leftTank.getStored());
        } else {
            data.add(false);
        }
        if (this.rightTank.getGas() != null) {
            data.add(true);
            data.add(this.rightTank.getGas().getGas().getID());
            data.add(this.rightTank.getStored());
        } else {
            data.add(false);
        }
        if (this.centerTank.getGas() != null) {
            data.add(true);
            data.add(this.centerTank.getGas().getGas().getID());
            data.add(this.centerTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.leftTank.read(nbtTags.func_74775_l("leftTank"));
        this.rightTank.read(nbtTags.func_74775_l("rightTank"));
        this.centerTank.read(nbtTags.func_74775_l("centerTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74782_a("leftTank", (NBTBase)this.leftTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("rightTank", (NBTBase)this.rightTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("centerTank", (NBTBase)this.centerTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    public GasTank getTank(ForgeDirection side) {
        if (side == MekanismUtils.getLeft(this.facing)) {
            return this.leftTank;
        }
        if (side == MekanismUtils.getRight(this.facing)) {
            return this.rightTank;
        }
        if (side == ForgeDirection.getOrientation((int)this.facing)) {
            return this.centerTank;
        }
        return null;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing) || side == ForgeDirection.getOrientation((int)this.facing);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) != this.centerTank ? this.getTank(side).canReceive(type) : false;
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack != null ? stack.getGas() : null)) {
            return this.getTank(side).receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        if (this.canDrawGas(side, null)) {
            return this.getTank(side).draw(amount, doTransfer);
        }
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return this.getTank(side) != null && this.getTank(side) == this.centerTank ? this.getTank(side).canDraw(type) : false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.leftTank, this.rightTank, this.centerTank};
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 0 || slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canReceiveGas(itemstack, null);
        }
        if (slotID == 1) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        if (slotID == 3) {
            return ChargeUtils.canBeOutputted(itemstack, false);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal()) {
            return new int[]{0};
        }
        if (side == this.facing) {
            return new int[]{1};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{2};
        }
        if (side == 0 || side == 1) {
            return new int[3];
        }
        return InventoryUtils.EMPTY;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.leftTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("leftTank", (NBTBase)this.leftTank.getGas().write(new NBTTagCompound()));
        }
        if (this.rightTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("rightTank", (NBTBase)this.rightTank.getGas().write(new NBTTagCompound()));
        }
        if (this.centerTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("centerTank", (NBTBase)this.centerTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.leftTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("leftTank")));
        this.rightTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("rightTank")));
        this.centerTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("centerTank")));
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case ENERGY: {
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                this.energyPerTick = MekanismUtils.getBaseEnergyPerTick(this, this.BASE_ENERGY_USAGE);
            }
        }
    }

    @Override
    public List<String> getInfo(Upgrade upgrade) {
        return upgrade == Upgrade.SPEED ? upgrade.getExpScaledInfo(this) : upgrade.getMultScaledInfo(this);
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.leftTank, this.rightTank, this.centerTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

