/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.Range4D;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTank;
import mekanism.api.gas.GasTankInfo;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.gas.IGasItem;
import mekanism.api.gas.IGasTankInfoProvider;
import mekanism.api.gas.ITubeConnection;
import mekanism.common.Mekanism;
import mekanism.common.Upgrade;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ITankManager;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.block.BlockMachine;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.DissolutionRecipe;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityNoisyElectricBlock;
import mekanism.common.tile.component.TileComponentAdvancedUpgrade;
import mekanism.common.tile.component.TileComponentSecurity;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.util.ChargeUtils;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityChemicalDissolutionChamber
extends TileEntityNoisyElectricBlock
implements ITubeConnection,
IRedstoneControl,
IGasHandler,
IGasTankInfoProvider,
IUpgradeTile,
ISustainedData,
ITankManager,
ISecurityTile {
    public GasTank injectTank = new GasTank(10000);
    public GasTank outputTank = new GasTank(10000);
    public static final int MAX_GAS = 10000;
    public static final int BASE_INJECT_USAGE = 1;
    public double injectUsage = 1.0;
    public int injectUsageThisTick;
    public int updateDelay;
    public int gasOutput = 256;
    public boolean isActive;
    public boolean clientActive;
    public double prevEnergy;
    public int operatingTicks = 0;
    public int BASE_TICKS_REQUIRED = 100;
    public int ticksRequired = 100;
    public final double BASE_ENERGY_USAGE = MekanismConfig.usage.chemicalDissolutionChamberUsage;
    public double energyUsage = MekanismConfig.usage.chemicalDissolutionChamberUsage;
    public DissolutionRecipe cachedRecipe;
    public TileComponentUpgrade upgradeComponent = new TileComponentAdvancedUpgrade(this, 4);
    public TileComponentSecurity securityComponent = new TileComponentSecurity(this);
    public IRedstoneControl.RedstoneControl controlType = IRedstoneControl.RedstoneControl.DISABLED;

    public TileEntityChemicalDissolutionChamber() {
        super("machine.dissolution", "ChemicalDissolutionChamber", BlockMachine.MachineType.CHEMICAL_DISSOLUTION_CHAMBER.baseEnergy);
        this.inventory = new ItemStack[5];
        this.upgradeComponent.setSupported(Upgrade.MUFFLING);
    }

    @Override
    public void onUpdate() {
        if (this.field_145850_b.field_72995_K && this.updateDelay > 0) {
            --this.updateDelay;
            if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                this.isActive = this.clientActive;
                MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.updateDelay > 0) {
                --this.updateDelay;
                if (this.updateDelay == 0 && this.clientActive != this.isActive) {
                    Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
                }
            }
            ChargeUtils.discharge(3, this);
            if (this.inventory[0] != null && this.injectTank.getNeeded() > 0) {
                this.injectTank.receive(GasTransmission.removeGas(this.inventory[0], GasRegistry.getGas("sulfuricAcid"), this.injectTank.getNeeded()), true);
            }
            if (this.inventory[2] != null && this.outputTank.getGas() != null) {
                this.outputTank.draw(GasTransmission.addGas(this.inventory[2], this.outputTank.getGas()), true);
            }
            boolean changed = false;
            DissolutionRecipe recipe = this.getRecipe();
            this.injectUsageThisTick = Math.max(1, StatUtils.inversePoisson(this.injectUsage));
            if (this.canOperate(recipe) && this.getEnergy() >= this.energyUsage && this.injectTank.getStored() >= this.injectUsageThisTick && MekanismUtils.canFunction(this)) {
                this.setActive(true);
                this.setEnergy(this.getEnergy() - this.energyUsage);
                this.minorOperate();
                if (this.operatingTicks + 1 < this.ticksRequired) {
                    ++this.operatingTicks;
                } else {
                    this.operate(recipe);
                    this.operatingTicks = 0;
                }
            } else if (this.prevEnergy >= this.getEnergy()) {
                changed = true;
                this.setActive(false);
            }
            if (changed && !this.canOperate(recipe)) {
                this.operatingTicks = 0;
            }
            this.prevEnergy = this.getEnergy();
            if (this.outputTank.getGas() != null) {
                GasStack toSend = new GasStack(this.outputTank.getGas().getGas(), Math.min(this.outputTank.getStored(), this.gasOutput));
                TileEntity tileEntity = Coord4D.get(this).getFromSide(MekanismUtils.getRight(this.facing)).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tileEntity instanceof IGasHandler && ((IGasHandler)tileEntity).canReceiveGas(MekanismUtils.getRight(this.facing).getOpposite(), this.outputTank.getGas().getGas())) {
                    this.outputTank.draw(((IGasHandler)tileEntity).receiveGas(MekanismUtils.getRight(this.facing).getOpposite(), toSend, true), true);
                }
            }
        }
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        if (slotID == 1) {
            return RecipeHandler.getDissolutionRecipe(new ItemStackInput(itemstack)) != null;
        }
        if (slotID == 3) {
            return ChargeUtils.canBeDischarged(itemstack);
        }
        return false;
    }

    @Override
    public boolean func_102008_b(int slotID, ItemStack itemstack, int side) {
        if (slotID == 2) {
            return itemstack != null && itemstack.func_77973_b() instanceof IGasItem && ((IGasItem)itemstack.func_77973_b()).canProvideGas(itemstack, null);
        }
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        if (side == MekanismUtils.getLeft(this.facing).ordinal() || side == 1) {
            return new int[]{1};
        }
        if (side == 0) {
            return new int[]{0};
        }
        if (side == MekanismUtils.getRight(this.facing).ordinal()) {
            return new int[]{2};
        }
        return InventoryUtils.EMPTY;
    }

    public double getScaledProgress() {
        return (double)this.operatingTicks / (double)this.ticksRequired;
    }

    public DissolutionRecipe getRecipe() {
        ItemStackInput input = this.getInput();
        if (this.cachedRecipe == null || !input.testEquality((ItemStackInput)this.cachedRecipe.getInput())) {
            this.cachedRecipe = RecipeHandler.getDissolutionRecipe(this.getInput());
        }
        return this.cachedRecipe;
    }

    public ItemStackInput getInput() {
        return new ItemStackInput(this.inventory[1]);
    }

    public boolean canOperate(DissolutionRecipe recipe) {
        return recipe != null && recipe.canOperate(this.inventory, this.outputTank);
    }

    public void operate(DissolutionRecipe recipe) {
        recipe.operate(this.inventory, this.outputTank);
        this.func_70296_d();
    }

    public void minorOperate() {
        this.injectTank.draw(this.injectUsageThisTick, true);
    }

    @Override
    public void handlePacketData(ByteBuf dataStream) {
        super.handlePacketData(dataStream);
        if (this.field_145850_b.field_72995_K) {
            this.isActive = dataStream.readBoolean();
            this.controlType = IRedstoneControl.RedstoneControl.values()[dataStream.readInt()];
            this.operatingTicks = dataStream.readInt();
            if (dataStream.readBoolean()) {
                this.injectTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.injectTank.setGas(null);
            }
            if (dataStream.readBoolean()) {
                this.outputTank.setGas(new GasStack(GasRegistry.getGas(dataStream.readInt()), dataStream.readInt()));
            } else {
                this.outputTank.setGas(null);
            }
            MekanismUtils.updateBlock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public ArrayList getNetworkedData(ArrayList data) {
        super.getNetworkedData(data);
        data.add(this.isActive);
        data.add(this.controlType.ordinal());
        data.add(this.operatingTicks);
        if (this.injectTank.getGas() != null) {
            data.add(true);
            data.add(this.injectTank.getGas().getGas().getID());
            data.add(this.injectTank.getStored());
        } else {
            data.add(false);
        }
        if (this.outputTank.getGas() != null) {
            data.add(true);
            data.add(this.outputTank.getGas().getGas().getID());
            data.add(this.outputTank.getStored());
        } else {
            data.add(false);
        }
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTags) {
        super.func_145839_a(nbtTags);
        this.isActive = nbtTags.func_74767_n("isActive");
        this.controlType = IRedstoneControl.RedstoneControl.values()[nbtTags.func_74762_e("controlType")];
        this.operatingTicks = nbtTags.func_74762_e("operatingTicks");
        this.injectTank.read(nbtTags.func_74775_l("injectTank"));
        this.outputTank.read(nbtTags.func_74775_l("gasTank"));
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTags) {
        super.func_145841_b(nbtTags);
        nbtTags.func_74757_a("isActive", this.isActive);
        nbtTags.func_74768_a("controlType", this.controlType.ordinal());
        nbtTags.func_74768_a("operatingTicks", this.operatingTicks);
        nbtTags.func_74782_a("injectTank", (NBTBase)this.injectTank.write(new NBTTagCompound()));
        nbtTags.func_74782_a("gasTank", (NBTBase)this.outputTank.write(new NBTTagCompound()));
    }

    @Override
    public boolean canSetFacing(int i) {
        return i != 0 && i != 1;
    }

    @Override
    public void setActive(boolean active) {
        this.isActive = active;
        if (this.clientActive != active && this.updateDelay == 0) {
            Mekanism.packetHandler.sendToReceivers(new PacketTileEntity.TileEntityMessage(Coord4D.get(this), this.getNetworkedData(new ArrayList())), new Range4D(Coord4D.get(this)));
            this.updateDelay = 10;
            this.clientActive = active;
        }
    }

    @Override
    public boolean getActive() {
        return this.isActive;
    }

    @Override
    public boolean renderUpdate() {
        return false;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    @Override
    public boolean canTubeConnect(ForgeDirection side) {
        return side == MekanismUtils.getLeft(this.facing) || side == MekanismUtils.getRight(this.facing);
    }

    @Override
    public IRedstoneControl.RedstoneControl getControlType() {
        return this.controlType;
    }

    @Override
    public void setControlType(IRedstoneControl.RedstoneControl type) {
        this.controlType = type;
        MekanismUtils.saveChunk(this);
    }

    @Override
    public boolean canPulse() {
        return false;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack, boolean doTransfer) {
        if (this.canReceiveGas(side, stack.getGas())) {
            return this.injectTank.receive(stack, doTransfer);
        }
        return 0;
    }

    @Override
    public int receiveGas(ForgeDirection side, GasStack stack) {
        return this.receiveGas(side, stack, true);
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount, boolean doTransfer) {
        return null;
    }

    @Override
    public GasStack drawGas(ForgeDirection side, int amount) {
        return this.drawGas(side, amount, true);
    }

    @Override
    public boolean canReceiveGas(ForgeDirection side, Gas type) {
        return side == MekanismUtils.getLeft(this.facing) && type == GasRegistry.getGas("sulfuricAcid");
    }

    @Override
    public boolean canDrawGas(ForgeDirection side, Gas type) {
        return false;
    }

    @Override
    @Nonnull
    public GasTankInfo[] getTankInfo() {
        return new GasTankInfo[]{this.injectTank, this.outputTank};
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (this.injectTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("injectTank", (NBTBase)this.injectTank.getGas().write(new NBTTagCompound()));
        }
        if (this.outputTank.getGas() != null) {
            itemStack.field_77990_d.func_74782_a("outputTank", (NBTBase)this.outputTank.getGas().write(new NBTTagCompound()));
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        this.injectTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("injectTank")));
        this.outputTank.setGas(GasStack.readFromNBT(itemStack.field_77990_d.func_74775_l("outputTank")));
    }

    @Override
    public void recalculateUpgradables(Upgrade upgrade) {
        super.recalculateUpgradables(upgrade);
        switch (upgrade) {
            case GAS: {
                this.injectUsage = MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
                break;
            }
            case SPEED: {
                this.ticksRequired = MekanismUtils.getTicks(this, this.BASE_TICKS_REQUIRED);
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.injectUsage = MekanismUtils.getSecondaryEnergyPerTickMean(this, 1);
                break;
            }
            case ENERGY: {
                this.energyUsage = MekanismUtils.getEnergyPerTick(this, this.BASE_ENERGY_USAGE);
                this.maxEnergy = MekanismUtils.getMaxEnergy(this, this.BASE_MAX_ENERGY);
                break;
            }
        }
    }

    @Override
    public Object[] getTanks() {
        return new Object[]{this.injectTank, this.outputTank};
    }

    @Override
    public TileComponentSecurity getSecurity() {
        return this.securityComponent;
    }
}

