/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import mekanism.api.Coord4D;
import mekanism.common.content.boiler.BoilerSteamTank;
import mekanism.common.content.boiler.BoilerTank;
import mekanism.common.content.boiler.BoilerWaterTank;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing
implements IFluidHandler {
    public BoilerTank waterTank = new BoilerWaterTank(this);
    public BoilerTank steamTank = new BoilerSteamTank(this);

    public TileEntityBoilerValve() {
        super("BoilerValve");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1 && ((SynchronizedBoilerData)this.structure).steamStored != null && ((SynchronizedBoilerData)this.structure).steamStored.amount > 0) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = Coord4D.get(this).getFromSide(side).getTileEntity((IBlockAccess)this.field_145850_b);
                if (!(tile instanceof IFluidHandler) || tile instanceof TileEntityBoilerValve || !((IFluidHandler)tile).canFill(side.getOpposite(), ((SynchronizedBoilerData)this.structure).steamStored.getFluid())) continue;
                ((SynchronizedBoilerData)this.structure).steamStored.amount -= ((IFluidHandler)tile).fill(side.getOpposite(), ((SynchronizedBoilerData)this.structure).steamStored, true);
                if (((SynchronizedBoilerData)this.structure).steamStored.amount > 0) continue;
                ((SynchronizedBoilerData)this.structure).steamStored = null;
            }
        }
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1) {
                return new FluidTankInfo[]{this.steamTank.getInfo()};
            }
            return new FluidTankInfo[]{this.waterTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d < ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1 && ((SynchronizedBoilerData)this.structure).steamStored != null && resource.getFluid() == ((SynchronizedBoilerData)this.structure).steamStored.getFluid()) {
            return this.steamTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1) {
            return this.steamTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            return ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d < ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1;
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            return ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.field_145848_d >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.yCoord - 1;
        }
        return false;
    }
}

