/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import mekanism.client.MekanismClient;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.frequency.Frequency;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;

public class PacketSecurityUpdate
implements IMessageHandler<SecurityUpdateMessage, IMessage> {
    public IMessage onMessage(SecurityUpdateMessage message, MessageContext context) {
        if (message.packetType == SecurityPacket.UPDATE) {
            MekanismClient.clientSecurityMap.put(message.playerUsername, message.securityData);
        }
        return null;
    }

    public static enum SecurityPacket {
        UPDATE,
        FULL;

    }

    public static class SecurityUpdateMessage
    implements IMessage {
        public SecurityPacket packetType;
        public String playerUsername;
        public SecurityData securityData;

        public SecurityUpdateMessage() {
        }

        public SecurityUpdateMessage(SecurityPacket type, String username, SecurityData data) {
            this.packetType = type;
            if (this.packetType == SecurityPacket.UPDATE) {
                this.playerUsername = username;
                this.securityData = data;
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == SecurityPacket.UPDATE) {
                PacketHandler.writeString(dataStream, this.playerUsername);
                this.securityData.write(dataStream);
            } else if (this.packetType == SecurityPacket.FULL) {
                ArrayList<SecurityFrequency> frequencies = new ArrayList<SecurityFrequency>();
                for (Frequency frequency : Mekanism.securityFrequencies.getFrequencies()) {
                    if (!(frequency instanceof SecurityFrequency)) continue;
                    frequencies.add((SecurityFrequency)frequency);
                }
                dataStream.writeInt(frequencies.size());
                for (SecurityFrequency securityFrequency : frequencies) {
                    PacketHandler.writeString(dataStream, securityFrequency.owner);
                    new SecurityData(securityFrequency).write(dataStream);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = SecurityPacket.values()[dataStream.readInt()];
            if (this.packetType == SecurityPacket.UPDATE) {
                this.playerUsername = PacketHandler.readString(dataStream);
                this.securityData = SecurityData.read(dataStream);
            } else if (this.packetType == SecurityPacket.FULL) {
                MekanismClient.clientSecurityMap.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    String owner = PacketHandler.readString(dataStream);
                    SecurityData data = SecurityData.read(dataStream);
                    MekanismClient.clientSecurityMap.put(owner, data);
                }
            }
        }
    }
}

