/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.block.BlockMachine;
import mekanism.common.inventory.InventoryPersonalChest;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;

public class PacketPersonalChest
implements IMessageHandler<PersonalChestMessage, IMessage> {
    public IMessage onMessage(PersonalChestMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        if (message.packetType == PersonalChestPacketType.SERVER_OPEN) {
            try {
                if (message.isBlock) {
                    TileEntityPersonalChest tileEntity = (TileEntityPersonalChest)message.coord4D.getTileEntity((IBlockAccess)player.field_70170_p);
                    MekanismUtils.openPersonalChestGui((EntityPlayerMP)player, tileEntity, null, true);
                } else {
                    ItemStack stack = player.func_71045_bC();
                    if (BlockMachine.MachineType.get(stack) == BlockMachine.MachineType.PERSONAL_CHEST) {
                        InventoryPersonalChest inventory = new InventoryPersonalChest(player);
                        MekanismUtils.openPersonalChestGui((EntityPlayerMP)player, null, (IInventory)inventory, false);
                    }
                }
            }
            catch (Exception e) {
                Mekanism.logger.error("Error while handling electric chest open packet.");
                e.printStackTrace();
            }
        } else if (message.packetType == PersonalChestPacketType.CLIENT_OPEN) {
            try {
                int x = message.coord4D != null ? message.coord4D.xCoord : 0;
                int y = message.coord4D != null ? message.coord4D.yCoord : 0;
                int z = message.coord4D != null ? message.coord4D.zCoord : 0;
                Mekanism.proxy.openPersonalChest(player, message.guiType, message.windowId, message.isBlock, x, y, z);
            }
            catch (Exception e) {
                Mekanism.logger.error("Error while handling electric chest open packet.");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static enum PersonalChestPacketType {
        CLIENT_OPEN,
        SERVER_OPEN;

    }

    public static class PersonalChestMessage
    implements IMessage {
        public PersonalChestPacketType packetType;
        public boolean isBlock;
        public int guiType;
        public int windowId;
        public Coord4D coord4D;
        public int hotbarSlot;

        public PersonalChestMessage() {
        }

        public PersonalChestMessage(PersonalChestPacketType type, boolean b1, int i1, int i2, Coord4D c1, int slot) {
            this.packetType = type;
            switch (this.packetType) {
                case CLIENT_OPEN: {
                    this.guiType = i1;
                    this.windowId = i2;
                    this.isBlock = b1;
                    if (this.isBlock) {
                        this.coord4D = c1;
                        break;
                    }
                    this.hotbarSlot = slot;
                    break;
                }
                case SERVER_OPEN: {
                    this.isBlock = b1;
                    if (this.isBlock) {
                        this.coord4D = c1;
                        break;
                    }
                    this.hotbarSlot = slot;
                }
            }
        }

        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            switch (this.packetType) {
                case CLIENT_OPEN: {
                    dataStream.writeInt(this.guiType);
                    dataStream.writeInt(this.windowId);
                    dataStream.writeBoolean(this.isBlock);
                    if (!this.isBlock) break;
                    dataStream.writeInt(this.coord4D.xCoord);
                    dataStream.writeInt(this.coord4D.yCoord);
                    dataStream.writeInt(this.coord4D.zCoord);
                    dataStream.writeInt(this.coord4D.dimensionId);
                    break;
                }
                case SERVER_OPEN: {
                    dataStream.writeBoolean(this.isBlock);
                    if (!this.isBlock) break;
                    dataStream.writeInt(this.coord4D.xCoord);
                    dataStream.writeInt(this.coord4D.yCoord);
                    dataStream.writeInt(this.coord4D.zCoord);
                    dataStream.writeInt(this.coord4D.dimensionId);
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = PersonalChestPacketType.values()[dataStream.readInt()];
            if (this.packetType == PersonalChestPacketType.SERVER_OPEN) {
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                }
            } else if (this.packetType == PersonalChestPacketType.CLIENT_OPEN) {
                this.guiType = dataStream.readInt();
                this.windowId = dataStream.readInt();
                this.isBlock = dataStream.readBoolean();
                if (this.isBlock) {
                    this.coord4D = new Coord4D(dataStream.readInt(), dataStream.readInt(), dataStream.readInt(), dataStream.readInt());
                }
            }
        }
    }
}

