/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.MekanismConfig;
import mekanism.common.Tier;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.item.ItemMekanism;
import mekanism.common.tile.TileEntityBasicBlock;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemTierInstaller
extends ItemMekanism {
    public IIcon[] icons = new IIcon[256];

    public ItemTierInstaller() {
        this.func_77627_a(true);
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return false;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        Tier.BaseTier tier = Tier.BaseTier.values()[stack.func_77960_j()];
        if (tile instanceof ITierUpgradeable && MekanismConfig.machines.isEnabled("Factory")) {
            if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).playersUsing.size() > 0) {
                return true;
            }
            if (((ITierUpgradeable)tile).upgrade(tier)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public void func_94581_a(IIconRegister register) {
        for (Tier.BaseTier tier : Tier.BaseTier.values()) {
            if (!tier.isObtainable()) continue;
            this.icons[tier.ordinal()] = register.func_94245_a("mekanism:" + tier.getName() + "TierInstaller");
        }
    }

    public IIcon func_77617_a(int meta) {
        return this.icons[meta];
    }

    public void func_150895_a(Item item, CreativeTabs tabs, List itemList) {
        for (Tier.BaseTier tier : Tier.BaseTier.values()) {
            if (!tier.isObtainable()) continue;
            itemList.add(new ItemStack(item, 1, tier.ordinal()));
        }
    }

    public String func_77667_c(ItemStack item) {
        return "item." + Tier.BaseTier.values()[item.func_77960_j()].getName().toLowerCase() + "TierInstaller";
    }
}

