/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.common.Mekanism;
import mekanism.common.item.ItemEnergized;
import mekanism.common.security.IOwnerItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.util.LangUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class ItemPortableTeleporter
extends ItemEnergized
implements IOwnerItem {
    public ItemPortableTeleporter() {
        super(1000000.0);
    }

    @Override
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityplayer, List list, boolean flag) {
        list.add(SecurityUtils.getOwnerDisplay(entityplayer.func_70005_c_(), this.getOwner(itemstack)));
        if (this.getFrequency(itemstack) != null) {
            list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.frequency") + ": " + (Object)((Object)EnumColor.GREY) + this.getFrequency(itemstack));
            String name = "trusted";
            ISecurityTile.SecurityMode access = this.getAccess(itemstack);
            if (access == ISecurityTile.SecurityMode.PUBLIC) {
                name = "public";
            } else if (access == ISecurityTile.SecurityMode.PRIVATE) {
                name = "private";
            }
            list.add((Object)((Object)EnumColor.INDIGO) + LangUtils.localize("gui.mode") + ": " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui." + name));
        }
        super.func_77624_a(itemstack, entityplayer, list, flag);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (!world.field_72995_K) {
            if (this.getOwner(itemstack) == null) {
                this.setOwner(itemstack, entityplayer.func_70005_c_());
                entityplayer.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.nowOwn")));
            } else if (SecurityUtils.canAccess(entityplayer, itemstack)) {
                entityplayer.openGui((Object)Mekanism.instance, 14, world, 0, 0, 0);
            } else {
                SecurityUtils.displayNoAccess(entityplayer);
            }
        }
        return itemstack;
    }

    public static double calculateEnergyCost(Entity entity, Coord4D coords) {
        if (coords == null) {
            return 0.0;
        }
        int neededEnergy = 1000;
        if (entity.field_70170_p.field_73011_w.field_76574_g != coords.dimensionId) {
            neededEnergy += 10000;
        }
        int distance = (int)entity.func_70011_f((double)coords.xCoord, (double)coords.yCoord, (double)coords.zCoord);
        return neededEnergy += distance * 10;
    }

    @Override
    public boolean canSend(ItemStack itemStack) {
        return false;
    }

    @Override
    public String getOwner(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("owner")) {
            return stack.field_77990_d.func_74779_i("owner");
        }
        return null;
    }

    @Override
    public void setOwner(ItemStack stack, String owner) {
        this.setFrequency(stack, null);
        this.setAccess(stack, ISecurityTile.SecurityMode.PUBLIC);
        if (owner == null || owner.isEmpty()) {
            stack.field_77990_d.func_82580_o("owner");
            return;
        }
        stack.field_77990_d.func_74778_a("owner", owner);
    }

    @Override
    public boolean hasOwner(ItemStack stack) {
        return true;
    }

    public ISecurityTile.SecurityMode getAccess(ItemStack stack) {
        if (stack.field_77990_d != null) {
            if (stack.field_77990_d.func_74764_b("access")) {
                return ISecurityTile.SecurityMode.values()[stack.field_77990_d.func_74762_e("access")];
            }
            boolean priv = stack.field_77990_d.func_74767_n("private");
            if (priv) {
                return ISecurityTile.SecurityMode.PRIVATE;
            }
        }
        return ISecurityTile.SecurityMode.PUBLIC;
    }

    public void setAccess(ItemStack stack, ISecurityTile.SecurityMode access) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.field_77990_d.func_74768_a("access", access.ordinal());
    }

    public String getFrequency(ItemStack stack) {
        if (stack.field_77990_d != null && stack.field_77990_d.func_74764_b("frequency")) {
            return stack.field_77990_d.func_74779_i("frequency");
        }
        return null;
    }

    public void setFrequency(ItemStack stack, String frequency) {
        if (stack.field_77990_d == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (frequency == null || frequency.isEmpty()) {
            stack.field_77990_d.func_82580_o("frequency");
            return;
        }
        stack.field_77990_d.func_74778_a("frequency", frequency);
    }
}

