/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.Recipes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mekanism.api.MekanismConfig;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseObject;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.recipe.RecipeHelper;
import mekanism.api.util.StackUtils;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismItems;
import mekanism.common.Resource;
import mekanism.common.Tier;
import mekanism.common.block.BlockMachine;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;

public final class OreDictManager {
    public static void init() {
        OreDictManager.addLogRecipes();
        String mekanismMaterial = Resource.OSMIUM.getOredictName();
        for (ItemStack ore : OreDictionary.getOres((String)"plankWood")) {
            if (ore.func_77981_g()) {
                ItemStack wildStack = new ItemStack(ore.func_77973_b(), 1, Short.MAX_VALUE);
                if (RecipeHandler.Recipe.PRECISION_SAWMILL.containsRecipe(wildStack)) continue;
                RecipeHandler.addPrecisionSawmillRecipe(wildStack, new ItemStack(Items.field_151055_y, 6), new ItemStack(MekanismItems.Sawdust), 0.25);
                continue;
            }
            RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151055_y, 6), new ItemStack(MekanismItems.Sawdust), 0.25);
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotSteel")) {
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("REDSTONE"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.EnrichedAlloy));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreNetherSteel")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 4, 1));
        }
        if (OreDictionary.getOres((String)"itemRawRubber").size() > 0) {
            for (ItemStack ore : OreDictionary.getOres((String)"woodRubber")) {
                RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(ore, 1), new ItemStack(Blocks.field_150344_f, 4), StackUtils.size((ItemStack)OreDictionary.getOres((String)"itemRawRubber").get(0), 2), 1.0);
            }
        } else if (OreDictionary.getOres((String)"itemRubber").size() > 0) {
            for (ItemStack ore : OreDictionary.getOres((String)"woodRubber")) {
                RecipeHandler.addPrecisionSawmillRecipe(StackUtils.size(ore, 1), new ItemStack(Blocks.field_150344_f, 4), StackUtils.size((ItemStack)OreDictionary.getOres((String)"itemRubber").get(0), 2), 1.0);
            }
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustSulfur")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas("sulfurDioxideGas"), 100));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustSalt")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas("brine"), 15));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustRefinedObsidian")) {
            RecipeHandler.addOsmiumCompressorRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Ingot, 1, 0));
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 6));
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.CompressedObsidian));
            InfuseRegistry.registerInfuseObject(StackUtils.size(ore, 1), new InfuseObject(InfuseRegistry.get("OBSIDIAN"), 10));
        }
        for (Resource resource : Resource.values()) {
            for (ItemStack ore : OreDictionary.getOres((String)("clump" + resource.getOredictName()))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.DirtyDust, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("shard" + resource.getOredictName()))) {
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Clump, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("crystal" + resource.getOredictName()))) {
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(ore, 1), "hydrogenChloride", new ItemStack(MekanismItems.Shard, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("dustDirty" + resource.getOredictName()))) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ore" + resource.getOredictName()))) {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 2, resource.ordinal()));
                RecipeHandler.addPurificationChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Clump, 3, resource.ordinal()));
                RecipeHandler.addChemicalInjectionChamberRecipe(StackUtils.size(ore, 1), "hydrogenChloride", new ItemStack(MekanismItems.Shard, 4, resource.ordinal()));
                RecipeHandler.addChemicalDissolutionChamberRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas(resource.getOredictName().toLowerCase()), 1000));
            }
            for (ItemStack ore : OreDictionary.getOres((String)("ingot" + resource.getOredictName()))) {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.Dust, 1, resource.ordinal()));
            }
            try {
                for (ItemStack ore : OreDictionary.getOres((String)("dust" + resource.getOredictName()))) {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(ore, 8), StackUtils.size((ItemStack)OreDictionary.getOres((String)("ore" + resource.getOredictName())).get(0), 1));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (MekanismConfig.recipes.enableOsmiumBlock) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(MekanismBlocks.BasicBlock, 1, 0), "XXX", "XXX", "XXX", Character.valueOf('X'), "ingot" + mekanismMaterial));
        }
        if (MekanismConfig.recipes.enableMachineUpgrades) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(MekanismItems.SpeedUpgrade), " G ", "ADA", " G ", Character.valueOf('G'), "blockGlass", Character.valueOf('A'), MekanismItems.EnrichedAlloy, Character.valueOf('D'), "dust" + mekanismMaterial));
        }
        if (MekanismConfig.recipes.enableMetallurgicInfuser) {
            BlockMachine.MachineType.METALLURGIC_INFUSER.addRecipe(new ShapedMekanismRecipe(new ItemStack(MekanismBlocks.MachineBlock, 1, 8), "IFI", "ROR", "IFI", Character.valueOf('I'), "ingotIron", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('R'), "dustRedstone", Character.valueOf('O'), "ingot" + mekanismMaterial));
        }
        if (MekanismConfig.recipes.enablePurificationChamber) {
            BlockMachine.MachineType.PURIFICATION_CHAMBER.addRecipe(new ShapedMekanismRecipe(new ItemStack(MekanismBlocks.MachineBlock, 1, 9), "ECE", "ORO", "ECE", Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.ADVANCED), Character.valueOf('E'), "alloyAdvanced", Character.valueOf('O'), "ingot" + mekanismMaterial, Character.valueOf('R'), new ItemStack(MekanismBlocks.MachineBlock, 1, 0)));
        }
        if (MekanismConfig.recipes.enableSteelCasing) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(MekanismBlocks.BasicBlock, 1, 8), "SGS", "GPG", "SGS", Character.valueOf('S'), "ingotSteel", Character.valueOf('P'), "ingot" + mekanismMaterial, Character.valueOf('G'), "blockGlass"));
        }
        if (MekanismConfig.recipes.enableElectricPump) {
            BlockMachine.MachineType.ELECTRIC_PUMP.addRecipe(new ShapedMekanismRecipe(new ItemStack(MekanismBlocks.MachineBlock, 1, 12), " B ", "ECE", "OOO", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('C'), new ItemStack(MekanismBlocks.BasicBlock, 1, 8), Character.valueOf('O'), "ingot" + mekanismMaterial));
        }
        if (MekanismConfig.recipes.enableElectroliticCore) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(MekanismItems.ElectrolyticCore), "EPE", "IEG", "EPE", Character.valueOf('E'), MekanismItems.EnrichedAlloy, Character.valueOf('P'), "dust" + mekanismMaterial, Character.valueOf('I'), "dustIron", Character.valueOf('G'), "dustGold"));
        }
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(Blocks.field_150448_aq, 24), "O O", "OSO", "O O", Character.valueOf('O'), "ingot" + mekanismMaterial, Character.valueOf('S'), "stickWood"));
        if (MekanismConfig.recipes.enableGaugeDropper) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(MekanismItems.GaugeDropper.getEmptyItem(), " O ", "G G", "GGG", Character.valueOf('O'), "ingot" + mekanismMaterial, Character.valueOf('G'), "paneGlass"));
        }
        if (MekanismConfig.recipes.enableTierInstaller) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(new ItemStack(MekanismItems.TierInstaller, 1, 1), "ECE", "oWo", "ECE", Character.valueOf('E'), "alloyAdvanced", Character.valueOf('C'), MekanismUtils.getControlCircuit(Tier.BaseTier.ADVANCED), Character.valueOf('o'), "ingot" + mekanismMaterial, Character.valueOf('W'), "plankWood"));
        }
        if (MekanismConfig.recipes.enableEnergyCubes) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(MekanismUtils.getEnergyCube(Tier.EnergyCubeTier.ADVANCED), "ETE", "oBo", "ETE", Character.valueOf('E'), "alloyAdvanced", Character.valueOf('o'), "ingot" + mekanismMaterial, Character.valueOf('T'), MekanismItems.EnergyTablet.getUnchargedItem(), Character.valueOf('B'), MekanismUtils.getEnergyCube(Tier.EnergyCubeTier.BASIC)));
        }
        if (MekanismConfig.recipes.enableGasTanks) {
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(MekanismUtils.getEmptyGasTank(Tier.GasTankTier.BASIC), "APA", "P P", "APA", Character.valueOf('P'), "ingot" + mekanismMaterial, Character.valueOf('A'), "alloyBasic"));
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(MekanismUtils.getEmptyGasTank(Tier.GasTankTier.ADVANCED), "APA", "PTP", "APA", Character.valueOf('P'), "ingot" + mekanismMaterial, Character.valueOf('A'), "alloyAdvanced", Character.valueOf('T'), MekanismUtils.getEmptyGasTank(Tier.GasTankTier.BASIC)));
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(MekanismUtils.getEmptyGasTank(Tier.GasTankTier.ELITE), "APA", "PTP", "APA", Character.valueOf('P'), "ingot" + mekanismMaterial, Character.valueOf('A'), "alloyElite", Character.valueOf('T'), MekanismUtils.getEmptyGasTank(Tier.GasTankTier.ADVANCED)));
            CraftingManager.func_77594_a().func_77592_b().add(new ShapedMekanismRecipe(MekanismUtils.getEmptyGasTank(Tier.GasTankTier.ULTIMATE), "APA", "PTP", "APA", Character.valueOf('P'), "ingot" + mekanismMaterial, Character.valueOf('A'), "alloyUltimate", Character.valueOf('T'), MekanismUtils.getEmptyGasTank(Tier.GasTankTier.ELITE)));
        }
        if (MekanismConfig.mekce.enableSiliconCompat && (Loader.isModLoaded((String)"EnderIO") || Loader.isModLoaded((String)"GalacticraftCore") || Loader.isModLoaded((String)"ProjRed|Core"))) {
            List<String> siliconCompat = Arrays.asList("itemSilicon", "silicon");
            Iterator ore = siliconCompat.iterator();
            while (ore.hasNext()) {
                String s = (String)ore.next();
                for (ItemStack ore2 : OreDictionary.getOres((String)s)) {
                    RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("REDSTONE"), 10, StackUtils.size(ore2, 1), new ItemStack(MekanismItems.ControlCircuit, 1, 0));
                }
            }
        } else {
            for (ItemStack ore : OreDictionary.getOres((String)("ingot" + mekanismMaterial))) {
                RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("REDSTONE"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.ControlCircuit, 1, 0));
            }
        }
        List<String> minorCompat = Arrays.asList("Nickel", "Aluminum");
        for (String s : minorCompat) {
            for (ItemStack ore2 : OreDictionary.getOres((String)("ore" + s))) {
                try {
                    RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore2, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)("dust" + s)).get(0), 2));
                }
                catch (Exception exception) {}
            }
            for (ItemStack ore2 : OreDictionary.getOres((String)("ingot" + s))) {
                try {
                    RecipeHandler.addCrusherRecipe(StackUtils.size(ore2, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)("dust" + s)).get(0), 1));
                }
                catch (Exception exception) {}
            }
            for (ItemStack ore2 : OreDictionary.getOres((String)("dust" + s))) {
                try {
                    RecipeHandler.addCombinerRecipe(StackUtils.size(ore2, 8), StackUtils.size((ItemStack)OreDictionary.getOres((String)("ore" + s)).get(0), 1));
                }
                catch (Exception exception) {}
            }
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreYellorite")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustYellorium").get(0), 2));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreCertusQuartz")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0), 4));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"crystalCertusQuartz")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCertusQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustCertusQuartz")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"crystalCertusQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"gemQuartz")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustNetherQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustNetherQuartz")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"gemQuartz").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"oreQuartz")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151128_bU, 6));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"crystalFluix")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustFluix").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustFluix")) {
            try {
                RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"crystalFluix").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotCopper")) {
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("TIN"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.Ingot, 1, 2));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotRefinedObsidian")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 6));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotRedstone")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151137_ax));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotRefinedGlowstone")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151114_aO));
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(MekanismItems.Ingot, 1, 2), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustBronze").get(0), 1));
            if (Mekanism.hooks.IC2Loaded) {
                OreDictManager.addIC2BronzeRecipe();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.SILVER.ordinal()), StackUtils.size((ItemStack)OreDictionary.getOres((String)"ingotSilver").get(0), 1), 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FurnaceRecipes.func_77602_a().func_151394_a(new ItemStack(MekanismItems.Dust, 1, Resource.LEAD.ordinal()), StackUtils.size((ItemStack)OreDictionary.getOres((String)"ingotLead").get(0), 1), 0.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCoal").get(0), 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151044_h, 1, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustCharcoal").get(0), 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151016_H), StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustSaltpeter").get(0), 1));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (ItemStack ore : OreDictionary.getOres((String)"sand")) {
            try {
                RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), StackUtils.size((ItemStack)OreDictionary.getOres((String)"itemSilicon").get(0), 1));
            }
            catch (Exception exception) {}
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustSaltpeter")) {
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151016_H));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"ingotSteel")) {
            RecipeHandler.addCrusherRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 1));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustLapis")) {
            RecipeHandler.addCrusherRecipe(new ItemStack(Items.field_151100_aR, 1, 4), StackUtils.size(ore, 1));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustLithium")) {
            RecipeHandler.addChemicalOxidizerRecipe(StackUtils.size(ore, 1), new GasStack(GasRegistry.getGas("lithium"), 100));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustObsidian")) {
            RecipeHandler.addCombinerRecipe(StackUtils.size(ore, 4), new ItemStack(Blocks.field_150343_Z));
            RecipeHandler.addMetallurgicInfuserRecipe(InfuseRegistry.get("DIAMOND"), 10, StackUtils.size(ore, 1), new ItemStack(MekanismItems.OtherDust, 1, 5));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustDiamond")) {
            InfuseRegistry.registerInfuseObject(ore, new InfuseObject(InfuseRegistry.get("DIAMOND"), 10));
            RecipeHandler.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151045_i));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustTin")) {
            InfuseRegistry.registerInfuseObject(ore, new InfuseObject(InfuseRegistry.get("TIN"), 50));
        }
        for (ItemStack ore : OreDictionary.getOres((String)"dustLead")) {
            InfuseRegistry.registerInfuseObject(ore, new InfuseObject(InfuseRegistry.get("LEAD"), 50));
        }
        try {
            for (ItemStack ore : OreDictionary.getOres((String)"treeSapling")) {
                if (ore.func_77960_j() != 0 && ore.func_77960_j() != Short.MAX_VALUE) continue;
                RecipeHandler.addCrusherRecipe(new ItemStack(ore.func_77973_b(), 1, Short.MAX_VALUE), new ItemStack(MekanismItems.BioFuel, 1));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="IC2")
    public static void addIC2BronzeRecipe() {
        try {
            Recipes.macerator.addRecipe((IRecipeInput)new RecipeInputOreDict("ingotBronze"), null, new ItemStack[]{StackUtils.size((ItemStack)OreDictionary.getOres((String)"dustBronze").get(0), 1)});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addLogRecipes() {
        Container tempContainer = new Container(){

            public boolean func_75145_c(EntityPlayer player) {
                return false;
            }
        };
        InventoryCrafting tempCrafting = new InventoryCrafting(tempContainer, 3, 3);
        ArrayList recipeList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
        for (int i = 1; i < 9; ++i) {
            tempCrafting.func_70299_a(i, null);
        }
        ArrayList registeredOres = OreDictionary.getOres((String)"logWood");
        for (int i = 0; i < registeredOres.size(); ++i) {
            ItemStack logEntry = (ItemStack)registeredOres.get(i);
            if (logEntry.func_77960_j() == Short.MAX_VALUE) {
                for (int j = 0; j < 16; ++j) {
                    ItemStack log = new ItemStack(logEntry.func_77973_b(), 1, j);
                    tempCrafting.func_70299_a(0, log);
                    ItemStack resultEntry = MekanismUtils.findMatchingRecipe(tempCrafting, null);
                    if (resultEntry == null) continue;
                    RecipeHandler.addPrecisionSawmillRecipe(log, StackUtils.size(resultEntry, 6), new ItemStack(MekanismItems.Sawdust), 1.0);
                }
                continue;
            }
            ItemStack log = StackUtils.size(logEntry, 1);
            tempCrafting.func_70299_a(0, log);
            ItemStack resultEntry = MekanismUtils.findMatchingRecipe(tempCrafting, null);
            if (resultEntry == null) continue;
            RecipeHandler.addPrecisionSawmillRecipe(log, StackUtils.size(resultEntry, 6), new ItemStack(MekanismItems.Sawdust), 1.0);
        }
    }

    public static void terralizationcompat() {
        if (MekanismConfig.mekce.EnableQuartzCompat) {
            for (ItemStack ore : OreDictionary.getOres((String)"dustQuartz")) {
                RecipeHelper.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151128_bU));
            }
            for (ItemStack ore : OreDictionary.getOres((String)"dustNetherQuartz")) {
                RecipeHelper.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(Items.field_151128_bU));
            }
            for (ItemStack ore : OreDictionary.getOres((String)"dustQuartz")) {
                RecipeHelper.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150449_bY), StackUtils.size(ore, 2));
            }
            for (ItemStack ore : OreDictionary.getOres((String)"dustNetherQuartz")) {
                RecipeHelper.addEnrichmentChamberRecipe(new ItemStack(Blocks.field_150449_bY), StackUtils.size(ore, 2));
            }
        }
        if (MekanismConfig.mekce.EnableDiamondCompat) {
            for (ItemStack ore : OreDictionary.getOres((String)"gemDiamond")) {
                InfuseRegistry.registerInfuseObject(ore, new InfuseObject(InfuseRegistry.get("DIAMOND"), 10));
                RecipeHelper.addEnrichmentChamberRecipe(StackUtils.size(ore, 1), new ItemStack(MekanismItems.CompressedDiamond));
            }
        }
        if (MekanismConfig.mekce.EnablePoorOresCompat) {
            for (ItemStack ore : OreDictionary.getOres((String)"orePoorIron")) {
                for (ItemStack ore2 : OreDictionary.getOres((String)"clumpIron")) {
                    RecipeHelper.addPurificationChamberRecipe(ore, ore2);
                }
            }
            for (ItemStack ore : OreDictionary.getOres((String)"orePoorGold")) {
                for (ItemStack ore2 : OreDictionary.getOres((String)"clumpGold")) {
                    RecipeHelper.addPurificationChamberRecipe(ore, ore2);
                }
            }
            for (ItemStack ore : OreDictionary.getOres((String)"orePoorCopper")) {
                for (ItemStack ore2 : OreDictionary.getOres((String)"clumpCopper")) {
                    RecipeHelper.addPurificationChamberRecipe(ore, ore2);
                }
            }
            for (ItemStack ore : OreDictionary.getOres((String)"orePoorTin")) {
                for (ItemStack ore2 : OreDictionary.getOres((String)"clumpTin")) {
                    RecipeHelper.addPurificationChamberRecipe(ore, ore2);
                }
            }
            for (ItemStack ore : OreDictionary.getOres((String)"orePoorLead")) {
                for (ItemStack ore2 : OreDictionary.getOres((String)"clumpLead")) {
                    RecipeHelper.addPurificationChamberRecipe(ore, ore2);
                }
            }
        }
    }
}

