/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import com.dynious.refinedrelocation.tileentity.TileBuffer;
import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.util.StackUtils;
import mekanism.common.Mekanism;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.content.transporter.TransporterStack;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.util.InventoryUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;

public class TransporterManager {
    public static Map<Coord4D, Set<TransporterStack>> flowingStacks = new HashMap<Coord4D, Set<TransporterStack>>();

    public static void reset() {
        flowingStacks.clear();
    }

    public static void add(TransporterStack stack) {
        HashSet<TransporterStack> set = new HashSet<TransporterStack>();
        set.add(stack);
        if (flowingStacks.get(stack.getDest()) == null) {
            flowingStacks.put(stack.getDest(), set);
        } else {
            flowingStacks.get(stack.getDest()).addAll(set);
        }
    }

    public static void remove(TransporterStack stack) {
        if (stack.hasPath() && stack.pathType != TransporterStack.Path.NONE) {
            flowingStacks.get(stack.getDest()).remove(stack);
        }
    }

    public static List<TransporterStack> getStacksToDest(Coord4D dest) {
        ArrayList<TransporterStack> ret = new ArrayList<TransporterStack>();
        if (flowingStacks.containsKey(dest)) {
            for (TransporterStack stack : flowingStacks.get(dest)) {
                if (stack == null || stack.pathType == TransporterStack.Path.NONE || !stack.hasPath() || !stack.getDest().equals(dest)) continue;
                ret.add(stack);
            }
        }
        return ret;
    }

    public static InventoryCopy copyInvFromSide(IInventory inv, int side) {
        inv = InventoryUtils.checkChestInv(inv);
        ItemStack[] ret = new ItemStack[inv.func_70302_i_()];
        if (!(inv instanceof ISidedInventory)) {
            for (int i = 0; i <= inv.func_70302_i_() - 1; ++i) {
                ret[i] = inv.func_70301_a(i) != null ? inv.func_70301_a(i).func_77946_l() : null;
            }
        } else {
            ISidedInventory sidedInventory = (ISidedInventory)inv;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.getOrientation((int)side).getOpposite().ordinal());
            if (slots == null || slots.length == 0) {
                return null;
            }
            if (Mekanism.hooks.RRLoaded && inv instanceof TileBuffer) {
                return null;
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                int slotID = slots[get];
                ret[slotID] = sidedInventory.func_70301_a(slotID) != null ? sidedInventory.func_70301_a(slotID).func_77946_l() : null;
            }
            if (inv instanceof TileEntityBin) {
                return new InventoryCopy(ret, ((TileEntityBin)inv).getItemCount());
            }
            return new InventoryCopy(ret);
        }
        return new InventoryCopy(ret);
    }

    public static void testInsert(IInventory inv, InventoryCopy copy, int side, TransporterStack stack) {
        block15: {
            ItemStack toInsert;
            block14: {
                toInsert = stack.itemStack.func_77946_l();
                if (stack.pathType != TransporterStack.Path.HOME && inv instanceof ISideConfiguration) {
                    ISideConfiguration config = (ISideConfiguration)inv;
                    int tileSide = config.getOrientation();
                    EnumColor configColor = config.getEjector().getInputColor(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(side, tileSide)).getOpposite());
                    if (config.getEjector().hasStrictInput() && configColor != null && configColor != stack.color) {
                        return;
                    }
                }
                if (Loader.isModLoaded((String)"MinefactoryReloaded") && inv instanceof IDeepStorageUnit && !(inv instanceof TileEntityBin)) {
                    return;
                }
                if (inv instanceof ISidedInventory) break block14;
                for (int i = 0; i <= inv.func_70302_i_() - 1; ++i) {
                    ItemStack toSet;
                    if (stack.pathType != TransporterStack.Path.HOME && !inv.func_94041_b(i, toInsert)) continue;
                    ItemStack inSlot = copy.inventory[i];
                    if (inSlot == null) {
                        if (toInsert.field_77994_a <= inv.func_70297_j_()) {
                            copy.inventory[i] = toInsert;
                            return;
                        }
                        int rejects = toInsert.field_77994_a - inv.func_70297_j_();
                        toSet = toInsert.func_77946_l();
                        toSet.field_77994_a = inv.func_70297_j_();
                        ItemStack remains = toInsert.func_77946_l();
                        remains.field_77994_a = rejects;
                        copy.inventory[i] = toSet;
                        toInsert = remains;
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), inv.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inv.func_70297_j_());
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                        toSet = toInsert.func_77946_l();
                        toSet.field_77994_a += inSlot.field_77994_a;
                        copy.inventory[i] = toSet;
                        return;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                    ItemStack toSet2 = toInsert.func_77946_l();
                    toSet2.field_77994_a = max;
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    copy.inventory[i] = toSet2;
                    toInsert = remains;
                }
                break block15;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inv;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.getOrientation((int)side).getOpposite().ordinal());
            if (slots == null || slots.length == 0) break block15;
            if (stack.pathType != TransporterStack.Path.HOME && sidedInventory instanceof TileEntityBin && ForgeDirection.getOrientation((int)side).getOpposite().ordinal() == 0) {
                slots = sidedInventory.func_94128_d(1);
            }
            if (inv instanceof TileEntityBin) {
                int slot = slots[0];
                if (!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_102007_a(slot, toInsert, ForgeDirection.getOrientation((int)side).getOpposite().ordinal())) {
                    return;
                }
                int amountRemaining = ((TileEntityBin)inv).getMaxStoredCount() - copy.binAmount;
                copy.binAmount += Math.min(amountRemaining, toInsert.field_77994_a);
                return;
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                ItemStack toSet;
                int slotID = slots[get];
                if (stack.pathType != TransporterStack.Path.HOME && (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_102007_a(slotID, toInsert, ForgeDirection.getOrientation((int)side).getOpposite().ordinal()))) continue;
                ItemStack inSlot = copy.inventory[slotID];
                if (inSlot == null) {
                    if (toInsert.field_77994_a <= inv.func_70297_j_()) {
                        copy.inventory[slotID] = toInsert;
                        return;
                    }
                    int rejects = toInsert.field_77994_a - inv.func_70297_j_();
                    toSet = toInsert.func_77946_l();
                    toSet.field_77994_a = inv.func_70297_j_();
                    ItemStack remains = toInsert.func_77946_l();
                    remains.field_77994_a = rejects;
                    copy.inventory[slotID] = toSet;
                    toInsert = remains;
                    continue;
                }
                if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), inv.func_70297_j_())) continue;
                int max = Math.min(inSlot.func_77976_d(), inv.func_70297_j_());
                if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                    toSet = toInsert.func_77946_l();
                    toSet.field_77994_a += inSlot.field_77994_a;
                    copy.inventory[slotID] = toSet;
                    return;
                }
                int rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                ItemStack toSet3 = toInsert.func_77946_l();
                toSet3.field_77994_a = max;
                ItemStack remains = toInsert.func_77946_l();
                remains.field_77994_a = rejects;
                copy.inventory[slotID] = toSet3;
                toInsert = remains;
            }
        }
    }

    public static boolean didEmit(ItemStack stack, ItemStack returned) {
        return returned == null || returned.field_77994_a < stack.field_77994_a;
    }

    public static ItemStack getToUse(ItemStack stack, ItemStack returned) {
        if (returned == null || returned.field_77994_a == 0) {
            return stack;
        }
        return MekanismUtils.size(stack, stack.field_77994_a - returned.field_77994_a);
    }

    public static ItemStack getPredictedInsert(TileEntity tileEntity, EnumColor color, ItemStack itemStack, int side) {
        ItemStack toInsert;
        block19: {
            IInventory inventory;
            InventoryCopy copy;
            block18: {
                if (!(tileEntity instanceof IInventory)) {
                    return itemStack;
                }
                if (tileEntity instanceof ISideConfiguration) {
                    ISideConfiguration config = (ISideConfiguration)tileEntity;
                    int tileSide = config.getOrientation();
                    EnumColor configColor = config.getEjector().getInputColor(ForgeDirection.getOrientation((int)MekanismUtils.getBaseOrientation(side, tileSide)).getOpposite());
                    if (config.getEjector().hasStrictInput() && configColor != null && configColor != color) {
                        return itemStack;
                    }
                }
                if ((copy = TransporterManager.copyInvFromSide(inventory = (IInventory)tileEntity, side)) == null) {
                    return itemStack;
                }
                List<TransporterStack> insertQueue = TransporterManager.getStacksToDest(Coord4D.get(tileEntity));
                for (TransporterStack tStack : insertQueue) {
                    TransporterManager.testInsert(inventory, copy, side, tStack);
                }
                toInsert = itemStack.func_77946_l();
                if (inventory instanceof ISidedInventory) break block18;
                inventory = InventoryUtils.checkChestInv(inventory);
                for (int i = 0; i <= inventory.func_70302_i_() - 1; ++i) {
                    if (!inventory.func_94041_b(i, toInsert)) continue;
                    ItemStack inSlot = copy.inventory[i];
                    if (toInsert == null) {
                        return null;
                    }
                    if (inSlot == null) {
                        if (toInsert.field_77994_a <= inventory.func_70297_j_()) {
                            return null;
                        }
                        int rejects = toInsert.field_77994_a - inventory.func_70297_j_();
                        if (rejects >= toInsert.field_77994_a) continue;
                        toInsert = StackUtils.size(toInsert, rejects);
                        continue;
                    }
                    if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), inventory.func_70297_j_())) continue;
                    int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
                    if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                        return null;
                    }
                    int rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                    if (rejects >= toInsert.field_77994_a) continue;
                    toInsert = StackUtils.size(toInsert, rejects);
                }
                break block19;
            }
            ISidedInventory sidedInventory = (ISidedInventory)inventory;
            int[] slots = sidedInventory.func_94128_d(ForgeDirection.getOrientation((int)side).getOpposite().ordinal());
            if (slots == null || slots.length == 0) break block19;
            if (inventory instanceof TileEntityBin) {
                int slot = slots[0];
                if (!sidedInventory.func_94041_b(slot, toInsert) || !sidedInventory.func_102007_a(slot, toInsert, ForgeDirection.getOrientation((int)side).getOpposite().ordinal())) {
                    return toInsert;
                }
                int amountRemaining = ((TileEntityBin)inventory).getMaxStoredCount() - copy.binAmount;
                if (toInsert.field_77994_a <= amountRemaining) {
                    return null;
                }
                return StackUtils.size(toInsert, toInsert.field_77994_a - amountRemaining);
            }
            for (int get = 0; get <= slots.length - 1; ++get) {
                int slotID = slots[get];
                if (!sidedInventory.func_94041_b(slotID, toInsert) || !sidedInventory.func_102007_a(slotID, toInsert, ForgeDirection.getOrientation((int)side).getOpposite().ordinal())) continue;
                ItemStack inSlot = copy.inventory[slotID];
                if (toInsert == null) {
                    return null;
                }
                if (inSlot == null) {
                    if (toInsert.field_77994_a <= inventory.func_70297_j_()) {
                        return null;
                    }
                    int rejects = toInsert.field_77994_a - inventory.func_70297_j_();
                    if (rejects >= toInsert.field_77994_a) continue;
                    toInsert = StackUtils.size(toInsert, rejects);
                    continue;
                }
                if (!InventoryUtils.areItemsStackable(toInsert, inSlot) || inSlot.field_77994_a >= Math.min(inSlot.func_77976_d(), inventory.func_70297_j_())) continue;
                int max = Math.min(inSlot.func_77976_d(), inventory.func_70297_j_());
                if (inSlot.field_77994_a + toInsert.field_77994_a <= max) {
                    return null;
                }
                int rejects = inSlot.field_77994_a + toInsert.field_77994_a - max;
                if (rejects >= toInsert.field_77994_a) continue;
                toInsert = StackUtils.size(toInsert, rejects);
            }
        }
        return toInsert;
    }

    public static class InventoryCopy {
        public ItemStack[] inventory;
        public int binAmount;

        public InventoryCopy(ItemStack[] inv) {
            this.inventory = inv;
        }

        public InventoryCopy(ItemStack[] inv, int amount) {
            this(inv);
            this.binAmount = amount;
        }
    }
}

