/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block;

import buildcraft.api.tools.IToolWrench;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import mekanism.api.Coord4D;
import mekanism.api.MekanismConfig;
import mekanism.api.energy.IEnergizedItem;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.CTMData;
import mekanism.common.CommonProxy;
import mekanism.common.Mekanism;
import mekanism.common.MekanismBlocks;
import mekanism.common.Tier;
import mekanism.common.base.IActiveState;
import mekanism.common.base.IBlockCTM;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.base.IFactory;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.base.ISpecialBounds;
import mekanism.common.base.ISustainedData;
import mekanism.common.base.ISustainedInventory;
import mekanism.common.base.ISustainedTank;
import mekanism.common.base.ITierItem;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.recipe.ShapedMekanismRecipe;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntityAdvancedFactory;
import mekanism.common.tile.TileEntityAmbientAccumulator;
import mekanism.common.tile.TileEntityBasicBlock;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityChemicalCrystallizer;
import mekanism.common.tile.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.TileEntityChemicalInfuser;
import mekanism.common.tile.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.TileEntityChemicalOxidizer;
import mekanism.common.tile.TileEntityChemicalWasher;
import mekanism.common.tile.TileEntityCombiner;
import mekanism.common.tile.TileEntityContainerBlock;
import mekanism.common.tile.TileEntityCrusher;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.tile.TileEntityElectricPump;
import mekanism.common.tile.TileEntityElectrolyticSeparator;
import mekanism.common.tile.TileEntityEliteFactory;
import mekanism.common.tile.TileEntityEnergizedSmelter;
import mekanism.common.tile.TileEntityEnrichmentChamber;
import mekanism.common.tile.TileEntityFactory;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFluidicPlenisher;
import mekanism.common.tile.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityLaser;
import mekanism.common.tile.TileEntityLaserAmplifier;
import mekanism.common.tile.TileEntityLaserTractorBeam;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityMetallurgicInfuser;
import mekanism.common.tile.TileEntityOredictionificator;
import mekanism.common.tile.TileEntityOsmiumCompressor;
import mekanism.common.tile.TileEntityPRC;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPrecisionSawmill;
import mekanism.common.tile.TileEntityPurificationChamber;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntityRotaryCondensentrator;
import mekanism.common.tile.TileEntitySeismicVibrator;
import mekanism.common.tile.TileEntitySolarNeutronActivator;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.PipeUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockMachine
extends BlockContainer
implements ISpecialBounds,
IBlockCTM,
MekanismRenderer.ICustomBlockIcon {
    public IIcon[][] icons = new IIcon[16][16];
    public IIcon[][][] factoryIcons = new IIcon[4][16][16];
    public CTMData[][] ctms = new CTMData[16][4];
    public IIcon BASE_ICON;
    public MachineBlock blockType;

    public BlockMachine(MachineBlock type) {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149752_b(16.0f);
        this.func_149647_a(Mekanism.tabMekanism);
        this.blockType = type;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.BASE_ICON = register.func_94245_a("mekanism:SteelCasing");
        MekanismRenderer.DefIcon def = MekanismRenderer.DefIcon.getAll(this.BASE_ICON).setOverrides(false);
        switch (this.blockType) {
            case MACHINE_BLOCK_1: {
                this.ctms[11][0] = new CTMData("ctm/Teleporter", (Block)this, Arrays.asList(11)).addOtherBlockConnectivities(MekanismBlocks.BasicBlock, Arrays.asList(7)).registerIcons(register);
                MekanismRenderer.loadDynamicTextures(register, "enrichment_chamber/" + MachineType.ENRICHMENT_CHAMBER.name, this.icons[0], def);
                MekanismRenderer.loadDynamicTextures(register, "osmium_compressor/" + MachineType.OSMIUM_COMPRESSOR.name, this.icons[1], def);
                MekanismRenderer.loadDynamicTextures(register, "combiner/" + MachineType.COMBINER.name, this.icons[2], def);
                MekanismRenderer.loadDynamicTextures(register, "crusher/" + MachineType.CRUSHER.name, this.icons[3], def);
                for (IFactory.RecipeType type : IFactory.RecipeType.values()) {
                    MekanismRenderer.loadDynamicTextures(register, "factory/basic/" + type.getUnlocalizedName().toLowerCase() + "/" + Tier.BaseTier.BASIC.getName() + type.getUnlocalizedName() + MachineType.BASIC_FACTORY.name, this.factoryIcons[0][type.ordinal()], MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/basic/BasicFactoryFront"), 2).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/basic/BasicFactoryTop"), 1).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/basic/BasicFactoryBottom"), 0).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/basic/BasicFactorySide"), 3, 4, 5).setOverrides(false));
                    MekanismRenderer.loadDynamicTextures(register, "factory/advanced/" + type.getUnlocalizedName().toLowerCase() + "/" + Tier.BaseTier.ADVANCED.getName() + type.getUnlocalizedName() + MachineType.ADVANCED_FACTORY.name, this.factoryIcons[1][type.ordinal()], MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/advanced/AdvancedFactoryFront"), 2).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/advanced/AdvancedFactoryTop"), 1).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/advanced/AdvancedFactoryBottom"), 0).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/advanced/AdvancedFactorySide"), 3, 4, 5).setOverrides(false));
                    MekanismRenderer.loadDynamicTextures(register, "factory/elite/" + type.getUnlocalizedName().toLowerCase() + "/" + Tier.BaseTier.ELITE.getName() + type.getUnlocalizedName() + MachineType.ELITE_FACTORY.name, this.factoryIcons[2][type.ordinal()], MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/elite/EliteFactoryFront"), 2).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/elite/EliteFactoryTop"), 1).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/elite/EliteFactoryBottom"), 0).setOverrides(false), MekanismRenderer.DefIcon.getActivePair(register.func_94245_a("mekanism:factory/elite/EliteFactorySide"), 3, 4, 5).setOverrides(false));
                }
                MekanismRenderer.loadDynamicTextures(register, "purification_chamber/" + MachineType.PURIFICATION_CHAMBER.name, this.icons[9], def);
                MekanismRenderer.loadDynamicTextures(register, "energized_smelter/" + MachineType.ENERGIZED_SMELTER.name, this.icons[10], def);
                this.icons[11][0] = this.ctms[11][0].mainTextureData.icon;
                break;
            }
            case MACHINE_BLOCK_2: {
                MekanismRenderer.loadDynamicTextures(register, "chemical_injection_chamber/" + MachineType.CHEMICAL_INJECTION_CHAMBER.name, this.icons[3], def);
                MekanismRenderer.loadDynamicTextures(register, "precision_sawmill/" + MachineType.PRECISION_SAWMILL.name, this.icons[5], def);
                break;
            }
            case MACHINE_BLOCK_3: {
                this.icons[0][0] = this.BASE_ICON;
                this.icons[2][0] = this.BASE_ICON;
                MekanismRenderer.loadDynamicTextures(register, "oredictionificator/" + MachineType.OREDICTIONIFICATOR.name, this.icons[3], new MekanismRenderer.DefIcon[0]);
                this.icons[4][0] = this.BASE_ICON;
                MekanismRenderer.loadDynamicTextures(register, "formulaic_assemblicator/" + MachineType.FORMULAIC_ASSEMBLICATOR.name, this.icons[5], new MekanismRenderer.DefIcon[0]);
                MekanismRenderer.loadDynamicTextures(register, "fuelwood_heater/" + MachineType.FUELWOOD_HEATER.name, this.icons[6], new MekanismRenderer.DefIcon[0]);
            }
        }
    }

    @Override
    public IIcon getIcon(ItemStack stack, int side) {
        MachineType type = MachineType.get(stack);
        ItemBlockMachine item = (ItemBlockMachine)stack.func_77973_b();
        if (type == MachineType.BASIC_FACTORY) {
            return this.factoryIcons[0][item.getRecipeType(stack)][side];
        }
        if (type == MachineType.ADVANCED_FACTORY) {
            return this.factoryIcons[1][item.getRecipeType(stack)][side];
        }
        if (type == MachineType.ELITE_FACTORY) {
            return this.factoryIcons[2][item.getRecipeType(stack)][side];
        }
        return this.func_149691_a(side, stack.func_77960_j());
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack itemstack) {
        TileEntityLogisticalSorter transporter;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int side = MathHelper.func_76128_c((double)((double)(entityliving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        int height = Math.round(entityliving.field_70125_A);
        int change = 3;
        if (tileEntity == null) {
            return;
        }
        if (tileEntity.canSetFacing(0) && tileEntity.canSetFacing(1)) {
            if (height >= 65) {
                change = 1;
            } else if (height <= -65) {
                change = 0;
            }
        }
        if (change != 0 && change != 1) {
            switch (side) {
                case 0: {
                    change = 2;
                    break;
                }
                case 1: {
                    change = 5;
                    break;
                }
                case 2: {
                    change = 3;
                    break;
                }
                case 3: {
                    change = 4;
                }
            }
        }
        if (tileEntity instanceof TileEntityLogisticalSorter && !(transporter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                TileEntity tile = Coord4D.get(transporter).getFromSide(dir).getTileEntity((IBlockAccess)world);
                if (!(tile instanceof IInventory)) continue;
                change = dir.getOpposite().ordinal();
                break;
            }
        }
        tileEntity.setFacing((short)change);
        tileEntity.redstone = world.func_72864_z(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onPlace();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (tileEntity instanceof IBoundingBlock) {
            ((IBoundingBlock)((Object)tileEntity)).onBreak();
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        if (MekanismUtils.isActive((IBlockAccess)world, x, y, z) && ((IActiveState)((Object)tileEntity)).renderUpdate() && MekanismConfig.client.machineEffects) {
            float xRandom = (float)x + 0.5f;
            float yRandom = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float zRandom = (float)z + 0.5f;
            float iRandom = 0.52f;
            float jRandom = random.nextFloat() * 0.6f - 0.3f;
            int side = tileEntity.facing;
            if (tileEntity instanceof TileEntityMetallurgicInfuser) {
                side = ForgeDirection.getOrientation((int)side).getOpposite().ordinal();
            }
            if (side == 4) {
                world.func_72869_a("smoke", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom - iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (side == 5) {
                world.func_72869_a("smoke", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + iRandom), (double)yRandom, (double)(zRandom + jRandom), 0.0, 0.0, 0.0);
            } else if (side == 2) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom - iRandom), 0.0, 0.0, 0.0);
            } else if (side == 3) {
                world.func_72869_a("smoke", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
                world.func_72869_a("reddust", (double)(xRandom + jRandom), (double)yRandom, (double)(zRandom + iRandom), 0.0, 0.0, 0.0);
            }
        }
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity;
        if (MekanismConfig.client.enableAmbientLighting && (tileEntity = world.func_147438_o(x, y, z)) instanceof IActiveState && ((IActiveState)tileEntity).getActive() && ((IActiveState)tileEntity).lightUpdate()) {
            return MekanismConfig.client.ambientLightingLevel;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (this.blockType) {
            case MACHINE_BLOCK_1: {
                switch (meta) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        return this.icons[meta][side];
                    }
                }
                return this.icons[meta][0] != null ? this.icons[meta][0] : this.BASE_ICON;
            }
            case MACHINE_BLOCK_2: {
                switch (meta) {
                    case 3: 
                    case 5: {
                        return this.icons[meta][side];
                    }
                }
                return this.icons[meta][0] != null ? this.icons[meta][0] : this.BASE_ICON;
            }
            case MACHINE_BLOCK_3: {
                switch (meta) {
                    case 3: 
                    case 5: 
                    case 6: {
                        return this.icons[meta][side];
                    }
                }
                return this.icons[meta][0] != null ? this.icons[meta][0] : this.BASE_ICON;
            }
        }
        return this.BASE_ICON;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        switch (this.blockType) {
            case MACHINE_BLOCK_1: {
                switch (meta) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 9: 
                    case 10: {
                        boolean active = MekanismUtils.isActive(world, x, y, z);
                        return this.icons[meta][MekanismUtils.getBaseOrientation(side, tileEntity.facing) + (active ? 6 : 0)];
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        TileEntityFactory factory = (TileEntityFactory)tileEntity;
                        boolean active = MekanismUtils.isActive(world, x, y, z);
                        return this.factoryIcons[factory.tier.ordinal()][factory.recipeType.ordinal()][MekanismUtils.getBaseOrientation(side, tileEntity.facing) + (active ? 6 : 0)];
                    }
                }
                return this.icons[meta][0];
            }
            case MACHINE_BLOCK_2: {
                switch (meta) {
                    case 3: 
                    case 5: {
                        boolean active = MekanismUtils.isActive(world, x, y, z);
                        return this.icons[meta][MekanismUtils.getBaseOrientation(side, tileEntity.facing) + (active ? 6 : 0)];
                    }
                }
                return this.icons[meta][0];
            }
            case MACHINE_BLOCK_3: {
                switch (meta) {
                    case 3: 
                    case 5: 
                    case 6: {
                        boolean active = MekanismUtils.isActive(world, x, y, z);
                        return this.icons[meta][MekanismUtils.getBaseOrientation(side, tileEntity.facing) + (active ? 6 : 0)];
                    }
                }
                return this.icons[meta][0];
            }
        }
        return null;
    }

    public int func_149692_a(int i) {
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs creativetabs, List list) {
        block6: for (MachineType type : MachineType.getValidMachines()) {
            if (type.typeBlock != this.blockType || !type.isEnabled()) continue;
            switch (type) {
                case BASIC_FACTORY: 
                case ADVANCED_FACTORY: 
                case ELITE_FACTORY: {
                    for (IFactory.RecipeType recipe : IFactory.RecipeType.values()) {
                        ItemStack stack = new ItemStack(item, 1, type.meta);
                        ((IFactory)stack.func_77973_b()).setRecipeType(recipe.ordinal(), stack);
                        list.add(stack);
                    }
                    continue block6;
                }
                case FLUID_TANK: {
                    ItemBlockMachine itemMachine = (ItemBlockMachine)item;
                    for (Tier.FluidTankTier tier : Tier.FluidTankTier.values()) {
                        ItemStack stack = new ItemStack(item, 1, type.meta);
                        itemMachine.setBaseTier(stack, tier.getBaseTier());
                        list.add(stack);
                    }
                    if (!MekanismConfig.general.prefilledFluidTanks) continue block6;
                    for (Fluid f : FluidRegistry.getRegisteredFluids().values()) {
                        try {
                            ItemStack filled = new ItemStack(item, 1, type.meta);
                            itemMachine.setBaseTier(filled, Tier.BaseTier.ULTIMATE);
                            itemMachine.setFluidStack(new FluidStack(f, itemMachine.getCapacity(filled)), filled);
                            list.add(filled);
                        }
                        catch (Exception exception) {}
                    }
                    continue block6;
                }
                default: {
                    list.add(new ItemStack(item, 1, type.meta));
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityplayer, int side, float posX, float posY, float posZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        int metadata = world.func_72805_g(x, y, z);
        if (entityplayer.func_71045_bC() != null) {
            Item tool = entityplayer.func_71045_bC().func_77973_b();
            if (MekanismUtils.hasUsableWrench(entityplayer, x, y, z)) {
                if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                    if (entityplayer.func_70093_af()) {
                        this.dismantleBlock(world, x, y, z, false);
                        return true;
                    }
                    if (MekanismUtils.isBCWrench(tool)) {
                        ((IToolWrench)tool).wrenchUsed(entityplayer, x, y, z);
                    }
                    int change = ForgeDirection.ROTATION_MATRIX[ForgeDirection.UP.ordinal()][tileEntity.facing];
                    if (tileEntity instanceof TileEntityLogisticalSorter && !((TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                            TileEntity tile = Coord4D.get(tileEntity).getFromSide(dir).getTileEntity((IBlockAccess)world);
                            if (!(tile instanceof IInventory)) continue;
                            change = dir.getOpposite().ordinal();
                            break;
                        }
                    }
                    tileEntity.setFacing((short)change);
                    world.func_147459_d(x, y, z, (Block)this);
                } else {
                    SecurityUtils.displayNoAccess(entityplayer);
                }
                return true;
            }
        }
        if (tileEntity != null) {
            MachineType type = MachineType.get(this.blockType, metadata);
            switch (type) {
                case PERSONAL_CHEST: {
                    if (entityplayer.func_70093_af() || world.isSideSolid(x, y + 1, z, ForgeDirection.DOWN)) break;
                    TileEntityPersonalChest chest = (TileEntityPersonalChest)tileEntity;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        MekanismUtils.openPersonalChestGui((EntityPlayerMP)entityplayer, chest, null, true);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                case FLUID_TANK: {
                    if (entityplayer.func_70093_af()) break;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        if (entityplayer.func_71045_bC() != null && FluidContainerRegistry.isContainer((ItemStack)entityplayer.func_71045_bC())) {
                            if (this.manageInventory(entityplayer, (TileEntityFluidTank)tileEntity)) {
                                entityplayer.field_71071_by.func_70296_d();
                                return true;
                            }
                        } else {
                            entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, x, y, z);
                        }
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                case LOGISTICAL_SORTER: {
                    if (entityplayer.func_70093_af()) break;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        PacketLogisticalSorterGui.LogisticalSorterGuiMessage.openServerGui(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, 0, world, (EntityPlayerMP)entityplayer, Coord4D.get(tileEntity), -1);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                case TELEPORTER: 
                case QUANTUM_ENTANGLOPORTER: {
                    if (entityplayer.func_70093_af()) break;
                    String owner = ((ISecurityTile)((Object)tileEntity)).getSecurity().getOwner();
                    if (MekanismUtils.isOp((EntityPlayer)((EntityPlayerMP)entityplayer)) || owner == null || entityplayer.func_70005_c_().equals(owner)) {
                        entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, x, y, z);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
                default: {
                    if (entityplayer.func_70093_af() || type.guiId == -1) break;
                    if (SecurityUtils.canAccess(entityplayer, tileEntity)) {
                        entityplayer.openGui((Object)Mekanism.instance, type.guiId, world, x, y, z);
                    } else {
                        SecurityUtils.displayNoAccess(entityplayer);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (MachineType.get(this.blockType, metadata) == null) {
            return null;
        }
        return MachineType.get(this.blockType, metadata).create();
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public int func_149645_b() {
        return CommonProxy.CTM_RENDER_ID;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return SecurityUtils.canAccess(player, tile) ? super.func_149737_a(player, world, x, y, z) : 0.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        if (MachineType.get(this.blockType, world.func_72805_g(x, y, z)) != MachineType.PERSONAL_CHEST) {
            return this.field_149781_w;
        }
        return -1.0f;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (!player.field_71075_bZ.field_75098_d && !world.field_72995_K && willHarvest) {
            TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, this.getPickBlock(null, world, x, y, z, player));
            world.func_72838_d((Entity)entityItem);
        }
        return world.func_147468_f(x, y, z);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int par5) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityFluidTank) {
            return ((TileEntityFluidTank)tileEntity).getRedstoneLevel();
        }
        if (tileEntity instanceof TileEntityLaserAmplifier) {
            TileEntityLaserAmplifier amplifier = (TileEntityLaserAmplifier)tileEntity;
            if (amplifier.outputMode == TileEntityLaserAmplifier.RedstoneOutput.ENERGY_CONTENTS) {
                return amplifier.getRedstoneLevel();
            }
            return this.func_149709_b((IBlockAccess)world, x, y, z, par5);
        }
        return 0;
    }

    private boolean manageInventory(EntityPlayer player, TileEntityFluidTank tileEntity) {
        ItemStack itemStack = player.func_71045_bC();
        if (itemStack != null) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack)) {
                ItemStack filled;
                if (tileEntity.fluidTank.getFluid() != null && tileEntity.fluidTank.getFluid().amount >= 1000 && (filled = FluidContainerRegistry.fillFluidContainer((FluidStack)tileEntity.fluidTank.getFluid(), (ItemStack)itemStack)) != null) {
                    if (player.field_71075_bZ.field_75098_d) {
                        tileEntity.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                        return true;
                    }
                    if (itemStack.field_77994_a > 1) {
                        if (player.field_71071_by.func_70441_a(filled)) {
                            --itemStack.field_77994_a;
                            tileEntity.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                        }
                    } else if (itemStack.field_77994_a == 1) {
                        player.func_70062_b(0, filled);
                        tileEntity.fluidTank.drain(FluidContainerRegistry.getFluidForFilledItem((ItemStack)filled).amount, true);
                        return true;
                    }
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)itemStack)) {
                FluidStack itemFluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
                int needed = tileEntity.getCurrentNeeded();
                if (tileEntity.fluidTank.getFluid() == null && itemFluid.amount <= tileEntity.fluidTank.getCapacity() || itemFluid.amount <= needed) {
                    if (tileEntity.fluidTank.getFluid() != null && !tileEntity.fluidTank.getFluid().isFluidEqual(itemFluid)) {
                        return false;
                    }
                    boolean filled = false;
                    if (player.field_71075_bZ.field_75098_d) {
                        filled = true;
                    } else {
                        ItemStack containerItem = itemStack.func_77973_b().getContainerItem(itemStack);
                        if (containerItem != null) {
                            if (itemStack.field_77994_a == 1) {
                                player.func_70062_b(0, containerItem);
                                filled = true;
                            } else if (player.field_71071_by.func_70441_a(containerItem)) {
                                --itemStack.field_77994_a;
                                filled = true;
                            }
                        } else {
                            --itemStack.field_77994_a;
                            if (itemStack.field_77994_a == 0) {
                                player.func_70062_b(0, null);
                            }
                            filled = true;
                        }
                    }
                    if (filled) {
                        int toFill = Math.min(tileEntity.fluidTank.getCapacity() - tileEntity.fluidTank.getFluidAmount(), itemFluid.amount);
                        tileEntity.fluidTank.fill(itemFluid, true);
                        if (itemFluid.amount - toFill > 0) {
                            tileEntity.pushUp(PipeUtils.copy(itemFluid, itemFluid.amount - toFill), true);
                        }
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (!world.field_72995_K) {
            TileEntityLogisticalSorter sorter;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof TileEntityBasicBlock) {
                ((TileEntityBasicBlock)tileEntity).onNeighborChange(block);
            }
            if (tileEntity instanceof TileEntityLogisticalSorter && !(sorter = (TileEntityLogisticalSorter)tileEntity).hasInventory()) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = Coord4D.get(tileEntity).getFromSide(dir).getTileEntity((IBlockAccess)world);
                    if (!(tile instanceof IInventory)) continue;
                    sorter.setFacing((short)dir.getOpposite().ordinal());
                    return;
                }
            }
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ISecurityItem securityItem;
        TileEntityBasicBlock tileEntity = (TileEntityBasicBlock)world.func_147438_o(x, y, z);
        ItemStack itemStack = new ItemStack((Block)this, 1, world.func_72805_g(x, y, z));
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        if (tileEntity instanceof TileEntityFluidTank) {
            ITierItem tierItem = (ITierItem)itemStack.func_77973_b();
            tierItem.setBaseTier(itemStack, ((TileEntityFluidTank)tileEntity).tier.getBaseTier());
        }
        if (tileEntity instanceof ISecurityTile && (securityItem = (ISecurityItem)itemStack.func_77973_b()).hasSecurity(itemStack)) {
            securityItem.setOwner(itemStack, ((ISecurityTile)((Object)tileEntity)).getSecurity().getOwner());
            securityItem.setSecurity(itemStack, ((ISecurityTile)((Object)tileEntity)).getSecurity().getMode());
        }
        if (tileEntity instanceof IUpgradeTile) {
            ((IUpgradeTile)((Object)tileEntity)).getComponent().write(itemStack.field_77990_d);
        }
        if (tileEntity instanceof ISideConfiguration) {
            ISideConfiguration config = (ISideConfiguration)((Object)tileEntity);
            config.getConfig().write(itemStack.field_77990_d);
        }
        if (tileEntity instanceof ISustainedData) {
            ((ISustainedData)((Object)tileEntity)).writeSustainedData(itemStack);
        }
        if (tileEntity instanceof IRedstoneControl) {
            IRedstoneControl control = (IRedstoneControl)((Object)tileEntity);
            itemStack.field_77990_d.func_74768_a("controlType", control.getControlType().ordinal());
        }
        if (tileEntity instanceof IStrictEnergyStorage) {
            IEnergizedItem energizedItem = (IEnergizedItem)itemStack.func_77973_b();
            energizedItem.setEnergy(itemStack, ((IStrictEnergyStorage)((Object)tileEntity)).getEnergy());
        }
        if (tileEntity instanceof TileEntityContainerBlock && ((TileEntityContainerBlock)tileEntity).inventory.length > 0) {
            ISustainedInventory inventory = (ISustainedInventory)itemStack.func_77973_b();
            inventory.setInventory(((ISustainedInventory)((Object)tileEntity)).getInventory(new Object[0]), itemStack);
        }
        if (((ISustainedTank)itemStack.func_77973_b()).hasTank(itemStack) && tileEntity instanceof ISustainedTank && ((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]) != null) {
            ((ISustainedTank)itemStack.func_77973_b()).setFluidStack(((ISustainedTank)((Object)tileEntity)).getFluidStack(new Object[0]), itemStack);
        }
        if (tileEntity instanceof TileEntityFactory) {
            IFactory factoryItem = (IFactory)itemStack.func_77973_b();
            factoryItem.setRecipeType(((TileEntityFactory)tileEntity).recipeType.ordinal(), itemStack);
        }
        return itemStack;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && tileEntity instanceof TileEntityBasicBlock) {
            ((TileEntityBasicBlock)tileEntity).onAdded();
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        MachineType type = MachineType.get(this.blockType, world.func_72805_g(x, y, z));
        switch (type) {
            case LASER_AMPLIFIER: {
                return true;
            }
        }
        return false;
    }

    public ItemStack dismantleBlock(World world, int x, int y, int z, boolean returnBlock) {
        ItemStack itemStack = this.getPickBlock(null, world, x, y, z, null);
        world.func_147468_f(x, y, z);
        if (!returnBlock) {
            float motion = 0.7f;
            double motionX = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionY = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            double motionZ = (double)(world.field_73012_v.nextFloat() * motion) + (double)(1.0f - motion) * 0.5;
            EntityItem entityItem = new EntityItem(world, (double)x + motionX, (double)y + motionY, (double)z + motionZ, itemStack);
            world.func_72838_d((Entity)entityItem);
        }
        return itemStack;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        MachineType type = MachineType.get(this.blockType, world.func_72805_g(x, y, z));
        if (type == null) {
            return;
        }
        switch (type) {
            case CHARGEPAD: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.06f, 1.0f);
                break;
            }
            case FLUID_TANK: {
                this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
                break;
            }
            default: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        if (world.func_147438_o(x, y, z) instanceof TileEntityChargepad) {
            return null;
        }
        return super.func_149668_a(world, x, y, z);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        MachineType type = MachineType.get(this.blockType, world.func_72805_g(x, y, z));
        switch (type) {
            case PERSONAL_CHEST: 
            case CHARGEPAD: {
                return false;
            }
            case FLUID_TANK: {
                return side == ForgeDirection.UP || side == ForgeDirection.DOWN;
            }
        }
        return true;
    }

    @Override
    public void setRenderBounds(Block block, int metadata) {
    }

    @Override
    public boolean doDefaultBoundSetting(int metadata) {
        return false;
    }

    public ForgeDirection[] getValidRotations(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        ForgeDirection[] valid = new ForgeDirection[6];
        if (tile instanceof TileEntityBasicBlock) {
            TileEntityBasicBlock basicTile = (TileEntityBasicBlock)tile;
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (!basicTile.canSetFacing(dir.ordinal())) continue;
                valid[dir.ordinal()] = dir;
            }
        }
        return valid;
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityBasicBlock basicTile;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityBasicBlock && (basicTile = (TileEntityBasicBlock)tile).canSetFacing(axis.ordinal())) {
            basicTile.setFacing((short)axis.ordinal());
            return true;
        }
        return false;
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityLaserAmplifier) {
            return ((TileEntityLaserAmplifier)tile).emittingRedstone ? 15 : 0;
        }
        return 0;
    }

    @Override
    public CTMData getCTMData(IBlockAccess world, int x, int y, int z, int meta) {
        if (this.ctms[meta][1] != null && MekanismUtils.isActive(world, x, y, z)) {
            return this.ctms[meta][1];
        }
        return this.ctms[meta][0];
    }

    @Override
    public boolean shouldRenderBlock(IBlockAccess world, int x, int y, int z, int meta) {
        return !MachineType.get((Block)this, (int)meta).hasModel;
    }

    public static enum MachineType {
        ENRICHMENT_CHAMBER(MachineBlock.MACHINE_BLOCK_1, 0, "EnrichmentChamber", 3, TileEntityEnrichmentChamber.class, true, false, true),
        OSMIUM_COMPRESSOR(MachineBlock.MACHINE_BLOCK_1, 1, "OsmiumCompressor", 4, TileEntityOsmiumCompressor.class, true, false, true),
        COMBINER(MachineBlock.MACHINE_BLOCK_1, 2, "Combiner", 5, TileEntityCombiner.class, true, false, true),
        CRUSHER(MachineBlock.MACHINE_BLOCK_1, 3, "Crusher", 6, TileEntityCrusher.class, true, false, true),
        DIGITAL_MINER(MachineBlock.MACHINE_BLOCK_1, 4, "DigitalMiner", 2, TileEntityDigitalMiner.class, true, true, true),
        BASIC_FACTORY(MachineBlock.MACHINE_BLOCK_1, 5, "Factory", 11, TileEntityFactory.class, true, false, true),
        ADVANCED_FACTORY(MachineBlock.MACHINE_BLOCK_1, 6, "Factory", 11, TileEntityAdvancedFactory.class, true, false, true),
        ELITE_FACTORY(MachineBlock.MACHINE_BLOCK_1, 7, "Factory", 11, TileEntityEliteFactory.class, true, false, true),
        METALLURGIC_INFUSER(MachineBlock.MACHINE_BLOCK_1, 8, "MetallurgicInfuser", 12, TileEntityMetallurgicInfuser.class, true, true, true),
        PURIFICATION_CHAMBER(MachineBlock.MACHINE_BLOCK_1, 9, "PurificationChamber", 15, TileEntityPurificationChamber.class, true, false, true),
        ENERGIZED_SMELTER(MachineBlock.MACHINE_BLOCK_1, 10, "EnergizedSmelter", 16, TileEntityEnergizedSmelter.class, true, false, true),
        TELEPORTER(MachineBlock.MACHINE_BLOCK_1, 11, "Teleporter", 13, TileEntityTeleporter.class, true, false, false),
        ELECTRIC_PUMP(MachineBlock.MACHINE_BLOCK_1, 12, "ElectricPump", 17, TileEntityElectricPump.class, true, true, false),
        PERSONAL_CHEST(MachineBlock.MACHINE_BLOCK_1, 13, "PersonalChest", -1, TileEntityPersonalChest.class, false, true, false),
        CHARGEPAD(MachineBlock.MACHINE_BLOCK_1, 14, "Chargepad", -1, TileEntityChargepad.class, true, true, false),
        LOGISTICAL_SORTER(MachineBlock.MACHINE_BLOCK_1, 15, "LogisticalSorter", -1, TileEntityLogisticalSorter.class, false, true, false),
        ROTARY_CONDENSENTRATOR(MachineBlock.MACHINE_BLOCK_2, 0, "RotaryCondensentrator", 7, TileEntityRotaryCondensentrator.class, true, true, false),
        CHEMICAL_OXIDIZER(MachineBlock.MACHINE_BLOCK_2, 1, "ChemicalOxidizer", 29, TileEntityChemicalOxidizer.class, true, true, true),
        CHEMICAL_INFUSER(MachineBlock.MACHINE_BLOCK_2, 2, "ChemicalInfuser", 30, TileEntityChemicalInfuser.class, true, true, false),
        CHEMICAL_INJECTION_CHAMBER(MachineBlock.MACHINE_BLOCK_2, 3, "ChemicalInjectionChamber", 31, TileEntityChemicalInjectionChamber.class, true, false, true),
        ELECTROLYTIC_SEPARATOR(MachineBlock.MACHINE_BLOCK_2, 4, "ElectrolyticSeparator", 32, TileEntityElectrolyticSeparator.class, true, true, false),
        PRECISION_SAWMILL(MachineBlock.MACHINE_BLOCK_2, 5, "PrecisionSawmill", 34, TileEntityPrecisionSawmill.class, true, false, true),
        CHEMICAL_DISSOLUTION_CHAMBER(MachineBlock.MACHINE_BLOCK_2, 6, "ChemicalDissolutionChamber", 35, TileEntityChemicalDissolutionChamber.class, true, true, true),
        CHEMICAL_WASHER(MachineBlock.MACHINE_BLOCK_2, 7, "ChemicalWasher", 36, TileEntityChemicalWasher.class, true, true, false),
        CHEMICAL_CRYSTALLIZER(MachineBlock.MACHINE_BLOCK_2, 8, "ChemicalCrystallizer", 37, TileEntityChemicalCrystallizer.class, true, true, true),
        SEISMIC_VIBRATOR(MachineBlock.MACHINE_BLOCK_2, 9, "SeismicVibrator", 39, TileEntitySeismicVibrator.class, true, true, false),
        PRESSURIZED_REACTION_CHAMBER(MachineBlock.MACHINE_BLOCK_2, 10, "PressurizedReactionChamber", 40, TileEntityPRC.class, true, true, false),
        FLUID_TANK(MachineBlock.MACHINE_BLOCK_2, 11, "FluidTank", 41, TileEntityFluidTank.class, false, true, false),
        FLUIDIC_PLENISHER(MachineBlock.MACHINE_BLOCK_2, 12, "FluidicPlenisher", 42, TileEntityFluidicPlenisher.class, true, true, false),
        LASER(MachineBlock.MACHINE_BLOCK_2, 13, "Laser", -1, TileEntityLaser.class, true, true, false),
        LASER_AMPLIFIER(MachineBlock.MACHINE_BLOCK_2, 14, "LaserAmplifier", 44, TileEntityLaserAmplifier.class, false, true, false),
        LASER_TRACTOR_BEAM(MachineBlock.MACHINE_BLOCK_2, 15, "LaserTractorBeam", 45, TileEntityLaserTractorBeam.class, false, true, false),
        QUANTUM_ENTANGLOPORTER(MachineBlock.MACHINE_BLOCK_3, 0, "QuantumEntangloporter", 46, TileEntityQuantumEntangloporter.class, true, true, false),
        SOLAR_NEUTRON_ACTIVATOR(MachineBlock.MACHINE_BLOCK_3, 1, "SolarNeutronActivator", 47, TileEntitySolarNeutronActivator.class, false, true, false),
        AMBIENT_ACCUMULATOR(MachineBlock.MACHINE_BLOCK_3, 2, "AmbientAccumulator", 48, TileEntityAmbientAccumulator.class, true, false, false),
        OREDICTIONIFICATOR(MachineBlock.MACHINE_BLOCK_3, 3, "Oredictionificator", 52, TileEntityOredictionificator.class, false, false, false),
        RESISTIVE_HEATER(MachineBlock.MACHINE_BLOCK_3, 4, "ResistiveHeater", 53, TileEntityResistiveHeater.class, true, true, false),
        FORMULAIC_ASSEMBLICATOR(MachineBlock.MACHINE_BLOCK_3, 5, "FormulaicAssemblicator", 56, TileEntityFormulaicAssemblicator.class, true, false, true),
        FUELWOOD_HEATER(MachineBlock.MACHINE_BLOCK_3, 6, "FuelwoodHeater", 58, TileEntityFuelwoodHeater.class, false, false, false);

        public MachineBlock typeBlock;
        public int meta;
        public String name;
        public int guiId;
        public double baseEnergy;
        public Class<? extends TileEntity> tileEntityClass;
        public boolean isElectric;
        public boolean hasModel;
        public boolean supportsUpgrades;
        public Collection<ShapedMekanismRecipe> machineRecipes = new HashSet<ShapedMekanismRecipe>();

        private MachineType(MachineBlock block, int i, String s, int j, Class<? extends TileEntity> tileClass, boolean electric, boolean model, boolean upgrades) {
            this.typeBlock = block;
            this.meta = i;
            this.name = s;
            this.guiId = j;
            this.tileEntityClass = tileClass;
            this.isElectric = electric;
            this.hasModel = model;
            this.supportsUpgrades = upgrades;
        }

        public boolean isEnabled() {
            return MekanismConfig.machines.isEnabled(this.name);
        }

        public void addRecipes(Collection<ShapedMekanismRecipe> recipes2) {
            this.machineRecipes.addAll(recipes2);
        }

        public void addRecipe(ShapedMekanismRecipe recipe) {
            this.machineRecipes.add(recipe);
        }

        public Collection<ShapedMekanismRecipe> getRecipes() {
            return this.machineRecipes;
        }

        public static List<MachineType> getValidMachines() {
            ArrayList<MachineType> ret = new ArrayList<MachineType>();
            for (MachineType type : MachineType.values()) {
                if (type == AMBIENT_ACCUMULATOR) continue;
                ret.add(type);
            }
            return ret;
        }

        public static MachineType get(Block block, int meta) {
            if (block instanceof BlockMachine) {
                return MachineType.get(((BlockMachine)block).blockType, meta);
            }
            return null;
        }

        public static MachineType get(MachineBlock block, int meta) {
            for (MachineType type : MachineType.values()) {
                if (type.meta != meta || type.typeBlock != block) continue;
                return type;
            }
            return null;
        }

        public TileEntity create() {
            try {
                return this.tileEntityClass.newInstance();
            }
            catch (Exception e) {
                Mekanism.logger.error("Unable to indirectly create tile entity.");
                e.printStackTrace();
                return null;
            }
        }

        public double getUsage() {
            switch (this) {
                case ENRICHMENT_CHAMBER: {
                    return MekanismConfig.usage.enrichmentChamberUsage;
                }
                case OSMIUM_COMPRESSOR: {
                    return MekanismConfig.usage.osmiumCompressorUsage;
                }
                case COMBINER: {
                    return MekanismConfig.usage.combinerUsage;
                }
                case CRUSHER: {
                    return MekanismConfig.usage.crusherUsage;
                }
                case DIGITAL_MINER: {
                    return MekanismConfig.usage.digitalMinerUsage;
                }
                case BASIC_FACTORY: {
                    return MekanismConfig.usage.factoryUsage * 3.0;
                }
                case ADVANCED_FACTORY: {
                    return MekanismConfig.usage.factoryUsage * 5.0;
                }
                case ELITE_FACTORY: {
                    return MekanismConfig.usage.factoryUsage * 7.0;
                }
                case METALLURGIC_INFUSER: {
                    return MekanismConfig.usage.metallurgicInfuserUsage;
                }
                case PURIFICATION_CHAMBER: {
                    return MekanismConfig.usage.purificationChamberUsage;
                }
                case ENERGIZED_SMELTER: {
                    return MekanismConfig.usage.energizedSmelterUsage;
                }
                case TELEPORTER: {
                    return 12500.0;
                }
                case ELECTRIC_PUMP: {
                    return MekanismConfig.usage.electricPumpUsage;
                }
                case CHARGEPAD: {
                    return 25.0;
                }
                case LOGISTICAL_SORTER: {
                    return 0.0;
                }
                case ROTARY_CONDENSENTRATOR: {
                    return MekanismConfig.usage.rotaryCondensentratorUsage;
                }
                case CHEMICAL_OXIDIZER: {
                    return MekanismConfig.usage.oxidationChamberUsage;
                }
                case CHEMICAL_INFUSER: {
                    return MekanismConfig.usage.chemicalInfuserUsage;
                }
                case CHEMICAL_INJECTION_CHAMBER: {
                    return MekanismConfig.usage.chemicalInjectionChamberUsage;
                }
                case ELECTROLYTIC_SEPARATOR: {
                    return MekanismConfig.general.FROM_H2 * 2.0;
                }
                case PRECISION_SAWMILL: {
                    return MekanismConfig.usage.precisionSawmillUsage;
                }
                case CHEMICAL_DISSOLUTION_CHAMBER: {
                    return MekanismConfig.usage.chemicalDissolutionChamberUsage;
                }
                case CHEMICAL_WASHER: {
                    return MekanismConfig.usage.chemicalWasherUsage;
                }
                case CHEMICAL_CRYSTALLIZER: {
                    return MekanismConfig.usage.chemicalCrystallizerUsage;
                }
                case SEISMIC_VIBRATOR: {
                    return MekanismConfig.usage.seismicVibratorUsage;
                }
                case PRESSURIZED_REACTION_CHAMBER: {
                    return MekanismConfig.usage.pressurizedReactionBaseUsage;
                }
                case FLUID_TANK: {
                    return 0.0;
                }
                case FLUIDIC_PLENISHER: {
                    return MekanismConfig.usage.fluidicPlenisherUsage;
                }
                case LASER: {
                    return MekanismConfig.usage.laserUsage;
                }
                case LASER_AMPLIFIER: {
                    return 0.0;
                }
                case LASER_TRACTOR_BEAM: {
                    return 0.0;
                }
                case QUANTUM_ENTANGLOPORTER: {
                    return 0.0;
                }
                case SOLAR_NEUTRON_ACTIVATOR: {
                    return 0.0;
                }
                case AMBIENT_ACCUMULATOR: {
                    return 0.0;
                }
                case RESISTIVE_HEATER: {
                    return 100.0;
                }
                case FORMULAIC_ASSEMBLICATOR: {
                    return MekanismConfig.usage.formulaicAssemblicatorUsage;
                }
            }
            return 0.0;
        }

        public static void updateAllUsages() {
            for (MachineType type : MachineType.values()) {
                type.updateUsage();
            }
        }

        public void updateUsage() {
            this.baseEnergy = 400.0 * this.getUsage();
        }

        public String getDescription() {
            return LangUtils.localize("tooltip." + this.name);
        }

        public ItemStack getStack() {
            return new ItemStack(this.typeBlock.getBlock(), 1, this.meta);
        }

        public static MachineType get(ItemStack stack) {
            return MachineType.get(Block.func_149634_a((Item)stack.func_77973_b()), stack.func_77960_j());
        }
    }

    public static enum MachineBlock {
        MACHINE_BLOCK_1,
        MACHINE_BLOCK_2,
        MACHINE_BLOCK_3;


        public Block getBlock() {
            switch (this) {
                case MACHINE_BLOCK_1: {
                    return MekanismBlocks.MachineBlock;
                }
                case MACHINE_BLOCK_2: {
                    return MekanismBlocks.MachineBlock2;
                }
                case MACHINE_BLOCK_3: {
                    return MekanismBlocks.MachineBlock3;
                }
            }
            return null;
        }
    }
}

