/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.Objects;
import mekanism.api.MekanismConfig;

public enum Resource {
    IRON("Iron"),
    GOLD("Gold"),
    OSMIUM("Osmium"),
    COPPER("Copper"),
    TIN("Tin"),
    SILVER("Silver"),
    LEAD("Lead");

    private String name;

    private Resource(String s) {
        this.name = s;
    }

    public static Resource getFromName(String s) {
        for (Resource r : Resource.values()) {
            String resourceName = r.getOredictName().toLowerCase();
            if (!resourceName.equals(s.toLowerCase())) continue;
            return r;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getOredictName() {
        String oreName = this.name;
        if (MekanismConfig.mekce.PlatReplacement && Objects.equals(oreName, "Osmium")) {
            oreName = "Platinum";
        }
        return oreName;
    }
}

