/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class FluidNetwork
extends DynamicNetwork<IFluidHandler, FluidNetwork> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float fluidScale;
    public Fluid refFluid;
    public FluidStack buffer;
    public int prevStored;
    public int prevTransferAmount = 0;

    public FluidNetwork() {
    }

    public FluidNetwork(Collection<FluidNetwork> networks) {
        for (FluidNetwork net : networks) {
            if (net == null) continue;
            if (net.buffer != null) {
                if (this.buffer == null) {
                    this.buffer = net.buffer.copy();
                } else if (this.buffer.getFluid() == net.buffer.getFluid()) {
                    this.buffer.amount += net.buffer.amount;
                } else if (net.buffer.amount > this.buffer.amount) {
                    this.buffer = net.buffer.copy();
                }
                net.buffer = null;
            }
            this.adoptTransmittersAndAcceptorsFrom(net);
            net.deregister();
        }
        this.fluidScale = this.getScale();
        this.register();
    }

    @Override
    public void absorbBuffer(IGridTransmitter<IFluidHandler, FluidNetwork> transmitter) {
        Object b = transmitter.getBuffer();
        if (!(b instanceof FluidStack) || ((FluidStack)b).getFluid() == null || ((FluidStack)b).amount == 0) {
            return;
        }
        FluidStack fluid = (FluidStack)b;
        if (this.buffer == null || this.buffer.getFluid() == null || this.buffer.amount == 0) {
            this.buffer = fluid.copy();
            fluid.amount = 0;
            return;
        }
        if (this.buffer.isFluidEqual(fluid)) {
            this.buffer.amount += fluid.amount;
        }
        fluid.amount = 0;
    }

    @Override
    public void clampBuffer() {
        if (this.buffer != null && this.buffer.amount > this.getCapacity()) {
            this.buffer.amount = this.capacity;
        }
    }

    @Override
    protected void updateMeanCapacity() {
        int numCables = this.transmitters.size();
        double sum = 0.0;
        for (IGridTransmitter pipe : this.transmitters) {
            sum += (double)pipe.getCapacity();
        }
        this.meanCapacity = sum / (double)numCables;
    }

    public int getFluidNeeded() {
        return this.getCapacity() - (this.buffer != null ? this.buffer.amount : 0);
    }

    public int tickEmit(FluidStack fluidToSend, boolean doTransfer) {
        ArrayList<IFluidHandler> availableAcceptors = new ArrayList<IFluidHandler>();
        availableAcceptors.addAll(this.getAcceptors(fluidToSend));
        Collections.shuffle(availableAcceptors);
        int fluidSent = 0;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = fluidToSend.amount % divider;
            int sending = (fluidToSend.amount - remaining) / divider;
            block0: for (IFluidHandler acceptor : availableAcceptors) {
                int currentSending = sending;
                EnumSet sides = (EnumSet)this.acceptorDirections.get(Coord4D.get((TileEntity)acceptor));
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                for (ForgeDirection side : sides) {
                    int prev = fluidSent;
                    if (acceptor != null && fluidToSend != null) {
                        fluidSent += acceptor.fill(side, PipeUtils.copy(fluidToSend, currentSending), doTransfer);
                    }
                    if (fluidSent <= prev) continue;
                    continue block0;
                }
            }
        }
        if (doTransfer && fluidSent > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.didTransfer = true;
            this.transferDelay = 2;
        }
        return fluidSent;
    }

    public int emit(FluidStack fluidToSend, boolean doTransfer) {
        if (fluidToSend == null || this.buffer != null && this.buffer.getFluid() != fluidToSend.getFluid()) {
            return 0;
        }
        int toUse = Math.min(this.getFluidNeeded(), fluidToSend.amount);
        if (doTransfer) {
            if (this.buffer == null) {
                this.buffer = fluidToSend.copy();
                this.buffer.amount = toUse;
            } else {
                this.buffer.amount += toUse;
            }
        }
        return toUse;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int stored;
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.buffer != null ? this.buffer.amount : 0;
            if (stored != this.prevStored) {
                this.needsUpdate = true;
            }
            this.prevStored = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new FluidTransferEvent(this, this.buffer, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.buffer != null) {
                this.prevTransferAmount = this.tickEmit(this.buffer, true);
                if (this.buffer != null) {
                    this.buffer.amount -= this.prevTransferAmount;
                    if (this.buffer.amount <= 0) {
                        this.buffer = null;
                    }
                }
            }
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.fluidScale = Math.max(this.fluidScale, this.getScale());
        if (this.didTransfer && this.fluidScale < 1.0f) {
            this.fluidScale = Math.max(this.getScale(), Math.min(1.0f, this.fluidScale + 0.02f));
        } else if (!this.didTransfer && this.fluidScale > 0.0f) {
            this.fluidScale = this.getScale();
            if (this.fluidScale == 0.0f) {
                this.buffer = null;
            }
        }
    }

    @Override
    public Set<IFluidHandler> getAcceptors(Object data) {
        FluidStack fluidToSend = (FluidStack)data;
        HashSet<IFluidHandler> toReturn = new HashSet<IFluidHandler>();
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return toReturn;
        }
        block0: for (Coord4D coord : this.possibleAcceptors.keySet()) {
            EnumSet sides = (EnumSet)this.acceptorDirections.get(coord);
            TileEntity tile = coord.getTileEntity((IBlockAccess)this.getWorld());
            if (sides == null || sides.isEmpty() || !(tile instanceof IFluidHandler)) continue;
            IFluidHandler acceptor = (IFluidHandler)tile;
            for (ForgeDirection side : sides) {
                if (acceptor == null || !acceptor.canFill(side, fluidToSend.getFluid())) continue;
                toReturn.add(acceptor);
                continue block0;
            }
        }
        return toReturn;
    }

    public float getScale() {
        return Math.min(1.0f, this.buffer == null || this.getCapacity() == 0 ? 0.0f : (float)this.buffer.amount / (float)this.getCapacity());
    }

    public String toString() {
        return "[FluidNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public String getNeededInfo() {
        return (float)this.getFluidNeeded() / 1000.0f + " buckets";
    }

    @Override
    public String getStoredInfo() {
        return this.buffer != null ? LangUtils.localizeFluidStack(this.buffer) + " (" + this.buffer.amount + " mB)" : "None";
    }

    @Override
    public String getFlowInfo() {
        return Integer.toString(this.prevTransferAmount) + " mB/t";
    }

    public static class FluidTransferEvent
    extends Event {
        public final FluidNetwork fluidNetwork;
        public final FluidStack fluidType;
        public final boolean didTransfer;

        public FluidTransferEvent(FluidNetwork network, FluidStack type, boolean did) {
            this.fluidNetwork = network;
            this.fluidType = type;
            this.didTransfer = did;
        }
    }
}

