/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.nei;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasifyableItems;
import mekanism.client.gui.GuiChemicalInjectionChamber;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.nei.AdvancedMachineRecipeHandler;
import mekanism.common.Tier;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.machines.InjectionRecipe;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ChemicalInjectionChamberRecipeHandler
extends AdvancedMachineRecipeHandler {
    public String getRecipeName() {
        return LangUtils.localize("nei.chemicalInjectionChamber");
    }

    @Override
    public String getRecipeId() {
        return "mekanism.chemicalinjectionchamber";
    }

    public String getOverlayIdentifier() {
        return "chemicalinjectionchamber";
    }

    public Collection<InjectionRecipe> getRecipes() {
        return RecipeHandler.Recipe.CHEMICAL_INJECTION_CHAMBER.get().values();
    }

    @Override
    public List<ItemStack> getFuelStacks(Gas gasType) {
        if (GasifyableItems.isGasValidGasifyable(gasType)) {
            String oredict = GasifyableItems.getItemFromGas(gasType);
            ArrayList<ItemStack> fuels = new ArrayList<ItemStack>();
            if (oredict != null && !OreDictionary.getOres((String)oredict).isEmpty()) {
                fuels.addAll(OreDictionary.getOres((String)oredict));
            }
            if (gasType.isVisible()) {
                for (Tier.GasTankTier tier : Tier.GasTankTier.values()) {
                    fuels.add(MekanismUtils.getFullGasTank(tier, gasType));
                }
            }
            return fuels;
        }
        return new ArrayList<ItemStack>();
    }

    @Override
    public GuiProgress.ProgressBar getProgressType() {
        return GuiProgress.ProgressBar.YELLOW;
    }

    public Class getGuiClass() {
        return GuiChemicalInjectionChamber.class;
    }
}

