/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.MekanismConfig;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MMaterialFilter;
import mekanism.common.content.miner.MModIDFilter;
import mekanism.common.content.miner.MOreDictFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class GuiDigitalMinerConfig
extends GuiMekanism {
    public TileEntityDigitalMiner tileEntity;
    public boolean isDragging = false;
    private final int scrollX = 154;
    private final int scrollY = 18;
    private final int scrollW = 12;
    private final int scrollH = 138;
    private final int filterX = 56;
    private final int filterY = 18;
    private final int filterW = 96;
    private final int filterH = 29;
    public int dragOffset = 0;
    public int stackSwitch = 0;
    public Map<MOreDictFilter, StackData> oreDictStacks = new HashMap<MOreDictFilter, StackData>();
    public Map<MModIDFilter, StackData> modIDStacks = new HashMap<MModIDFilter, StackData>();
    public float scroll;
    private GuiTextField radiusField;
    private GuiTextField minField;
    private GuiTextField maxField;

    public GuiDigitalMinerConfig(EntityPlayer player, TileEntityDigitalMiner tentity) {
        super(tentity, new ContainerNull(player, tentity));
        this.tileEntity = tentity;
    }

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 123.0f), 123), 0);
    }

    public int getFilterIndex() {
        if (this.needsScrollBars()) {
            int scrollSize = this.tileEntity.filters.size() - 4;
            return (int)(((double)scrollSize + 0.5) * (double)this.scroll);
        }
        return 0;
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.radiusField.func_146178_a();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<MOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            for (Map.Entry<MinerFilter, StackData> entry : this.modIDStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() <= 0) continue;
                if (entry.getValue().stackIndex == -1 || entry.getValue().stackIndex == entry.getValue().iterStacks.size() - 1) {
                    entry.getValue().stackIndex = 0;
                } else if (entry.getValue().stackIndex < entry.getValue().iterStacks.size() - 1) {
                    ++entry.getValue().stackIndex;
                }
                entry.getValue().renderStack = entry.getValue().iterStacks.get(entry.getValue().stackIndex);
            }
            this.stackSwitch = 20;
        } else {
            for (Map.Entry<MOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = null;
            }
            for (Map.Entry<MinerFilter, StackData> entry : this.modIDStacks.entrySet()) {
                if (entry.getValue().iterStacks == null || entry.getValue().iterStacks.size() != 0) continue;
                entry.getValue().renderStack = null;
            }
        }
        HashSet<MOreDictFilter> oreDictFilters = new HashSet<MOreDictFilter>();
        HashSet<MModIDFilter> hashSet = new HashSet<MModIDFilter>();
        for (int i = 0; i < 4; ++i) {
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof MOreDictFilter) {
                oreDictFilters.add((MOreDictFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
                continue;
            }
            if (!(this.tileEntity.filters.get(this.getFilterIndex() + i) instanceof MModIDFilter)) continue;
            hashSet.add((MModIDFilter)this.tileEntity.filters.get(this.getFilterIndex() + i));
        }
        for (MinerFilter filter : this.tileEntity.filters) {
            if (filter instanceof MOreDictFilter && !oreDictFilters.contains(filter)) {
                if (!this.oreDictStacks.containsKey(filter)) continue;
                this.oreDictStacks.remove(filter);
                continue;
            }
            if (!(filter instanceof MModIDFilter) || hashSet.contains(filter) || !this.modIDStacks.containsKey(filter)) continue;
            this.modIDStacks.remove(filter);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) {
        super.func_73864_a(mouseX, mouseY, button);
        this.radiusField.func_146192_a(mouseX, mouseY, button);
        this.minField.func_146192_a(mouseX, mouseY, button);
        this.maxField.func_146192_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
            int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (this.needsScrollBars()) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 4; ++i) {
                ArrayList<Integer> data;
                if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
                int yStart = i * 29 + 18;
                int arrowX = 140;
                if (this.getFilterIndex() + i > 0 && xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 14 && yAxis <= yStart + 20) {
                    data = new ArrayList<Integer>();
                    data.add(11);
                    data.add(this.getFilterIndex() + i);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    SoundHandler.playSound("gui.button.press");
                    return;
                }
                if (this.getFilterIndex() + i < this.tileEntity.filters.size() - 1 && xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 21 && yAxis <= yStart + 27) {
                    data = new ArrayList();
                    data.add(12);
                    data.add(this.getFilterIndex() + i);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                    SoundHandler.playSound("gui.button.press");
                    return;
                }
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                MinerFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
                if (filter instanceof MItemStackFilter) {
                    SoundHandler.playSound("gui.button.press");
                    Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 1, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (filter instanceof MOreDictFilter) {
                    SoundHandler.playSound("gui.button.press");
                    Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 2, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (filter instanceof MMaterialFilter) {
                    SoundHandler.playSound("gui.button.press");
                    Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 3, this.getFilterIndex() + i, 0));
                    continue;
                }
                if (!(filter instanceof MModIDFilter)) continue;
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER_INDEX, Coord4D.get(this.tileEntity), 6, this.getFilterIndex() + i, 0));
            }
            if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
                SoundHandler.playSound("gui.button.press");
                Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 4, 0, 0));
            }
            if (xAxis >= 39 && xAxis <= 50 && yAxis >= 67 && yAxis <= 78) {
                SoundHandler.playSound("gui.button.press");
                this.setRadius();
            }
            if (xAxis >= 39 && xAxis <= 50 && yAxis >= 92 && yAxis <= 103) {
                SoundHandler.playSound("gui.button.press");
                this.setMinY();
            }
            if (xAxis >= 39 && xAxis <= 50 && yAxis >= 117 && yAxis <= 128) {
                SoundHandler.playSound("gui.button.press");
                this.setMaxY();
            }
            if (xAxis >= 11 && xAxis <= 25 && yAxis >= 141 && yAxis <= 155) {
                ArrayList<Integer> data = new ArrayList<Integer>();
                data.add(10);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
                SoundHandler.playSound("gui.button.press");
            }
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        if (this.isDragging) {
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 123.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int x, int y, int type) {
        super.func_146286_b(x, y, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.tileEntity.filters.size() - 4;
            if (i > 0) {
                i = 1;
            }
            if (i < 0) {
                i = -1;
            }
            this.scroll = (float)((double)this.scroll - (double)i / (double)j);
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
            }
            if (this.scroll > 1.0f) {
                this.scroll = 1.0f;
            }
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, guiWidth + 56, guiHeight + 136, 96, 20, LangUtils.localize("gui.newFilter")));
        String prevRad = this.radiusField != null ? this.radiusField.func_146179_b() : "";
        String prevMin = this.minField != null ? this.minField.func_146179_b() : "";
        String prevMax = this.maxField != null ? this.maxField.func_146179_b() : "";
        this.radiusField = new GuiTextField(this.field_146289_q, guiWidth + 12, guiHeight + 67, 26, 11);
        this.radiusField.func_146203_f(2);
        this.radiusField.func_146180_a(prevRad);
        this.minField = new GuiTextField(this.field_146289_q, guiWidth + 12, guiHeight + 92, 26, 11);
        this.minField.func_146203_f(3);
        this.minField.func_146180_a(prevMin);
        this.maxField = new GuiTextField(this.field_146289_q, guiWidth + 12, guiHeight + 117, 26, 11);
        this.maxField.func_146203_f(3);
        this.maxField.func_146180_a(prevMax);
    }

    protected void func_146284_a(GuiButton guibutton) {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), 5, 0, 0));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.digitalMinerConfig"), 43, 6, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.filters") + ":", 11, 19, 52480);
        this.field_146289_q.func_78276_b("T: " + this.tileEntity.filters.size(), 11, 28, 52480);
        this.field_146289_q.func_78276_b("I: " + (this.tileEntity.inverse ? LangUtils.localize("gui.on") : LangUtils.localize("gui.off")), 11, 131, 52480);
        this.field_146289_q.func_78276_b("Radi: " + this.tileEntity.radius, 11, 58, 52480);
        this.field_146289_q.func_78276_b("Min: " + this.tileEntity.minY, 11, 83, 52480);
        this.field_146289_q.func_78276_b("Max: " + this.tileEntity.maxY, 11, 108, 52480);
        for (int i = 0; i < 4; ++i) {
            MinerFilter itemFilter;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            MinerFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            if (filter instanceof MItemStackFilter) {
                itemFilter = (MItemStackFilter)filter;
                if (itemFilter.itemType != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), itemFilter.itemType, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (filter instanceof MOreDictFilter) {
                MOreDictFilter oreFilter = (MOreDictFilter)filter;
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                if (this.oreDictStacks.get((Object)filter).renderStack != null) {
                    try {
                        GL11.glPushMatrix();
                        GL11.glEnable((int)2896);
                        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.oreDictStacks.get((Object)filter).renderStack, 59, yStart + 3);
                        GL11.glDisable((int)2896);
                        GL11.glPopMatrix();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (filter instanceof MMaterialFilter) {
                itemFilter = (MMaterialFilter)filter;
                if (((MMaterialFilter)itemFilter).materialItem != null) {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), ((MMaterialFilter)itemFilter).materialItem, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
                continue;
            }
            if (!(filter instanceof MModIDFilter)) continue;
            MModIDFilter modFilter = (MModIDFilter)filter;
            if (!this.modIDStacks.containsKey(modFilter)) {
                this.updateStackList(modFilter);
            }
            if (this.modIDStacks.get((Object)filter).renderStack != null) {
                try {
                    GL11.glPushMatrix();
                    GL11.glEnable((int)2896);
                    field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.func_110434_K(), this.modIDStacks.get((Object)filter).renderStack, 59, yStart + 3);
                    GL11.glDisable((int)2896);
                    GL11.glPopMatrix();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
        }
        if (xAxis >= 11 && xAxis <= 25 && yAxis >= 141 && yAxis <= 155) {
            this.func_146279_a(LangUtils.localize("gui.digitalMiner.inverse"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void func_146976_a(float partialTick, int mouseX, int mouseY) {
        super.func_146976_a(partialTick, mouseX, mouseY);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiDigitalMinerConfig.png"));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int guiWidth = (this.field_146294_l - this.field_146999_f) / 2;
        int guiHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(guiWidth, guiHeight, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.field_147003_i + 154, this.field_147009_r + 18 + this.getScroll(), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        int xAxis = mouseX - (this.field_146294_l - this.field_146999_f) / 2;
        int yAxis = mouseY - (this.field_146295_m - this.field_147000_g) / 2;
        for (int i = 0; i < 4; ++i) {
            boolean mouseOver;
            if (this.tileEntity.filters.get(this.getFilterIndex() + i) == null) continue;
            MinerFilter filter = this.tileEntity.filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            boolean bl = mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart + 29;
            if (filter instanceof MItemStackFilter) {
                MekanismRenderer.color(EnumColor.INDIGO, 1.0f, 2.5f);
            } else if (filter instanceof MOreDictFilter) {
                MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0f, 2.5f);
            } else if (filter instanceof MMaterialFilter) {
                MekanismRenderer.color(EnumColor.PURPLE, 1.0f, 4.0f);
            } else if (filter instanceof MModIDFilter) {
                MekanismRenderer.color(EnumColor.PINK, 1.0f, 2.5f);
            }
            this.func_73729_b(guiWidth + 56, guiHeight + yStart, mouseOver ? 0 : 96, 166, 96, 29);
            MekanismRenderer.resetColor();
            int arrowX = 140;
            if (this.getFilterIndex() + i > 0) {
                mouseOver = xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 14 && yAxis <= yStart + 20;
                this.func_73729_b(this.field_147003_i + 140, this.field_147009_r + yStart + 14, 190, mouseOver ? 143 : 115, 11, 7);
            }
            if (this.getFilterIndex() + i >= this.tileEntity.filters.size() - 1) continue;
            mouseOver = xAxis >= 140 && xAxis <= 150 && yAxis >= yStart + 21 && yAxis <= yStart + 27;
            this.func_73729_b(this.field_147003_i + 140, this.field_147009_r + yStart + 21, 190, mouseOver ? 157 : 129, 11, 7);
        }
        if (xAxis >= 5 && xAxis <= 16 && yAxis >= 5 && yAxis <= 16) {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 5, guiHeight + 5, 176, 11, 11, 11);
        }
        if (xAxis >= 39 && xAxis <= 50 && yAxis >= 67 && yAxis <= 78) {
            this.func_73729_b(guiWidth + 39, guiHeight + 67, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 39, guiHeight + 67, 187, 11, 11, 11);
        }
        if (xAxis >= 39 && xAxis <= 50 && yAxis >= 92 && yAxis <= 103) {
            this.func_73729_b(guiWidth + 39, guiHeight + 92, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 39, guiHeight + 92, 187, 11, 11, 11);
        }
        if (xAxis >= 39 && xAxis <= 50 && yAxis >= 117 && yAxis <= 128) {
            this.func_73729_b(guiWidth + 39, guiHeight + 117, 187, 0, 11, 11);
        } else {
            this.func_73729_b(guiWidth + 39, guiHeight + 117, 187, 11, 11, 11);
        }
        if (xAxis >= 11 && xAxis <= 25 && yAxis >= 141 && yAxis <= 155) {
            this.func_73729_b(guiWidth + 11, guiHeight + 141, 198, 0, 14, 14);
        } else {
            this.func_73729_b(guiWidth + 11, guiHeight + 141, 198, 14, 14, 14);
        }
        this.radiusField.func_146194_f();
        this.minField.func_146194_f();
        this.maxField.func_146194_f();
    }

    public void func_73869_a(char c, int i) {
        if (!this.radiusField.func_146206_l() && !this.minField.func_146206_l() && !this.maxField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28) {
            if (this.radiusField.func_146206_l()) {
                this.setRadius();
            } else if (this.minField.func_146206_l()) {
                this.setMinY();
            } else if (this.maxField.func_146206_l()) {
                this.setMaxY();
            }
        }
        if (Character.isDigit(c) || GuiDigitalMinerConfig.isTextboxKey(c, i)) {
            this.radiusField.func_146201_a(c, i);
            this.minField.func_146201_a(c, i);
            this.maxField.func_146201_a(c, i);
        }
    }

    private void setRadius() {
        if (!this.radiusField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.radiusField.func_146179_b()), MekanismConfig.mekce.digitalMinerMaxRadius));
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(6);
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.radiusField.func_146180_a("");
        }
    }

    private void setMinY() {
        if (!this.minField.func_146179_b().isEmpty()) {
            int toUse = Math.max(0, Math.min(Integer.parseInt(this.minField.func_146179_b()), this.tileEntity.maxY));
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(7);
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.minField.func_146180_a("");
        }
    }

    private void setMaxY() {
        if (!this.maxField.func_146179_b().isEmpty()) {
            int toUse = Math.max(this.tileEntity.minY, Math.min(Integer.parseInt(this.maxField.func_146179_b()), 255));
            ArrayList<Integer> data = new ArrayList<Integer>();
            data.add(8);
            data.add(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(Coord4D.get(this.tileEntity), data));
            this.maxField.func_146180_a("");
        }
    }

    private void updateStackList(MOreDictFilter filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        this.oreDictStacks.get((Object)filter).iterStacks = OreDictCache.getOreDictStacks(filter.oreDictName, true);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.oreDictStacks.get((Object)filter).stackIndex = -1;
    }

    private void updateStackList(MModIDFilter filter) {
        if (!this.modIDStacks.containsKey(filter)) {
            this.modIDStacks.put(filter, new StackData());
        }
        this.modIDStacks.get((Object)filter).iterStacks = OreDictCache.getModIDStacks(filter.modID, true);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.modIDStacks.get((Object)filter).stackIndex = -1;
    }

    private boolean needsScrollBars() {
        return this.tileEntity.filters.size() > 4;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack;
    }
}

