/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mekanism.api.EnumColor;
import mekanism.api.util.StackUtils;
import mekanism.client.MekKeyHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.block.BlockMachine;
import mekanism.common.item.ItemBlockMachine;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemElectricBow;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemJetpack;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.network.PacketConfiguratorState;
import mekanism.common.network.PacketElectricBowState;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketPortableTankState;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.util.LangUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

@SideOnly(value=Side.CLIENT)
public class MekanismKeyHandler
extends MekKeyHandler {
    public static final String keybindCategory = "Mekanism";
    public static KeyBinding modeSwitchKey = new KeyBinding("Mekanism " + LangUtils.localize("key.mode"), 50, "Mekanism");
    public static KeyBinding armorModeSwitchKey = new KeyBinding("Mekanism " + LangUtils.localize("key.armorMode"), 33, "Mekanism");
    public static KeyBinding sneakKey = Minecraft.func_71410_x().field_71474_y.field_74311_E;
    public static KeyBinding jumpKey = Minecraft.func_71410_x().field_71474_y.field_74314_A;

    public MekanismKeyHandler() {
        super(new KeyBinding[]{modeSwitchKey, armorModeSwitchKey}, new boolean[]{false, false, true});
        ClientRegistry.registerKeyBinding((KeyBinding)modeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)armorModeSwitchKey);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @SubscribeEvent
    public void onTick(InputEvent event) {
        this.keyTick();
    }

    @Override
    public void keyDown(KeyBinding kb, boolean isRepeat) {
        if (kb == modeSwitchKey) {
            EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
            ItemStack toolStack = player.func_71045_bC();
            Item item = StackUtils.getItem(toolStack);
            if (player.func_70093_af() && item instanceof ItemConfigurator) {
                ItemConfigurator configurator = (ItemConfigurator)item;
                int toSet = configurator.getState(toolStack).ordinal() < ItemConfigurator.ConfiguratorMode.values().length - 1 ? configurator.getState(toolStack).ordinal() + 1 : 0;
                configurator.setState(toolStack, ItemConfigurator.ConfiguratorMode.values()[toSet]);
                Mekanism.packetHandler.sendToServer(new PacketConfiguratorState.ConfiguratorStateMessage(configurator.getState(toolStack)));
                player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.configureState") + ": " + (Object)((Object)configurator.getColor(configurator.getState(toolStack))) + configurator.getStateDisplay(configurator.getState(toolStack))));
            } else if (player.func_70093_af() && item instanceof ItemElectricBow) {
                ItemElectricBow bow;
                bow.setFireState(toolStack, !(bow = (ItemElectricBow)item).getFireState(toolStack));
                Mekanism.packetHandler.sendToServer(new PacketElectricBowState.ElectricBowStateMessage(bow.getFireState(toolStack)));
                player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.fireMode") + ": " + (Object)((Object)(bow.getFireState(toolStack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + LangUtils.transOnOff(bow.getFireState(toolStack))));
            } else if (player.func_70093_af() && item instanceof ItemBlockMachine) {
                ItemBlockMachine machine = (ItemBlockMachine)item;
                if (BlockMachine.MachineType.get(toolStack) == BlockMachine.MachineType.FLUID_TANK) {
                    machine.setBucketMode(toolStack, !machine.getBucketMode(toolStack));
                    Mekanism.packetHandler.sendToServer(new PacketPortableTankState.PortableTankStateMessage(machine.getBucketMode(toolStack)));
                    player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.portableTank.bucketMode") + ": " + (Object)((Object)(machine.getBucketMode(toolStack) ? EnumColor.DARK_GREEN : EnumColor.DARK_RED)) + LangUtils.transOnOff(machine.getBucketMode(toolStack))));
                }
            } else if (player.func_70093_af() && item instanceof ItemFlamethrower) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)item;
                flamethrower.incrementMode(toolStack);
                Mekanism.packetHandler.sendToServer(new PacketFlamethrowerData.FlamethrowerDataMessage(PacketFlamethrowerData.FlamethrowerPacket.MODE, null, false));
                player.func_145747_a((IChatComponent)new ChatComponentText((Object)((Object)EnumColor.DARK_BLUE) + "[Mekanism] " + (Object)((Object)EnumColor.GREY) + LangUtils.localize("tooltip.flamethrower.modeBump") + ": " + flamethrower.getMode(toolStack).getName()));
            }
        } else if (kb == armorModeSwitchKey) {
            EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
            ItemStack chestStack = player.func_82169_q(2);
            Item chestItem = StackUtils.getItem(chestStack);
            if (chestItem instanceof ItemJetpack) {
                ItemJetpack jetpack = (ItemJetpack)chestItem;
                if (player.func_70093_af()) {
                    jetpack.setMode(chestStack, ItemJetpack.JetpackMode.DISABLED);
                } else {
                    jetpack.incrementMode(chestStack);
                }
                Mekanism.packetHandler.sendToServer(new PacketJetpackData.JetpackDataMessage(PacketJetpackData.JetpackPacket.MODE, null, player.func_70093_af()));
                SoundHandler.playSound("mekanism:etc.Hydraulic");
            } else if (chestItem instanceof ItemScubaTank) {
                ItemScubaTank scubaTank = (ItemScubaTank)chestItem;
                scubaTank.toggleFlowing(chestStack);
                Mekanism.packetHandler.sendToServer(new PacketScubaTankData.ScubaTankDataMessage(PacketScubaTankData.ScubaTankPacket.MODE, null, false));
                SoundHandler.playSound("mekanism:etc.Hydraulic");
            }
        }
    }

    @Override
    public void keyUp(KeyBinding kb) {
    }
}

