/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import java.util.ArrayList;
import java.util.List;
import mekanism.api.gas.Gas;
import net.minecraftforge.fluids.Fluid;

public class GasRegistry {
    private static ArrayList<Gas> registeredGasses = new ArrayList();

    public static Gas register(Gas gas) {
        if (gas == null) {
            return null;
        }
        registeredGasses.add(gas);
        return GasRegistry.getGas(gas.getName());
    }

    public static Gas getGas(int id) {
        return id == -1 ? null : registeredGasses.get(id);
    }

    public static Gas getGas(Fluid f) {
        return registeredGasses.stream().filter(gas -> gas.hasFluid() && gas.getFluid() == f).findAny().orElse(null);
    }

    public static boolean containsGas(String name) {
        return GasRegistry.getGas(name) != null;
    }

    public static List<Gas> getRegisteredGasses() {
        return (List)registeredGasses.clone();
    }

    public static Gas getGas(String name) {
        return registeredGasses.stream().filter(gas -> gas.getName().equalsIgnoreCase(name)).findAny().orElse(null);
    }

    public static int getGasID(Gas gas) {
        return gas == null || !GasRegistry.containsGas(gas.getName()) ? -1 : registeredGasses.indexOf(gas);
    }
}

