/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.item;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.common.ISpecialArmor;
import tterrag.customthings.common.config.json.items.ArmorType;
import tterrag.customthings.common.item.ICustomRepair;
import tterrag.customthings.common.item.ItemCustomPickaxe;
import tterrag.customthings.common.item.ItemProxy;

public class ItemCustomArmor
extends ItemArmor
implements ISpecialArmor,
ICustomRepair<ArmorType> {
    private String textureName;
    private ArmorType type;
    private final ItemProxy<ArmorType, ItemCustomArmor> proxy = new ItemProxy(this);

    public ItemCustomArmor(ArmorType type, int slot) {
        super(type.getMaterial(), 0, slot);
        this.type = type;
        this.func_111206_d(type.getIconName(slot));
        this.func_77655_b(type.getUnlocName(slot));
        this.textureName = "customthings".toLowerCase() + ":textures/items/" + type.getTextureName(slot) + ".png";
    }

    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        return this.textureName;
    }

    public int getMaxDamage(ItemStack stack) {
        return this.type.durabilities[this.field_77881_a];
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (!source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(this.type.priorities[this.field_77881_a], this.type.protectionRatios[this.field_77881_a], this.type.protectionMaxes[this.field_77881_a]);
        }
        return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        return this.type.protectionDisplays[slot];
    }

    public void damageArmor(EntityLivingBase entity, ItemStack stack, DamageSource source, int damage, int slot) {
        stack.func_77972_a(damage, entity);
    }

    public boolean func_82789_a(ItemStack stack, ItemStack material) {
        return ItemCustomPickaxe.repairMatMatchesOredict(stack, material);
    }

    @Override
    public ArmorType getType(ItemStack stack) {
        return this.type;
    }

    public ArmorType getType() {
        return this.type;
    }

    public int getItemStackLimit(ItemStack stack) {
        return this.proxy.getItemStackLimit(stack);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return this.proxy.hasContainerItem(stack);
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return this.proxy.getContainerItem(stack);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return this.proxy.getRarity(stack);
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return this.proxy.hasEffect(stack, pass);
    }
}

