/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.handlers;

import com.enderio.core.EnderCore;
import com.enderio.core.common.Handlers;
import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatisticsFile;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AchievementEvent;
import net.minecraftforge.event.world.BlockEvent;
import tterrag.customthings.common.config.json.AchievementType;

@Handlers.Handler
public class AchievementHandler {
    private static boolean ignoreAchievement = false;

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        AchievementHandler.triggerAchievement(AchievementType.AchievementSource.BLOCK_BREAK, event.getPlayer(), event.block, event.blockMetadata);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.source.func_76364_f() instanceof EntityPlayer) {
            AchievementHandler.triggerAchievement(AchievementType.AchievementSource.ENTITY_KILL, (EntityPlayer)event.source.func_76364_f(), event.entityLiving);
        }
    }

    @SubscribeEvent
    public void onItemPickup(PlayerEvent.ItemPickupEvent event) {
        AchievementHandler.triggerAchievement(AchievementType.AchievementSource.ITEM_PICKUP, event.player, event.pickedUp.func_92059_d());
    }

    @SubscribeEvent
    public void onItemCrafted(PlayerEvent.ItemCraftedEvent event) {
        AchievementHandler.triggerAchievement(AchievementType.AchievementSource.CRAFTING, event.player, event.crafting);
    }

    @SubscribeEvent
    public void onAchievement(final AchievementEvent event) {
        if (ignoreAchievement || event.entityPlayer.field_70170_p.field_72995_K || ((EntityPlayerMP)event.entityPlayer).func_147099_x().func_77443_a(event.achievement)) {
            return;
        }
        AchievementPage page = null;
        for (AchievementPage p : AchievementPage.getAchievementPages()) {
            if (!p.getAchievements().contains(event.achievement)) continue;
            page = p;
        }
        final AchievementPage pf = page;
        EnderCore.proxy.getScheduler().schedule(50, new Runnable(){

            @Override
            public void run() {
                ignoreAchievement = true;
                AchievementHandler.triggerAchievement(AchievementType.AchievementSource.ACHIEVEMENT_PAGE, event.entityPlayer, new Object[]{pf, event.entityPlayer, event.achievement});
                ignoreAchievement = false;
            }
        });
    }

    private static void triggerAchievement(AchievementType.AchievementSource source, EntityPlayer player, Object ... in) {
        if (!player.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            for (AchievementType type : AchievementType.lookup.get((Object)source)) {
                StatisticsFile file;
                if (!source.matchesObject(type.sourceObj, in)) continue;
                if (type.rewardStack != null && !(file = ((EntityPlayerMP)player).func_147099_x()).func_77443_a(type.achievement) && file.func_77442_b(type.achievement)) {
                    ItemStack stack = type.rewardStack.func_77946_l();
                    if (type.rewardNBT != null) {
                        stack = ItemUtil.parseStringIntoItemStack((String)(ItemUtil.getStringForItemStack((ItemStack)stack, (boolean)true, (boolean)true) + "$" + AchievementType.Template.format(type.rewardNBT, new AchievementType.AchievementData(type.achievement, player))));
                    }
                    if (!player.field_71071_by.func_70441_a(stack)) {
                        player.field_70170_p.func_72838_d((Entity)new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, type.rewardStack.func_77946_l()));
                    }
                }
                player.func_71064_a((StatBase)type.achievement, 1);
            }
        }
    }
}

