/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config.json.items;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemRecord;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.StringUtils;
import tterrag.customthings.common.config.json.items.ItemType;
import tterrag.customthings.common.item.ItemCustomRecord;

public class RecordType
extends ItemType {
    public int color = 0xFF70FF;
    public boolean isCreeperLoot = true;
    private transient ItemRecord item;
    public static final List<RecordType> types = new ArrayList<RecordType>();

    @Override
    public void register() {
        this.maxStackSize = 1;
        super.register();
        this.item = new ItemCustomRecord(this);
        GameRegistry.registerItem((Item)this.item, (String)this.name);
        types.add(this);
        OreDictionary.registerOre((String)"record", (Item)this.item);
        OreDictionary.registerOre((String)("record" + StringUtils.capitalize((String)this.name)), (Item)this.item);
        this.addOreDictNames(new ItemStack((Item)this.item));
    }

    public static int getColor(Item item) {
        for (RecordType type : types) {
            if (type.item != item) continue;
            return type.color;
        }
        return 0xFFFFFF;
    }

    public static int getNumRecords() {
        return types.size();
    }

    public static int getLootRecordCount() {
        int count = 0;
        for (RecordType type : types) {
            count += type.isCreeperLoot ? 1 : 0;
        }
        return count;
    }

    public static Item getItem(int index) {
        return RecordType.types.get((int)(index % RecordType.types.size())).item;
    }

    public static RecordType getType(int index) {
        return types.get(index);
    }
}

