/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config.json.crafting;

import com.enderio.core.common.util.ItemUtil;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;
import tterrag.customthings.common.config.json.IJsonType;

public class ShapedJsonRecipe
implements IJsonType {
    private String[][] input;
    private String output;
    private int outputAmount = 1;
    private static final int STARTING_VALUE = Character.valueOf('a').charValue();

    public ShapedOreRecipe createRecipe() {
        if (this.input == null || this.output == null) {
            throw new InvalidShapedRecipeException((this.input == null ? "Input was null" : "Output was null") + ". You must define this value.");
        }
        int height = this.input.length;
        int width = this.input[ShapedJsonRecipe.getMaxLengthIndex(this.input)].length;
        ArrayList<Object> inputs = new ArrayList<Object>();
        String[][] stringArray = this.input;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] arr;
            for (String s : arr = stringArray[i]) {
                inputs.add(ItemUtil.parseStringIntoRecipeItem((String)s));
            }
        }
        ItemStack output = (ItemStack)ItemUtil.parseStringIntoRecipeItem((String)this.output, (boolean)true);
        Object[] recipeArr = new Object[height];
        String cur = null;
        int charIdx = STARTING_VALUE;
        for (int h = 0; h < height; ++h) {
            cur = "";
            for (int w = 0; w < width; ++w) {
                cur = this.input[h].length > w ? cur + (char)charIdx++ : cur + " ";
            }
            recipeArr[h] = cur;
        }
        ArrayList<Object> toAdd = new ArrayList<Object>(Arrays.asList(recipeArr));
        Iterator inputIterator = inputs.iterator();
        for (int i = STARTING_VALUE; i <= ShapedJsonRecipe.getHighestCharValue(cur); ++i) {
            Object obj = inputIterator.next();
            if (obj == null) continue;
            toAdd.add(Character.valueOf((char)i));
            toAdd.add(obj);
        }
        output.field_77994_a = this.outputAmount;
        return new ShapedOreRecipe(output.func_77946_l(), toAdd.toArray());
    }

    @Override
    public void register() {
        GameRegistry.addRecipe((IRecipe)this.createRecipe());
    }

    private static int getHighestCharValue(String cur) {
        char maxValue = '\u0000';
        for (char c : cur.toCharArray()) {
            if (c <= maxValue) continue;
            maxValue = c;
        }
        return maxValue;
    }

    private static int getMaxLengthIndex(Object[][] arr) {
        int index = 0;
        int maxSize = 0;
        for (int i = 0; i < arr.length; ++i) {
            Object[] arr2 = arr[i];
            if (arr2.length <= maxSize) continue;
            index = i;
            maxSize = arr2.length;
        }
        return index;
    }

    @Override
    public void postInit() {
    }

    private static class InvalidShapedRecipeException
    extends RuntimeException {
        public InvalidShapedRecipeException(String text) {
            super(text);
        }
    }
}

