/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config.json;

import com.enderio.core.common.util.ItemUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatisticsFile;
import net.minecraftforge.common.AchievementPage;
import tterrag.customthings.common.config.json.JsonType;

public class AchievementType
extends JsonType {
    public int x = 0;
    public int y = 0;
    public String page = null;
    public String parent = null;
    public String source = "CRAFTING";
    public String required = "minecraft:stone";
    public String displayItem = null;
    public String reward = null;
    public String rewardNBT = null;
    public boolean isSpecial = false;
    private transient Achievement parentAchievement = null;
    public transient Achievement achievement;
    public transient AchievementSource achievementSource;
    public transient Object sourceObj;
    public transient ItemStack rewardStack;
    public static final List<AchievementType> achievements = Lists.newArrayList();
    public static final Multimap<AchievementSource, AchievementType> lookup = HashMultimap.create();

    @Override
    public void register() {
        if (this.parent != null) {
            for (Achievement a : AchievementList.field_76007_e) {
                if (!a.field_75975_e.equals(this.parent)) continue;
                this.parentAchievement = a;
            }
        }
        if (this.displayItem == null) {
            this.displayItem = this.required;
        }
        this.achievement = new Ach(this.name, this.name, this.x, this.y, ItemUtil.parseStringIntoItemStack((String)this.displayItem), this.parentAchievement);
        if (this.parentAchievement == null) {
            this.achievement.func_75966_h();
        }
        if (this.isSpecial) {
            this.achievement.func_75987_b();
        }
        AchievementPage achievementPage = this.page == null ? null : AchievementPage.getAchievementPage((String)this.page);
        boolean newPage = false;
        if (achievementPage == null && this.page != null) {
            achievementPage = new AchievementPage(this.page, new Achievement[0]);
            newPage = true;
        }
        if (achievementPage != null) {
            if (newPage) {
                AchievementPage.registerAchievementPage((AchievementPage)achievementPage);
            }
            achievementPage.getAchievements().add(this.achievement);
        } else {
            AchievementList.field_76007_e.add(this.achievement);
        }
        this.achievement.func_75971_g();
        this.achievementSource = AchievementSource.valueOf(this.source.toUpperCase());
        this.sourceObj = this.achievementSource.getObjectFromString(this.required);
        achievements.add(this);
        lookup.put((Object)this.achievementSource, (Object)this);
    }

    @Override
    public void postInit() {
        if (this.reward != null) {
            this.rewardStack = ItemUtil.parseStringIntoItemStack((String)this.reward);
        }
    }

    private class Ach
    extends Achievement {
        private AchievementType parent;

        public Ach(String p_i45302_1_, String p_i45302_2_, int p_i45302_3_, int p_i45302_4_, ItemStack p_i45302_5_, Achievement p_i45302_6_) {
            super(p_i45302_1_, p_i45302_2_, p_i45302_3_, p_i45302_4_, p_i45302_5_, p_i45302_6_);
            this.parent = AchievementType.this;
        }
    }

    public static enum Template {
        TIMESTAMP,
        ACHIEVEMENT_ID,
        ACHIEVEMENT_NAME,
        USER_NAME,
        USER_UUID;


        public String template() {
            return "%" + this.name() + "%";
        }

        public static String format(String s, AchievementData data) {
            return s.replace(TIMESTAMP.template(), Long.toString(data.time) + "L").replace(ACHIEVEMENT_ID.template(), ((AchievementData)data).ach.field_75975_e).replace(ACHIEVEMENT_NAME.template(), "achievement." + ((AchievementData)data).ach.field_75975_e).replace(USER_NAME.template(), data.player.func_70005_c_()).replace(USER_UUID.template(), data.player.func_146103_bH().getId().toString());
        }
    }

    public static final class AchievementData {
        private final long time = System.currentTimeMillis();
        private final Achievement ach;
        private final EntityPlayer player;

        public AchievementData(Achievement ach, EntityPlayer player) {
            this.ach = ach;
            this.player = player;
        }

        public long getTime() {
            return this.time;
        }

        public Achievement getAch() {
            return this.ach;
        }

        public EntityPlayer getPlayer() {
            return this.player;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AchievementData)) {
                return false;
            }
            AchievementData other = (AchievementData)o;
            if (this.getTime() != other.getTime()) {
                return false;
            }
            Achievement this$ach = this.getAch();
            Achievement other$ach = other.getAch();
            if (this$ach == null ? other$ach != null : !this$ach.equals(other$ach)) {
                return false;
            }
            EntityPlayer this$player = this.getPlayer();
            EntityPlayer other$player = other.getPlayer();
            return !(this$player == null ? other$player != null : !this$player.equals(other$player));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            Achievement $ach = this.getAch();
            result = result * 59 + ($ach == null ? 43 : $ach.hashCode());
            EntityPlayer $player = this.getPlayer();
            result = result * 59 + ($player == null ? 43 : $player.hashCode());
            return result;
        }

        public String toString() {
            return "AchievementType.AchievementData(time=" + this.getTime() + ", ach=" + this.getAch() + ", player=" + this.getPlayer() + ")";
        }
    }

    public static enum AchievementSource {
        CRAFTING{

            @Override
            protected Object getObjectFromString(String s) {
                return ItemUtil.parseStringIntoRecipeItem((String)s);
            }

            @Override
            public boolean matchesObject(Object test, Object ... in) {
                Object obj = in[0];
                if (obj instanceof String) {
                    if (test instanceof ItemStack) {
                        return ItemUtil.itemStackMatchesOredict((ItemStack)((ItemStack)test), (String)((String)obj));
                    }
                    return obj.equals(test);
                }
                if (obj instanceof Block || obj instanceof Item) {
                    return obj == test;
                }
                if (obj instanceof ItemStack && test instanceof ItemStack) {
                    ItemStack i1 = (ItemStack)obj;
                    ItemStack i2 = (ItemStack)test;
                    return i1.func_77973_b() == i2.func_77973_b() && (i1.func_77960_j() == i2.func_77960_j() || i2.func_77960_j() == Short.MAX_VALUE);
                }
                return false;
            }
        }
        ,
        ITEM_PICKUP{

            @Override
            protected Object getObjectFromString(String s) {
                return CRAFTING.getObjectFromString(s);
            }

            @Override
            public boolean matchesObject(Object test, Object ... in) {
                return CRAFTING.matchesObject(test, in);
            }
        }
        ,
        BLOCK_BREAK{

            @Override
            protected Object getObjectFromString(String s) {
                return ItemUtil.parseStringIntoItemStack((String)s);
            }

            @Override
            public boolean matchesObject(Object test, Object ... in) {
                ItemStack block = (ItemStack)test;
                if (in[0] instanceof Block && in[1] instanceof Integer) {
                    return Item.func_150898_a((Block)((Block)in[0])) == block.func_77973_b() && (((Integer)in[1]).intValue() == block.func_77960_j() || block.func_77960_j() == Short.MAX_VALUE);
                }
                return false;
            }
        }
        ,
        ENTITY_KILL{

            @Override
            protected Object getObjectFromString(String s) {
                return s;
            }

            @Override
            public boolean matchesObject(Object test, Object ... in) {
                if (in[0] instanceof EntityLivingBase) {
                    String entityName = (String)EntityList.field_75626_c.get(in[0].getClass());
                    if (entityName != null) {
                        return entityName.toLowerCase().contains(((String)test).toLowerCase());
                    }
                    return in[0].getClass().getName().toLowerCase().contains(((String)test).toLowerCase());
                }
                return false;
            }
        }
        ,
        ACHIEVEMENT_PAGE{

            @Override
            protected Object getObjectFromString(String s) {
                return AchievementPage.getAchievementPage((String)s);
            }

            @Override
            public boolean matchesObject(Object test, Object ... in) {
                if (in[0] == test && in[1] instanceof EntityPlayerMP) {
                    AchievementPage page = (AchievementPage)test;
                    StatisticsFile file = ((EntityPlayerMP)in[1]).func_147099_x();
                    for (Achievement a : page.getAchievements()) {
                        if (file.func_77443_a(a) || a == in[2] || a instanceof Ach && ((Ach)((Ach)a)).parent.achievementSource == this && ((Ach)((Ach)a)).parent.required.equals(page.getName())) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };


        protected abstract Object getObjectFromString(String var1);

        public abstract boolean matchesObject(Object var1, Object ... var2);
    }
}

