/*
 * Decompiled with CFR 0.152.
 */
package tterrag.customthings.common.config;

import com.enderio.core.common.config.JsonConfigReader;
import com.enderio.core.common.util.EnderFileUtils;
import com.enderio.core.common.util.ResourcePackAssembler;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import tterrag.customthings.CustomThings;
import tterrag.customthings.common.compat.CompatUtil;
import tterrag.customthings.common.config.json.AchievementType;
import tterrag.customthings.common.config.json.BlockType;
import tterrag.customthings.common.config.json.IJsonType;
import tterrag.customthings.common.config.json.crafting.ShapedJsonRecipe;
import tterrag.customthings.common.config.json.crafting.ShapelessJsonRecipe;
import tterrag.customthings.common.config.json.crafting.SmeltingJsonRecipe;
import tterrag.customthings.common.config.json.crafting.difficultyrecipes.ShapedJsonDifficultyRecipe;
import tterrag.customthings.common.config.json.crafting.difficultyrecipes.ShapelessJsonDifficultyRecipe;
import tterrag.customthings.common.config.json.items.ArmorType;
import tterrag.customthings.common.config.json.items.ItemType;
import tterrag.customthings.common.config.json.items.RecordType;
import tterrag.customthings.common.config.json.items.ToolType;
import tterrag.difficultyrecipes.util.Difficulty;

public class ConfigHandler {
    public static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public static File baseDir;
    private static JsonConfigReader<ArmorType> armorReader;
    private static JsonConfigReader<ToolType> toolReader;
    private static JsonConfigReader<ItemType> itemReader;
    private static JsonConfigReader<RecordType> recordReader;
    private static JsonConfigReader<BlockType> blockReader;
    private static JsonConfigReader<ShapedJsonRecipe> shapedReader;
    private static JsonConfigReader<ShapelessJsonRecipe> shapelessReader;
    private static JsonConfigReader<SmeltingJsonRecipe> smeltingReader;
    private static JsonConfigReader<AchievementType> achievementReader;
    private static JsonConfigReader<ShapedJsonDifficultyRecipe> shapedDifficultyReader;
    private static JsonConfigReader<ShapelessJsonDifficultyRecipe> shapelessDifficultyReader;
    private static ResourcePackAssembler assembler;
    private static List<IJsonType> allTypesCache;

    public static void preInit(FMLPreInitializationEvent event) {
        baseDir = new File(event.getSuggestedConfigurationFile().getParent() + "/" + "customthings");
        JsonConfigReader.ModToken token = new JsonConfigReader.ModToken(CustomThings.class, "customthings/misc");
        armorReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/customArmors.json", ArmorType.class);
        toolReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/customTools.json", ToolType.class);
        itemReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/customItems.json", ItemType.class);
        recordReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/customRecords.json", RecordType.class);
        blockReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/customBlocks.json", BlockType.class);
        shapedReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/shapedRecipes.json", ShapedJsonRecipe.class);
        shapelessReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/shapelessRecipes.json", ShapelessJsonRecipe.class);
        smeltingReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/smeltingRecipes.json", SmeltingJsonRecipe.class);
        achievementReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/customAchievements.json", AchievementType.class);
        if (CompatUtil.isDifficultyRecipesLoaded()) {
            EnumMapInstanceCreator creatorShaped = new EnumMapInstanceCreator();
            shapedDifficultyReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/difficultyrecipes/shaped.json", ShapedJsonDifficultyRecipe.class);
            shapedDifficultyReader.getBuilder().registerTypeAdapter(new TypeToken<EnumMap<Difficulty, ShapedJsonRecipe>>(){}.getType(), creatorShaped);
            CompatUtil.registerDifficultyAdapter(shapedDifficultyReader.getBuilder());
            EnumMapInstanceCreator creatorShapeless = new EnumMapInstanceCreator();
            shapelessDifficultyReader = new JsonConfigReader(token, baseDir.getAbsolutePath() + "/difficultyrecipes/shapeless.json", ShapelessJsonDifficultyRecipe.class);
            shapelessDifficultyReader.getBuilder().registerTypeAdapter(new TypeToken<EnumMap<Difficulty, ShapelessJsonRecipe>>(){}.getType(), creatorShapeless);
            CompatUtil.registerDifficultyAdapter(shapelessDifficultyReader.getBuilder());
        }
        ConfigHandler.assembleResourcePack();
    }

    public static void assembleResourcePack() {
        File oldFolder = new File(baseDir.getAbsolutePath() + "/CustomThings-Resourcepack");
        FileUtils.deleteDirectory((File)oldFolder);
        assembler = new ResourcePackAssembler(new File(baseDir.getAbsolutePath() + "/CustomThingsResourcepack"), "Custom Things Resource Pack", "customthings");
        ConfigHandler.addIcons(assembler);
        ConfigHandler.addLangs(assembler);
        ConfigHandler.addCustoms(assembler);
        assembler.assemble().inject();
    }

    private static void addIcons(ResourcePackAssembler assembler) {
        ConfigHandler.initialize("icons");
        for (File f : new File(baseDir.getAbsolutePath() + "/icons").listFiles((FileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{(IOFileFilter)EnderFileUtils.pngFilter, FileFilterUtils.suffixFileFilter((String)".mcmeta")}))) {
            assembler.addIcon(f);
        }
    }

    private static void addLangs(ResourcePackAssembler assembler) {
        ConfigHandler.initialize("lang");
        for (File f : new File(baseDir.getAbsolutePath() + "/lang").listFiles(EnderFileUtils.langFilter)) {
            assembler.addLang(f);
        }
    }

    private static void addCustoms(ResourcePackAssembler assembler) {
        ConfigHandler.initialize("recordMusic");
        JsonObject root = new JsonObject();
        for (File f : new File(baseDir.getAbsolutePath() + "/recordMusic").listFiles((FileFilter)FileFilterUtils.suffixFileFilter((String)".ogg"))) {
            assembler.addCustomFile("assets/minecraft/sounds/records", f);
            JsonObject event = new JsonObject();
            event.addProperty("category", "record");
            JsonArray sounds = new JsonArray();
            JsonObject sound = new JsonObject();
            sound.addProperty("name", "records/" + ConfigHandler.getSimpleName(f));
            sound.addProperty("stream", Boolean.valueOf(true));
            sounds.add((JsonElement)sound);
            event.add("sounds", (JsonElement)sounds);
            root.add("records.customthings." + ConfigHandler.getSimpleName(f), (JsonElement)event);
        }
        assembler.addCustomFile("assets/minecraft", EnderFileUtils.writeToFile((String)(baseDir.getAbsolutePath() + "/recordMusic/sounds.json"), (String)gson.toJson((JsonElement)root)));
    }

    private static String getSimpleName(File file) {
        return file.getName().substring(0, file.getName().indexOf(46));
    }

    private static void initialize(String dir) {
        File temp = new File(baseDir.getAbsolutePath() + "/" + dir);
        temp.mkdirs();
    }

    public static void init() {
        ConfigHandler.addAll(armorReader.getElements());
        ConfigHandler.addAll(toolReader.getElements());
        ConfigHandler.addAll(itemReader.getElements());
        ConfigHandler.addAll(recordReader.getElements());
        ConfigHandler.addAll(blockReader.getElements());
        BlockType.registerBlocks();
    }

    public static void postInit() {
        ConfigHandler.addAll(shapedReader.getElements());
        ConfigHandler.addAll(shapelessReader.getElements());
        ConfigHandler.addAll(smeltingReader.getElements());
        ConfigHandler.addAll(achievementReader.getElements());
        if (CompatUtil.isDifficultyRecipesLoaded()) {
            ConfigHandler.addAll(shapedDifficultyReader.getElements());
            ConfigHandler.addAll(shapelessDifficultyReader.getElements());
        }
        for (IJsonType type : allTypesCache) {
            type.postInit();
        }
    }

    private static void addAll(Iterable<? extends IJsonType> types) {
        for (IJsonType iJsonType : types) {
            iJsonType.register();
            allTypesCache.add(iJsonType);
        }
    }

    static {
        allTypesCache = Lists.newArrayList();
    }

    private static class EnumMapInstanceCreator<V extends IJsonType>
    implements InstanceCreator<EnumMap<Difficulty, V>> {
        private EnumMapInstanceCreator() {
        }

        public EnumMap<Difficulty, V> createInstance(Type type) {
            return new EnumMap(Difficulty.class);
        }
    }
}

