/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.questing;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.enums.EnumLogic;
import betterquesting.api.enums.EnumQuestState;
import betterquesting.api.enums.EnumQuestVisibility;
import betterquesting.api.properties.IPropertyType;
import betterquesting.api.properties.NativeProps;
import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.questing.tasks.ITask;
import betterquesting.api.utils.BigItemStack;
import betterquesting.api.utils.NBTConverter;
import betterquesting.api.utils.UuidConverter;
import betterquesting.api2.cache.QuestCache;
import betterquesting.api2.storage.DBEntry;
import betterquesting.api2.storage.IDatabaseNBT;
import betterquesting.api2.utils.DirtyPlayerMarker;
import betterquesting.api2.utils.ParticipantInfo;
import betterquesting.core.BetterQuesting;
import betterquesting.questing.QuestDatabase;
import betterquesting.questing.rewards.RewardStorage;
import betterquesting.questing.tasks.TaskStorage;
import betterquesting.storage.PropertyContainer;
import betterquesting.storage.QuestSettings;
import com.google.common.collect.Maps;
import drethic.questbook.config.QBConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.logging.log4j.Level;

public class QuestInstance
implements IQuest {
    private final TaskStorage tasks = new TaskStorage();
    private final RewardStorage rewards = new RewardStorage();
    private final HashMap<UUID, NBTTagCompound> completeUsers = new HashMap();
    private Set<UUID> preRequisites = new HashSet<UUID>();
    private HashMap<UUID, IQuest.RequirementType> prereqTypes = new HashMap();
    private final PropertyContainer qInfo = new PropertyContainer();

    public QuestInstance() {
        this.setupProps();
    }

    private void setupProps() {
        this.setupValue(NativeProps.NAME, "New Quest");
        this.setupValue(NativeProps.DESC, "No Description");
        this.setupValue(NativeProps.ICON, new BigItemStack(Items.field_151156_bN));
        this.setupValue(NativeProps.SOUND_COMPLETE);
        this.setupValue(NativeProps.SOUND_UPDATE);
        this.setupValue(NativeProps.LOGIC_QUEST, EnumLogic.AND);
        this.setupValue(NativeProps.LOGIC_TASK, EnumLogic.AND);
        this.setupValue(NativeProps.REPEAT_TIME, -1);
        this.setupValue(NativeProps.REPEAT_REL, true);
        this.setupValue(NativeProps.LOCKED_PROGRESS, false);
        this.setupValue(NativeProps.AUTO_CLAIM, false);
        this.setupValue(NativeProps.SILENT, false);
        this.setupValue(NativeProps.MAIN, false);
        this.setupValue(NativeProps.GLOBAL_SHARE, false);
        this.setupValue(NativeProps.SIMULTANEOUS, false);
        this.setupValue(NativeProps.VISIBILITY, EnumQuestVisibility.NORMAL);
    }

    private <T> void setupValue(IPropertyType<T> prop) {
        this.setupValue(prop, prop.getDefault());
    }

    private <T> void setupValue(IPropertyType<T> prop, T def) {
        this.qInfo.setProperty(prop, this.qInfo.getProperty(prop, def));
    }

    @Override
    public void update(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        int done = 0;
        for (DBEntry entry : this.tasks.getEntries()) {
            if (!((ITask)entry.getValue()).isComplete(playerID) && !((ITask)entry.getValue()).ignored(playerID)) continue;
            ++done;
        }
        if (this.tasks.size() <= 0 || this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size())) {
            this.setComplete(playerID, System.currentTimeMillis());
        } else if (done > 0 && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
            this.resetUser(playerID, false);
        }
    }

    @Override
    public void detect(EntityPlayer player) {
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        QuestCache qc = (QuestCache)player.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString());
        if (qc == null) {
            return;
        }
        UUID questID = QuestDatabase.INSTANCE.lookupKey(this);
        if (this.isComplete(playerID) && (this.qInfo.getProperty(NativeProps.REPEAT_TIME) < 0 || this.rewards.size() <= 0)) {
            return;
        }
        if (!this.canSubmit(player)) {
            return;
        }
        if (this.isUnlocked(playerID) || QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
            int done = 0;
            boolean update = false;
            ParticipantInfo partInfo = new ParticipantInfo(player);
            Map.Entry mapEntry = Maps.immutableEntry((Object)questID, (Object)this);
            int numTasks = this.tasks.size();
            for (DBEntry entry : this.tasks.getEntries()) {
                if (!((ITask)entry.getValue()).isComplete(playerID)) {
                    ((ITask)entry.getValue()).detect(partInfo, mapEntry);
                    if (((ITask)entry.getValue()).isComplete(playerID)) {
                        ++done;
                        update = true;
                    }
                } else {
                    ++done;
                }
                if (!((ITask)entry.getValue()).ignored(playerID)) continue;
                --numTasks;
                if (!((ITask)entry.getValue()).isComplete(playerID)) continue;
                --done;
            }
            if (numTasks <= 0 || this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, numTasks)) {
                if (QuestSettings.INSTANCE.getProperty(NativeProps.EDIT_MODE).booleanValue()) {
                    this.setComplete(playerID, System.currentTimeMillis());
                }
                qc.markQuestDirty(questID);
            } else if (update && this.qInfo.getProperty(NativeProps.SIMULTANEOUS).booleanValue()) {
                this.resetUser(playerID, false);
                qc.markQuestDirty(questID);
            } else if (update) {
                qc.markQuestDirty(questID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasClaimed(UUID uuid) {
        if (this.rewards.size() <= 0) {
            return true;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue() && !this.qInfo.getProperty(NativeProps.GLOBAL_SHARE).booleanValue()) {
                for (NBTTagCompound entry : this.completeUsers.values()) {
                    if (!entry.func_74767_n("claimed")) continue;
                    return true;
                }
                return false;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl15 : MonitorExitStatement: MONITOREXIT : var2_2
            NBTTagCompound entry = this.getCompletionInfo(uuid);
            return entry != null && entry.func_74767_n("claimed");
        }
    }

    @Override
    public boolean canClaimBasically(EntityPlayer player) {
        UUID pID = QuestingAPI.getQuestingUUID(player);
        NBTTagCompound entry = this.getCompletionInfo(pID);
        return entry != null && !this.hasClaimed(pID) && !this.canSubmit(player);
    }

    @Override
    public boolean canClaim(EntityPlayer player) {
        if (!this.canClaimBasically(player)) {
            return false;
        }
        Map.Entry mapEntry = Maps.immutableEntry((Object)QuestDatabase.INSTANCE.lookupKey(this), (Object)this);
        for (DBEntry rew : this.rewards.getEntries()) {
            if (((IReward)rew.getValue()).canClaim(player, mapEntry)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void claimReward(EntityPlayer player) {
        UUID questID = QuestDatabase.INSTANCE.lookupKey(this);
        Map.Entry mapEntry = Maps.immutableEntry((Object)questID, (Object)this);
        for (DBEntry rew : this.rewards.getEntries()) {
            ((IReward)rew.getValue()).claimReward(player, mapEntry);
        }
        ParticipantInfo pInfo = new ParticipantInfo(player);
        List<UUID> playersToMark = QBConfig.fullySyncQuests ? pInfo.ALL_UUIDS : Collections.singletonList(pInfo.UUID);
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            for (UUID user : playersToMark) {
                QuestCache qc;
                NBTTagCompound entry = this.getCompletionInfo(user);
                if (entry == null) {
                    entry = new NBTTagCompound();
                }
                entry.func_74757_a("claimed", true);
                entry.func_74772_a("timestamp", System.currentTimeMillis());
                this.completeUsers.put(user, entry);
                DirtyPlayerMarker.markDirty(user);
                EntityPlayerMP dirtyPlayerEntity = QuestingAPI.getPlayer(user);
                if (dirtyPlayerEntity == null || (qc = (QuestCache)dirtyPlayerEntity.getExtendedProperties(QuestCache.LOC_QUEST_CACHE.toString())) == null) continue;
                qc.markQuestDirty(QuestDatabase.INSTANCE.lookupKey(this));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canSubmit(EntityPlayer player) {
        if (player == null) {
            return false;
        }
        UUID playerID = QuestingAPI.getQuestingUUID(player);
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound entry = this.getCompletionInfo(playerID);
            if (entry == null) {
                return true;
            }
            if (!entry.func_74767_n("claimed") && this.getProperty(NativeProps.REPEAT_TIME) >= 0) {
                if (this.tasks.size() <= 0) {
                    return true;
                }
                int done = 0;
                for (DBEntry tsk : this.tasks.getEntries()) {
                    if (!((ITask)tsk.getValue()).isComplete(playerID) && !((ITask)tsk.getValue()).ignored(playerID)) continue;
                    ++done;
                }
                return !this.qInfo.getProperty(NativeProps.LOGIC_TASK).getResult(done, this.tasks.size());
            }
            return false;
        }
    }

    @Override
    public boolean isUnlocked(UUID uuid) {
        if (this.preRequisites.isEmpty()) {
            return true;
        }
        int complete = (int)QuestDatabase.INSTANCE.getAll(this.preRequisites).filter(quest -> quest.isComplete(uuid)).count();
        return this.qInfo.getProperty(NativeProps.LOGIC_QUEST).getResult(complete, this.preRequisites.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setComplete(UUID uuid, long timestamp) {
        if (uuid == null) {
            return;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound entry = this.getCompletionInfo(uuid);
            if (entry == null) {
                entry = new NBTTagCompound();
                this.completeUsers.put(uuid, entry);
            }
            entry.func_74757_a("claimed", false);
            entry.func_74772_a("timestamp", timestamp);
            DirtyPlayerMarker.markDirty(uuid);
        }
    }

    @Override
    public boolean isUnlockable(UUID uuid) {
        if (this.preRequisites.isEmpty()) {
            return true;
        }
        EnumLogic questLogic = this.qInfo.getProperty(NativeProps.LOGIC_QUEST);
        if (questLogic.isTrivial()) {
            return true;
        }
        int complete = (int)QuestDatabase.INSTANCE.getAll(this.preRequisites).filter(quest -> quest.isComplete(uuid)).count();
        return questLogic.isUnlockable(complete, this.preRequisites.size());
    }

    @Override
    public boolean isComplete(UUID uuid) {
        if (this.qInfo.getProperty(NativeProps.GLOBAL).booleanValue()) {
            return this.completeUsers.size() > 0;
        }
        return this.getCompletionInfo(uuid) != null;
    }

    @Override
    public EnumQuestState getState(EntityPlayer player) {
        UUID uuid = QuestingAPI.getQuestingUUID(player);
        if (this.isComplete(uuid)) {
            if (this.canClaimBasically(player)) {
                return EnumQuestState.UNCLAIMED;
            }
            if (this.getProperty(NativeProps.REPEAT_TIME) > -1 && !this.hasClaimed(uuid)) {
                return EnumQuestState.REPEATABLE;
            }
            return EnumQuestState.COMPLETED;
        }
        if (this.isUnlocked(uuid)) {
            return EnumQuestState.UNLOCKED;
        }
        return EnumQuestState.LOCKED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound getCompletionInfo(UUID uuid) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            return this.completeUsers.get(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompletionInfo(UUID uuid, NBTTagCompound nbt) {
        if (uuid == null) {
            return;
        }
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (nbt == null) {
                this.completeUsers.remove(uuid);
            } else {
                this.completeUsers.put(uuid, nbt);
            }
            DirtyPlayerMarker.markDirty(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetUser(@Nullable UUID uuid, boolean fullReset) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            HashSet<UUID> dirtyPlayers = new HashSet<UUID>();
            if (uuid == null) {
                dirtyPlayers.addAll(this.completeUsers.keySet());
            } else {
                dirtyPlayers.add(uuid);
            }
            if (fullReset) {
                if (uuid == null) {
                    this.completeUsers.clear();
                } else {
                    this.completeUsers.remove(uuid);
                }
            } else if (uuid == null) {
                this.completeUsers.forEach((key, value) -> {
                    value.func_74757_a("claimed", false);
                    value.func_74772_a("timestamp", 0L);
                });
            } else {
                NBTTagCompound entry = this.getCompletionInfo(uuid);
                if (entry != null) {
                    entry.func_74757_a("claimed", false);
                    entry.func_74772_a("timestamp", 0L);
                }
            }
            DirtyPlayerMarker.markDirty(dirtyPlayers);
            this.tasks.getEntries().forEach(value -> ((ITask)value.getValue()).resetUser(uuid));
        }
    }

    @Override
    public IDatabaseNBT<ITask, NBTTagList, NBTTagList> getTasks() {
        return this.tasks;
    }

    @Override
    public IDatabaseNBT<IReward, NBTTagList, NBTTagList> getRewards() {
        return this.rewards;
    }

    @Override
    @Nonnull
    public Set<UUID> getRequirements() {
        return this.preRequisites;
    }

    @Override
    public void setRequirements(@Nonnull Iterable<UUID> req) {
        this.preRequisites.clear();
        req.forEach(this.preRequisites::add);
        this.prereqTypes.keySet().removeIf(key -> !this.preRequisites.contains(key));
    }

    @Override
    @Nonnull
    public IQuest.RequirementType getRequirementType(UUID req) {
        IQuest.RequirementType type = this.prereqTypes.get(req);
        return type == null ? IQuest.RequirementType.NORMAL : type;
    }

    @Override
    public void setRequirementType(UUID req, @Nonnull IQuest.RequirementType kind) {
        if (kind == IQuest.RequirementType.NORMAL) {
            this.prereqTypes.remove(req);
        } else {
            this.prereqTypes.put(req, kind);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound jObj) {
        jObj.func_74782_a("properties", (NBTBase)this.qInfo.writeToNBT(new NBTTagCompound()));
        jObj.func_74782_a("tasks", (NBTBase)this.tasks.writeToNBT(new NBTTagList(), (List<Integer>)null));
        jObj.func_74782_a("rewards", (NBTBase)this.rewards.writeToNBT(new NBTTagList(), (List<Integer>)null));
        NBTTagList tagList = new NBTTagList();
        for (UUID questID : this.preRequisites) {
            NBTTagCompound tag = NBTConverter.UuidValueType.QUEST.writeId(questID);
            if (this.prereqTypes.containsKey(questID)) {
                tag.func_74774_a("type", this.prereqTypes.get(questID).id());
            }
            tagList.func_74742_a((NBTBase)tag);
        }
        jObj.func_74782_a("preRequisites", (NBTBase)tagList);
        return jObj;
    }

    @Override
    public void readFromNBT(NBTTagCompound jObj) {
        this.qInfo.readFromNBT(jObj.func_74775_l("properties"));
        this.tasks.readFromNBT(jObj.func_150295_c("tasks", 10), false);
        this.rewards.readFromNBT(jObj.func_150295_c("rewards", 10), false);
        HashMap<Integer, UUID> legacyPrerequisiteIndex = new HashMap<Integer, UUID>();
        if (jObj.func_150299_b("preRequisites") == 9) {
            this.preRequisites = new HashSet<UUID>();
            List<NBTBase> tagList = NBTConverter.getTagList(jObj.func_150295_c("preRequisites", 10));
            for (NBTBase tag : tagList) {
                NBTTagCompound tagCompound;
                Optional<UUID> questIDOptional;
                if (!(tag instanceof NBTTagCompound) || !(questIDOptional = NBTConverter.UuidValueType.QUEST.tryReadId(tagCompound = (NBTTagCompound)tag)).isPresent()) continue;
                UUID questID = questIDOptional.get();
                this.preRequisites.add(questID);
                if (!tagCompound.func_150297_b("type", 99)) continue;
                this.setRequirementType(questID, IQuest.RequirementType.from(tagCompound.func_74771_c("type")));
            }
        } else if (jObj.func_150299_b("preRequisites") == 11) {
            this.preRequisites = new HashSet<UUID>();
            int[] intArray = jObj.func_74759_k("preRequisites");
            for (int i = 0; i < intArray.length; ++i) {
                UUID questID = UuidConverter.convertLegacyId(intArray[i]);
                this.preRequisites.add(questID);
                legacyPrerequisiteIndex.put(i, questID);
            }
        }
        if (jObj.func_150299_b("preRequisiteTypes") == 7) {
            byte[] byteArray = jObj.func_74770_j("preRequisiteTypes");
            int byteArrayLength = byteArray.length;
            for (int i = 0; i < byteArrayLength; ++i) {
                UUID questID = (UUID)legacyPrerequisiteIndex.get(i);
                if (questID == null) continue;
                this.setRequirementType(questID, IQuest.RequirementType.from(byteArray[i]));
            }
        }
        this.setupProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound writeProgressToNBT(NBTTagCompound json, @Nullable List<UUID> users) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagList comJson = new NBTTagList();
            for (Map.Entry<UUID, NBTTagCompound> entry : this.completeUsers.entrySet()) {
                if (entry.getValue() == null || entry.getKey() == null || users != null && !users.contains(entry.getKey())) continue;
                NBTTagCompound tags = (NBTTagCompound)entry.getValue().func_74737_b();
                tags.func_74778_a("uuid", entry.getKey().toString());
                comJson.func_74742_a((NBTBase)tags);
            }
            json.func_74782_a("completed", (NBTBase)comJson);
            NBTTagList tskJson = this.tasks.writeProgressToNBT(new NBTTagList(), users);
            json.func_74782_a("tasks", (NBTBase)tskJson);
            return json;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readProgressFromNBT(NBTTagCompound json, boolean merge) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            if (!merge) {
                this.completeUsers.clear();
            }
            NBTTagList comList = json.func_150295_c("completed", 10);
            for (int i = 0; i < comList.func_74745_c(); ++i) {
                NBTTagCompound entry = (NBTTagCompound)comList.func_150305_b(i).func_74737_b();
                try {
                    UUID uuid = UUID.fromString(entry.func_74779_i("uuid"));
                    this.completeUsers.put(uuid, entry);
                    continue;
                }
                catch (Exception e) {
                    BetterQuesting.logger.log(Level.ERROR, "Unable to load UUID for quest", (Throwable)e);
                }
            }
            this.tasks.readProgressFromNBT(json.func_150295_c("tasks", 10), merge);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClaimed(UUID uuid, long timestamp) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            NBTTagCompound entry = this.getCompletionInfo(uuid);
            if (entry != null) {
                entry.func_74757_a("claimed", true);
                entry.func_74772_a("timestamp", timestamp);
            } else {
                entry = new NBTTagCompound();
                entry.func_74757_a("claimed", true);
                entry.func_74772_a("timestamp", timestamp);
                this.completeUsers.put(uuid, entry);
            }
            DirtyPlayerMarker.markDirty(uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getUsersWithCompletionData(Set<UUID> targetSet) {
        HashMap<UUID, NBTTagCompound> hashMap = this.completeUsers;
        synchronized (hashMap) {
            targetSet.addAll(this.completeUsers.keySet());
        }
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop) {
        return this.qInfo.getProperty(prop);
    }

    @Override
    public <T> T getProperty(IPropertyType<T> prop, T def) {
        return this.qInfo.getProperty(prop, def);
    }

    @Override
    public boolean hasProperty(IPropertyType<?> prop) {
        return this.qInfo.hasProperty(prop);
    }

    @Override
    public <T> void setProperty(IPropertyType<T> prop, T value) {
        this.qInfo.setProperty(prop, value);
    }

    @Override
    public void removeProperty(IPropertyType<?> prop) {
        this.qInfo.removeProperty(prop);
    }

    @Override
    public void removeAllProps() {
        this.qInfo.removeAllProps();
    }
}

