/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.handlers;

import betterquesting.api.storage.BQ_Settings;
import betterquesting.core.BetterQuesting;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    public static Configuration config;

    public static void initConfigs() {
        if (config == null) {
            BetterQuesting.logger.log(Level.ERROR, "Config attempted to be loaded before it was initialised!");
            return;
        }
        config.load();
        BQ_Settings.questNotices = config.getBoolean("Quest Notices", "general", true, "Enabled the popup notices when quests are completed or updated");
        BQ_Settings.curTheme = config.getString("Theme", "general", "betterquesting:light", "The current questing theme");
        BQ_Settings.useBookmark = config.getBoolean("Use Quest Bookmark", "general", true, "Jumps the user to the last opened quest");
        BQ_Settings.guiWidth = config.getInt("Max GUI Width", "general", -1, -1, Integer.MAX_VALUE, "Clamps the max UI width (-1 to disable)");
        BQ_Settings.guiHeight = config.getInt("Max GUI Height", "general", -1, -1, Integer.MAX_VALUE, "Clamps the max UI height (-1 to disable)");
        BQ_Settings.textWidthCorrection = config.getFloat("Text Width Correction", "general", 1.0f, 0.01f, 10.0f, "Correcting the width of split text");
        BQ_Settings.scrollMultiplier = config.getFloat("Scroll multiplier", "general", 1.0f, 0.0f, 10.0f, "Scrolling multiplier");
        BQ_Settings.zoomSpeed = config.getFloat("Zoom Speed", "general", 1.25f, 1.05f, 3.0f, "Zoom Speed");
        BQ_Settings.zoomTimeInMs = config.getFloat("Zoom smoothness in ms", "general", 100.0f, 0.0f, 2000.0f, "Zoom smoothness in ms");
        BQ_Settings.zoomInToCursor = config.getBoolean("Zoom in on cursor", "general", true, "Zoom in on cursor. If false, zooms in on center of screen.");
        BQ_Settings.zoomOutToCursor = config.getBoolean("Zoom out on cursor", "general", true, "Zoom out on cursor. If false, zooms out on center of screen.");
        BQ_Settings.claimAllConfirmation = config.getBoolean("Claim all requires confirmation", "general", true, "If true, then when you click on Claim all, a warning dialog will be displayed");
        BQ_Settings.skipHome = config.getBoolean("Skip home", "general", false, "If true will skip home gui and open quests at startup. This property will be changed by the mod itself.");
        BQ_Settings.lockTray = config.getBoolean("Lock tray", "general", false, "Is quest chapters list locked and opened on start.");
        BQ_Settings.viewMode = config.getBoolean("View mode", "general", false, "If true, user can view not-yet-unlocked quests that are not hidden or secret. This property can be changed by the GUI.");
        BQ_Settings.viewModeAllQuestLine = config.getBoolean("View mode all quest line", "general", true, "If true, view mode will display the quest line regardless of whether the quest line is unlocked yet.");
        BQ_Settings.viewModeBtn = config.getBoolean("View mode button", "general", false, "If true, show view mode button.");
        BQ_Settings.alwaysDrawImplicit = config.getBoolean("Always draw implicit dependency", "general", false, "If true, always draw implicit dependency. This property can be changed by the GUI");
        BQ_Settings.urlDebug = config.getBoolean("Highlight detected clickable url hotzone.", "general", false, "If true, render each hotzone using alternating color.");
        BQ_Settings.loadDefaultsOnStartup = config.getBoolean("Load the default quest DB on world startup.", "general", true, "Does an equivalent of '/bq_admin default load' on every world load");
        BQ_Settings.unrestrictAdminCommands = config.getBoolean("Unrestrict Admin Commands", "general", false, "If true, all users can use /bq_admin commands regardless of op-status. Useful for single-player without cheats.");
        BQ_Settings.logNullQuests = config.getBoolean("Log null quests", "general", true, "Posts useful information in the log when encountering a null quest during loading.");
        BQ_Settings.noRewards = config.getBoolean("Disable rewards", "general", false, "If true, rewards will be disabled. This might not be supported by reward types.");
        config.save();
    }
}

