/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.commands.admin;

import betterquesting.api.api.QuestingAPI;
import betterquesting.api.properties.NativeProps;
import betterquesting.commands.QuestCommandBase;
import betterquesting.network.handlers.NetLifeSync;
import betterquesting.storage.LifeDatabase;
import betterquesting.storage.NameCache;
import betterquesting.storage.QuestSettings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;

public class QuestCommandLives
extends QuestCommandBase {
    @Override
    public String getCommand() {
        return "lives";
    }

    @Override
    public String getUsageSuffix() {
        return "[add|set|max|default] <value> [username|uuid]";
    }

    @Override
    public boolean validArgs(String[] args) {
        return args.length == 4 || args.length == 3;
    }

    @Override
    public List<String> autoComplete(MinecraftServer server, ICommandSender sender, String[] args) {
        ArrayList<String> list = new ArrayList<String>();
        if (args.length == 4 && (args[1].equalsIgnoreCase("add") || args[1].equalsIgnoreCase("set"))) {
            return CommandBase.func_71530_a((String[])args, (String[])NameCache.INSTANCE.getAllNames().toArray(new String[0]));
        }
        if (args.length == 2) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "set", "max", "default"});
        }
        return list;
    }

    @Override
    public void runCommand(MinecraftServer server, CommandBase command, ICommandSender sender, String[] args) {
        String pName;
        int value;
        String action = args[1];
        UUID playerID = null;
        try {
            value = Integer.parseInt(args[2]);
        }
        catch (Exception e) {
            throw this.getException(command);
        }
        if (args.length >= 4 && (playerID = this.findPlayerID(server, sender, args[3])) == null) {
            throw this.getException(command);
        }
        String string = pName = playerID == null ? "NULL" : NameCache.INSTANCE.getName(playerID);
        if (action.equalsIgnoreCase("set")) {
            value = Math.max(1, value);
            if (playerID != null) {
                LifeDatabase.INSTANCE.setLives(playerID, value);
                EntityPlayerMP target = null;
                for (EntityPlayerMP p : server.func_71203_ab().field_72404_b) {
                    if (!p.func_146103_bH().getId().equals(playerID)) continue;
                    target = p;
                    break;
                }
                if (target != null) {
                    NetLifeSync.sendSync(new EntityPlayerMP[]{target}, new UUID[]{playerID});
                }
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.set_player", new Object[]{pName, value}));
            } else {
                for (EntityPlayerMP p : server.func_71203_ab().field_72404_b) {
                    UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)p);
                    LifeDatabase.INSTANCE.setLives(uuid, value);
                    NetLifeSync.sendSync(new EntityPlayerMP[]{p}, new UUID[]{uuid});
                }
                sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.set_all", new Object[]{value}));
            }
        } else if (action.equalsIgnoreCase("add")) {
            if (playerID != null) {
                int lives = LifeDatabase.INSTANCE.getLives(playerID) + value;
                LifeDatabase.INSTANCE.setLives(playerID, lives);
                EntityPlayerMP target = null;
                for (EntityPlayerMP p : server.func_71203_ab().field_72404_b) {
                    if (!p.func_146103_bH().getId().equals(playerID)) continue;
                    target = p;
                    break;
                }
                if (target != null) {
                    NetLifeSync.sendSync(new EntityPlayerMP[]{target}, new UUID[]{playerID});
                }
                if (value >= 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.add_player", new Object[]{value, pName, lives}));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.remove_player", new Object[]{Math.abs(value), pName, lives}));
                }
            } else {
                for (EntityPlayerMP p : server.func_71203_ab().field_72404_b) {
                    UUID uuid = QuestingAPI.getQuestingUUID((EntityPlayer)p);
                    int lives = LifeDatabase.INSTANCE.getLives(uuid);
                    LifeDatabase.INSTANCE.setLives(uuid, lives + value);
                    NetLifeSync.sendSync(new EntityPlayerMP[]{p}, new UUID[]{uuid});
                }
                if (value >= 0) {
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.add_all", new Object[]{value}));
                } else {
                    sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.remove_all", new Object[]{Math.abs(value)}));
                }
            }
        } else if (action.equalsIgnoreCase("max")) {
            value = Math.max(1, value);
            QuestSettings.INSTANCE.setProperty(NativeProps.LIVES_MAX, value);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.max", new Object[]{value}));
        } else if (action.equalsIgnoreCase("default")) {
            value = Math.max(1, value);
            QuestSettings.INSTANCE.setProperty(NativeProps.LIVES_DEF, value);
            sender.func_145747_a((IChatComponent)new ChatComponentTranslation("betterquesting.cmd.lives.default" + value, new Object[0]));
        } else {
            throw this.getException(command);
        }
    }

    @Override
    public boolean isArgUsername(String[] args, int index) {
        return index == 3;
    }
}

