/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.client.gui2.editors;

import betterquesting.api.client.gui.misc.IVolatileScreen;
import betterquesting.api.misc.ICallback;
import betterquesting.api2.client.gui.GuiScreenCanvas;
import betterquesting.api2.client.gui.controls.IPanelButton;
import betterquesting.api2.client.gui.controls.PanelButton;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.controls.PanelTextField;
import betterquesting.api2.client.gui.controls.filters.FieldFilterString;
import betterquesting.api2.client.gui.events.IPEventListener;
import betterquesting.api2.client.gui.events.PEventBroadcaster;
import betterquesting.api2.client.gui.events.PanelEvent;
import betterquesting.api2.client.gui.events.types.PEventButton;
import betterquesting.api2.client.gui.misc.GuiAlign;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.GuiRectangle;
import betterquesting.api2.client.gui.misc.GuiTransform;
import betterquesting.api2.client.gui.panels.CanvasTextured;
import betterquesting.api2.client.gui.panels.bars.PanelVScrollBar;
import betterquesting.api2.client.gui.panels.content.PanelTextBox;
import betterquesting.api2.client.gui.panels.lists.CanvasScrolling;
import betterquesting.api2.client.gui.popups.PopWaitExternalEvent;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import betterquesting.api2.utils.QuestTranslation;
import betterquesting.core.BetterQuesting;
import betterquesting.misc.QuestResourcesFile;
import betterquesting.misc.QuestResourcesFolder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;

public class GuiTextEditor
extends GuiScreenCanvas
implements IPEventListener,
IVolatileScreen {
    private final ICallback<String> callback;
    private final boolean imageSupport;
    private final String textIn;
    private PanelTextField<String> flText;

    public GuiTextEditor(GuiScreen parent, String text, ICallback<String> callback) {
        this(parent, text, false, callback);
    }

    public GuiTextEditor(GuiScreen parent, String text, boolean imageSupport, ICallback<String> callback) {
        super(parent);
        this.textIn = text;
        this.callback = callback;
        this.imageSupport = imageSupport;
    }

    @Override
    public void initPanel() {
        super.initPanel();
        PEventBroadcaster.INSTANCE.register(this, PEventButton.class);
        Keyboard.enableRepeatEvents((boolean)true);
        CanvasTextured cvBackground = new CanvasTextured(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(0, 0, 0, 0), 0), PresetTexture.PANEL_MAIN.getTexture());
        this.addPanel(cvBackground);
        cvBackground.addPanel(new PanelButton(new GuiTransform(GuiAlign.BOTTOM_CENTER, -100, -16, 200, 16, 0), 0, QuestTranslation.translate("gui.back", new Object[0])));
        PanelTextBox txTitle = new PanelTextBox(new GuiTransform(GuiAlign.TOP_EDGE, new GuiPadding(0, 16, 0, -32), 0), QuestTranslation.translate("betterquesting.title.edit_text", new Object[0])).setAlignment(1);
        txTitle.setColor(PresetColor.TEXT_HEADER.getColor());
        cvBackground.addPanel(txTitle);
        this.flText = new PanelTextField<String>(new GuiTransform(GuiAlign.FULL_BOX, new GuiPadding(124, 32, 24, 32), 0), this.flText != null ? this.flText.getRawText() : this.textIn, FieldFilterString.INSTANCE);
        cvBackground.addPanel(this.flText);
        this.flText.setMaxLength(Integer.MAX_VALUE);
        this.flText.enableWrapping(true);
        this.flText.lockFocus(true);
        CanvasScrolling cvFormatList = new CanvasScrolling(new GuiTransform(GuiAlign.LEFT_EDGE, new GuiPadding(16, 32, -116, 32), 0));
        cvBackground.addPanel(cvFormatList);
        EnumChatFormatting[] tfValues = EnumChatFormatting.values();
        int macroCount = 0;
        if (this.imageSupport) {
            cvFormatList.addPanel(new PanelButton(new GuiRectangle(0, 16 * macroCount++, 100, 16), 3, "\u00a72\u00a7nSelect Image\u00a7r"));
            cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, 16 * macroCount++, 100, 16), 2, "\u00a72\u00a7n Image\u00a7r", "[img height=100] [/img]"));
        }
        cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, 16 * macroCount++, 100, 16), 2, "\u00a79\u00a7nHyperlink\u00a7r", "[url] [/url]"));
        cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, 16 * macroCount++, 100, 16), 2, "\u00a74\u00a7lWarning\u00a7r", "[warn] [/warn]"));
        cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, 16 * macroCount++, 100, 16), 2, "\u00a73Note\u00a7r", "[note] [/note]"));
        cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, 16 * macroCount++, 100, 16), 2, "\u00a72\u00a7nQuest Title\u00a7r", "[quest] [/quest]"));
        for (int i = 0; i < tfValues.length; ++i) {
            cvFormatList.addPanel(new PanelButtonStorage<String>(new GuiRectangle(0, (i + macroCount) * 16, 100, 16), 1, tfValues[i].func_96297_d(), tfValues[i].toString()));
        }
        PanelVScrollBar scFormatScroll = new PanelVScrollBar(new GuiTransform(GuiAlign.RIGHT_EDGE, new GuiPadding(0, 0, -8, 0), 0));
        cvBackground.addPanel(scFormatScroll);
        scFormatScroll.getTransform().setParent(cvFormatList.getTransform());
        cvFormatList.setScrollDriverY(scFormatScroll);
        scFormatScroll.setActive(cvFormatList.getScrollBounds().getHeight() > 0);
    }

    @Override
    public void onPanelEvent(PanelEvent event) {
        if (event instanceof PEventButton) {
            this.onButtonPress((PEventButton)event);
        }
    }

    private void onButtonPress(PEventButton event) {
        IPanelButton btn = event.getButton();
        if (btn.getButtonID() == 0) {
            this.field_146297_k.func_147108_a(this.parent);
        } else if (btn.getButtonID() == 1 && btn instanceof PanelButtonStorage) {
            String format = (String)((PanelButtonStorage)btn).getStoredValue();
            this.flText.writeText(format);
        } else if (btn.getButtonID() == 2 && btn instanceof PanelButtonStorage) {
            String[] tagPair = ((String)((PanelButtonStorage)btn).getStoredValue()).split(" ");
            String format = tagPair[0] + this.flText.getSelectedText() + tagPair[1];
            this.flText.writeText(format);
        } else if (btn.getButtonID() == 3) {
            PopWaitExternalEvent<String> popup = new PopWaitExternalEvent<String>(I18n.func_135052_a((String)"betterquesting.title.choose_image_swing", (Object[])new Object[0])){

                @Override
                protected void handleComplete() {
                    try {
                        super.handleComplete();
                    }
                    finally {
                        GuiTextEditor.this.setNoEscape(false);
                    }
                }

                @Override
                protected void onComplete(String resourceLoc) {
                    String domain = resourceLoc.substring(0, resourceLoc.lastIndexOf(58));
                    if (!QuestResourcesFolder.lastResourceDomains.contains(domain)) {
                        GuiTextEditor.this.field_146297_k.func_110436_a();
                    }
                    GuiTextEditor.this.writeImageTag(resourceLoc);
                }
            };
            this.setNoEscape(true);
            this.openPopup(popup);
            SwingUtilities.invokeLater(() -> {
                try {
                    GuiTextEditor.selectImage(popup);
                }
                finally {
                    popup.ensureDone();
                }
            });
        }
    }

    private void writeImageTag(String resourceLoc) {
        String prefix = "[img height=";
        String tag = "[img height=]" + resourceLoc + "[/img]";
        this.flText.writeText(tag);
        this.flText.moveCursorBy("[img height=".length() - tag.length());
    }

    private static void selectImage(PopWaitExternalEvent<String> popup) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(new FileNameExtensionFilter(I18n.func_135052_a((String)"betterquesting.tooltip.image_file_type", (Object[])new Object[0]), "png"));
        File src = null;
        File dst = null;
        File targetRoot = QuestResourcesFile.rootFolder.getAbsoluteFile();
        chooser.setCurrentDirectory(targetRoot);
        while (true) {
            int r;
            if (src == null) {
                chooser.setDialogTitle(I18n.func_135052_a((String)"betterquesting.title.choose_image.src", (Object[])new Object[0]));
                r = chooser.showOpenDialog(null);
                if (r != 0) {
                    popup.cancel();
                    return;
                }
                src = chooser.getSelectedFile().getAbsoluteFile();
                if (GuiTextEditor.isParent(targetRoot, src) && !src.getParentFile().equals(targetRoot)) {
                    popup.complete(GuiTextEditor.getResourceLocation(targetRoot, src));
                    return;
                }
            }
            chooser.setDialogTitle(I18n.func_135052_a((String)"betterquesting.title.choose_image.dst", (Object[])new Object[0]));
            chooser.setCurrentDirectory(QuestResourcesFile.rootFolder);
            chooser.setSelectedFile(new File(targetRoot, src.getName()).getAbsoluteFile());
            r = chooser.showSaveDialog(null);
            if (r != 0) {
                popup.cancel();
                return;
            }
            dst = chooser.getSelectedFile().getAbsoluteFile();
            if (!GuiTextEditor.isParent(targetRoot, dst) || dst.getParentFile().equals(targetRoot)) {
                JOptionPane.showMessageDialog(null, I18n.func_135052_a((String)"betterquesting.gui.not_correct_dir", (Object[])new Object[]{QuestResourcesFile.rootFolder.getAbsolutePath()}), "Error", 0);
                continue;
            }
            if (!dst.exists() || JOptionPane.showConfirmDialog(null, I18n.func_135052_a((String)"betterquesting.gui.overwrite_file", (Object[])new Object[0]), "Confirm", 0, 3) == 0) break;
        }
        popup.setMessage("Copying image file...");
        try {
            Path target = dst.toPath();
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(src.toPath(), target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.getLocalizedMessage(), "IO Error", 0);
            BetterQuesting.logger.error("Copying image file failed", (Throwable)e);
            return;
        }
        popup.complete(GuiTextEditor.getResourceLocation(targetRoot, dst));
    }

    private static String getResourceLocation(File targetRoot, File dst) {
        Path relative = targetRoot.toPath().relativize(dst.toPath());
        return relative.toString().replace('\\', '/').replaceFirst("/", ":");
    }

    private static boolean isParent(File parent, File child) {
        while (!parent.equals(child)) {
            File curParent = child.getParentFile();
            if (curParent == null || curParent.equals(child)) {
                return false;
            }
            child = curParent;
        }
        return true;
    }

    @Override
    public void func_146281_b() {
        super.func_146281_b();
        if (this.callback != null) {
            this.callback.setValue(this.flText.getRawText());
        }
    }
}

