/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.util;

import appeng.api.storage.data.IAEFluidStack;
import appeng.util.Platform;
import appeng.util.item.AEFluidStack;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class Util {
    private static int randTickSeed = 0;

    public static int findItemStack(EntityPlayer player, ItemStack itemStack) {
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || !Platform.isSameItemPrecise((ItemStack)item, (ItemStack)itemStack)) continue;
            return x;
        }
        return -1;
    }

    public static long genSingularityFreq() {
        long freq = new Date().getTime() * 100L + (long)(randTickSeed % 100);
        ++randTickSeed;
        return freq;
    }

    public static FluidStack getFluidFromItem(ItemStack stack) {
        if (stack != null) {
            FluidStack fluid;
            if (stack.func_77973_b() instanceof IFluidContainerItem && (fluid = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack)) != null) {
                FluidStack fluid0 = fluid.copy();
                fluid0.amount *= stack.field_77994_a;
                return fluid0;
            }
            if (FluidContainerRegistry.isContainer((ItemStack)stack) && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null) {
                FluidStack fluid0 = fluid.copy();
                fluid0.amount *= stack.field_77994_a;
                return fluid0;
            }
        }
        return null;
    }

    public static IAEFluidStack loadFluidStackFromNBT(NBTTagCompound i) {
        FluidStack t = FluidRegistry.getFluidStack((String)i.func_74779_i("FluidName"), (int)1);
        if (t == null) {
            return null;
        }
        AEFluidStack fluid = AEFluidStack.create((Object)t);
        fluid.setStackSize(i.func_74763_f("Cnt"));
        fluid.setCountRequestable(i.func_74763_f("Req"));
        fluid.setCraftable(i.func_74767_n("Craft"));
        return fluid;
    }

    public static List<Integer> getBackpackSlot(EntityPlayer player) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int x = 0; x < player.field_71071_by.field_70462_a.length; ++x) {
            ItemStack item = player.field_71071_by.field_70462_a[x];
            if (item == null || item.func_77973_b() == null || !AE2ThingAPI.instance().isBackpackItem(item)) continue;
            result.add(x);
        }
        return result;
    }

    public static void writeItemStackToNBT(ItemStack itemStack, NBTTagCompound tag) {
        itemStack.func_77955_b(tag);
        tag.func_74768_a("count", itemStack.field_77994_a);
    }

    public static ItemStack loadItemStackFromNBT(NBTTagCompound tag) {
        ItemStack itemStack = ItemStack.func_77949_a((NBTTagCompound)tag);
        if (itemStack == null) {
            return null;
        }
        itemStack.field_77994_a = tag.func_74762_e("count");
        return itemStack;
    }
}

