/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.network;

import appeng.api.storage.data.IAEStack;
import appeng.core.AELog;
import appeng.util.item.AEFluidStack;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.network.SPacketMEItemInvUpdate;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;

public abstract class SPacketMEBaseInvUpdate
implements IMessage {
    protected static final int UNCOMPRESSED_PACKET_BYTE_LIMIT = 0x1000000;
    protected static final int OPERATION_BYTE_LIMIT = 2048;
    protected static final int TEMP_BUFFER_SIZE = 1024;
    protected static final int STREAM_MASK = 255;
    @Nullable
    protected GZIPOutputStream compressFrame;
    protected int writtenBytes = 0;
    protected final ByteBuf data = Unpooled.buffer((int)2048);
    protected byte ref = 0;
    protected final List<IAEStack<?>> list = new ArrayList();

    public SPacketMEBaseInvUpdate() {
    }

    public SPacketMEBaseInvUpdate(byte b) {
        this.setRef(b);
    }

    protected void compress() throws IOException, BufferOverflowException {
        for (IAEStack<?> is : this.getList()) {
            ByteBuf tmp = Unpooled.buffer((int)2048);
            is.writeToPacket(tmp);
            assert (this.compressFrame != null);
            this.compressFrame.flush();
            if (this.writtenBytes + tmp.readableBytes() > 0x1000000) {
                throw new BufferOverflowException();
            }
            this.writtenBytes += tmp.readableBytes();
            this.compressFrame.write(tmp.array(), 0, tmp.readableBytes());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.getRef());
        try {
            this.compressFrame = new GZIPOutputStream(new OutputStream(){

                @Override
                public void write(int value) {
                    SPacketMEBaseInvUpdate.this.data.writeByte(value);
                }
            });
            this.compress();
            this.compressFrame.finish();
            buf.writeBytes(this.data);
            this.compressFrame.close();
        }
        catch (IOException io) {
            AELog.error((Throwable)io);
        }
    }

    public void fromBytes(final ByteBuf buf) {
        this.ref = buf.readByte();
        try {
            GZIPInputStream gzReader = new GZIPInputStream(new InputStream(){

                @Override
                public int read() {
                    if (buf.readableBytes() <= 0) {
                        return -1;
                    }
                    return buf.readByte() & 0xFF;
                }
            });
            ByteBuf uncompressed = Unpooled.buffer((int)buf.readableBytes());
            byte[] tmp = new byte[1024];
            while (gzReader.available() != 0) {
                int bytes = gzReader.read(tmp);
                if (bytes <= 0) continue;
                uncompressed.writeBytes(tmp, 0, bytes);
            }
            gzReader.close();
            while (uncompressed.readableBytes() > 0) {
                if (this instanceof SPacketMEItemInvUpdate) {
                    this.getList().add((IAEStack<?>)AEItemStack.loadItemStackFromPacket((ByteBuf)uncompressed));
                    continue;
                }
                this.getList().add((IAEStack<?>)AEFluidStack.loadFluidStackFromPacket((ByteBuf)uncompressed));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public List<IAEStack<?>> getList() {
        return this.list;
    }

    public byte getRef() {
        return this.ref;
    }

    public void setRef(byte ref) {
        this.ref = ref;
    }
}

