/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.storage.StorageChannel;
import com.asdflj.ae2thing.api.AE2ThingAPI;
import com.asdflj.ae2thing.common.storage.DataStorage;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.WorldSavedData;

public class StorageManager
extends WorldSavedData {
    private Map<UUID, DataStorage> disks = new HashMap<UUID, DataStorage>();

    public StorageManager(String name) {
        super(name);
        this.func_76186_a(true);
        AE2ThingAPI.instance().setStorageManager(this);
    }

    public DataStorage getStorage(String uuid, StorageChannel channel) {
        UUID uid;
        try {
            uid = UUID.fromString(uuid);
        }
        catch (Exception ignored) {
            while (this.disks.get(uid = UUID.randomUUID()) != null) {
            }
        }
        DataStorage d = this.disks.get(uid);
        if (d == null) {
            d = new DataStorage(uid, channel);
            this.disks.put(uid, d);
        }
        return d;
    }

    public void func_76184_a(NBTTagCompound data) {
        HashMap<UUID, DataStorage> d = new HashMap<UUID, DataStorage>();
        NBTTagList diskList = data.func_150295_c("disklist", 10);
        for (int i = 0; i < diskList.func_74745_c(); ++i) {
            NBTTagCompound disk = diskList.func_150305_b(i);
            UUID uid = UUID.fromString(disk.func_74779_i("diskuuid"));
            d.put(uid, DataStorage.readFromNBT(uid, disk.func_150295_c("diskdata", 10), StorageChannel.ITEMS));
        }
        NBTTagList fluidDiskList = data.func_150295_c("fluid_disklist", 10);
        for (int i = 0; i < fluidDiskList.func_74745_c(); ++i) {
            NBTTagCompound disk = fluidDiskList.func_150305_b(i);
            UUID uid = UUID.fromString(disk.func_74779_i("diskuuid"));
            d.put(uid, DataStorage.readFromNBT(uid, disk.func_150295_c("fluid_disklist", 10), StorageChannel.FLUIDS));
        }
        this.disks = d;
    }

    public void func_76187_b(NBTTagCompound data) {
        NBTTagList diskList = new NBTTagList();
        NBTTagList fluidDiskList = new NBTTagList();
        for (Map.Entry<UUID, DataStorage> entry : this.disks.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            NBTTagCompound disk = new NBTTagCompound();
            disk.func_74778_a("diskuuid", entry.getKey().toString());
            if (entry.getValue().getChannel() == StorageChannel.ITEMS) {
                disk.func_74782_a("diskdata", entry.getValue().writeToNBT());
                diskList.func_74742_a((NBTBase)disk);
                continue;
            }
            disk.func_74782_a("fluid_disklist", entry.getValue().writeToNBT());
            fluidDiskList.func_74742_a((NBTBase)disk);
        }
        data.func_74782_a("disklist", (NBTBase)diskList);
        data.func_74782_a("fluid_disklist", (NBTBase)fluidDiskList);
    }
}

