/*
 * Decompiled with CFR 0.152.
 */
package com.asdflj.ae2thing.common.storage;

import appeng.api.AEApi;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import com.asdflj.ae2thing.common.storage.IDataStorage;
import com.asdflj.ae2thing.util.Util;
import java.util.UUID;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class DataStorage
implements IDataStorage {
    private final IItemList<IAEItemStack> items = AEApi.instance().storage().createItemList();
    private final IItemList<IAEFluidStack> fluids = AEApi.instance().storage().createFluidList();
    private final UUID uuid;
    private final StorageChannel channel;

    public DataStorage(UUID uuid, StorageChannel channel) {
        this.uuid = uuid;
        this.channel = channel;
    }

    @Override
    public StorageChannel getChannel() {
        return this.channel;
    }

    @Override
    public IItemList<IAEItemStack> getItems() {
        return this.items;
    }

    @Override
    public IItemList<IAEFluidStack> getFluids() {
        return this.fluids;
    }

    @Override
    public boolean isEmpty() {
        if (this.channel == StorageChannel.ITEMS) {
            return this.items.isEmpty();
        }
        return this.fluids.isEmpty();
    }

    @Override
    public String getUUID() {
        return this.uuid.toString();
    }

    public static DataStorage readFromNBT(UUID uuid, NBTTagList data) {
        return DataStorage.readFromNBT(uuid, data, StorageChannel.ITEMS);
    }

    public static DataStorage readFromNBT(UUID uuid, NBTTagList data, StorageChannel channel) {
        DataStorage storage = new DataStorage(uuid, channel);
        storage.readFromNBT(data);
        return storage;
    }

    @Override
    public void readFromNBT(NBTTagList data) {
        if (this.channel == StorageChannel.ITEMS) {
            for (IAEItemStack ais : this.readList(data)) {
                this.items.add((IAEStack)ais);
            }
        } else {
            for (IAEFluidStack ais : this.readFluidList(data)) {
                this.fluids.add((IAEStack)ais);
            }
        }
    }

    private IItemList<IAEFluidStack> readFluidList(NBTTagList tag) {
        IItemList out = AEApi.instance().storage().createFluidList();
        if (tag == null) {
            return out;
        }
        for (int x = 0; x < tag.func_74745_c(); ++x) {
            IAEFluidStack ais = Util.loadFluidStackFromNBT(tag.func_150305_b(x));
            if (ais == null) continue;
            out.add((IAEStack)ais);
        }
        return out;
    }

    private IItemList<IAEItemStack> readList(NBTTagList tag) {
        IItemList out = AEApi.instance().storage().createItemList();
        if (tag == null) {
            return out;
        }
        for (int x = 0; x < tag.func_74745_c(); ++x) {
            IAEItemStack ais = AEItemStack.loadItemStackFromNBT((NBTTagCompound)tag.func_150305_b(x));
            if (ais == null) continue;
            out.add((IAEStack)ais);
        }
        return out;
    }

    @Override
    public NBTBase writeToNBT() {
        if (this.channel == StorageChannel.ITEMS) {
            return this.writeList(this.items);
        }
        return this.writeFluidList(this.fluids);
    }

    private NBTTagList writeFluidList(IItemList<IAEFluidStack> myList) {
        NBTTagList out = new NBTTagList();
        for (IAEFluidStack ais : myList) {
            out.func_74742_a(this.writeFluid(ais));
        }
        return out;
    }

    private NBTBase writeFluid(IAEFluidStack fluid) {
        NBTTagCompound out = new NBTTagCompound();
        if (fluid != null) {
            fluid.writeToNBT(out);
        }
        return out;
    }

    private NBTTagList writeList(IItemList<IAEItemStack> myList) {
        NBTTagList out = new NBTTagList();
        for (IAEItemStack ais : myList) {
            out.func_74742_a((NBTBase)this.writeItem(ais));
        }
        return out;
    }

    private NBTTagCompound writeItem(IAEItemStack item) {
        NBTTagCompound out = new NBTTagCompound();
        if (item != null) {
            item.writeToNBT(out);
        }
        return out;
    }
}

